/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.sequence;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Counter;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.atomic.Numeric;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.sequence.AbstractSequence;
import io.brackit.query.sequence.BaseIter;

public abstract class FlatteningSequence
extends AbstractSequence {
    private volatile IntNumeric size;
    private volatile Boolean bool;

    protected abstract Sequence sequence(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean booleanValue() {
        Sequence s;
        Boolean b = this.bool;
        if (b != null) {
            return b;
        }
        int i = 0;
        while ((s = this.sequence(i++)) != null) {
            Item first;
            if (s == null) continue;
            if (s instanceof Item) {
                if (s instanceof Node) {
                    this.bool = Boolean.TRUE;
                    return true;
                }
                first = (Item)s;
            } else {
                Iter it = s.iterate();
                try {
                    first = it.next();
                    if (first == null) continue;
                    if (first instanceof Node) {
                        this.bool = Boolean.TRUE;
                        boolean bl = true;
                        return bl;
                    }
                    if (it.next() != null) {
                        throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Effective boolean value is undefined for sequences with two or more items not starting with a node");
                    }
                }
                finally {
                    it.close();
                    continue;
                }
            }
            while ((s = this.sequence(i++)) != null) {
                if (s == null || s.size().eq(Int32.ZERO)) continue;
                throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Effective boolean value is undefined for sequences with two or more items not starting with a node");
            }
            this.bool = first.booleanValue();
            return this.bool;
        }
        this.bool = Boolean.FALSE;
        return this.bool;
    }

    @Override
    public IntNumeric size() {
        Sequence s;
        IntNumeric si = this.size;
        if (si != null) {
            return si;
        }
        si = Int32.ZERO;
        int i = 0;
        while ((s = this.sequence(i++)) != null) {
            si = (IntNumeric)si.add(s.size());
        }
        this.size = si;
        return this.size;
    }

    @Override
    public Item get(IntNumeric pos) {
        Sequence s;
        IntNumeric si = this.size;
        if (si != null && si.cmp(pos) < 0) {
            return null;
        }
        if (Int32.ZERO.cmp(pos) >= 0) {
            return null;
        }
        si = Int32.ZERO;
        int i = 0;
        while ((s = this.sequence(i++)) != null) {
            IntNumeric psi = si;
            if ((si = (IntNumeric)si.add(s.size())).cmp(pos) < 0) continue;
            return s.get((IntNumeric)pos.subtract(psi));
        }
        this.size = si;
        return null;
    }

    @Override
    public Iter iterate() {
        return new FlatteningIter();
    }

    private class FlatteningIter
    extends BaseIter {
        private Sequence s;
        private Iter it;
        private int pos;

        private FlatteningIter() {
        }

        @Override
        public Item next() throws QueryException {
            while (true) {
                if (this.it != null) {
                    Item res = this.it.next();
                    if (res != null) {
                        return res;
                    }
                    this.it.close();
                    this.it = null;
                }
                this.s = FlatteningSequence.this.sequence(this.pos++);
                if (this.s == null) {
                    return null;
                }
                Sequence sequence = this.s;
                if (sequence instanceof Item) {
                    Item item = (Item)sequence;
                    return item;
                }
                this.it = this.s.iterate();
            }
        }

        @Override
        public void skip(IntNumeric i) throws QueryException {
            if (i.cmp(Int32.ZERO) <= 0) {
                return;
            }
            Counter skipped = new Counter();
            if (this.it != null) {
                while (this.next() != null) {
                    if (skipped.inc().cmp(i) < 0) continue;
                    return;
                }
                this.it.close();
                this.it = null;
            }
            Numeric remaining = i.subtract(skipped.asIntNumeric());
            while ((this.s = FlatteningSequence.this.sequence(this.pos++)) != null) {
                IntNumeric size = this.s.size();
                int cmp = remaining.cmp(size);
                if (cmp <= 0) {
                    this.it = this.s.iterate();
                    if (cmp != 0) {
                        this.it.skip((IntNumeric)remaining);
                        break;
                    }
                    this.it.close();
                    this.it = null;
                    break;
                }
                remaining = remaining.subtract(size);
            }
        }

        @Override
        public void close() {
            if (this.it != null) {
                this.it.close();
            }
        }
    }
}

