/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.sequence;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.Counter;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.expr.Cast;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Type;
import io.brackit.query.jdm.type.AtomicType;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.ItemType;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.sequence.BaseIter;
import io.brackit.query.sequence.LazySequence;

public class FunctionConversionSequence
extends LazySequence {
    private static final Int32 TWO = Int32.ZERO_TO_TWENTY[2];
    final SequenceType type;
    final Sequence arg;
    final boolean builtin;
    volatile boolean safe;

    public FunctionConversionSequence(SequenceType type, Sequence arg, boolean builtin) {
        this.type = type;
        this.arg = arg;
        this.builtin = builtin;
    }

    @Override
    public Iter iterate() {
        if (this.safe) {
            return this.arg.iterate();
        }
        Cardinality card = this.type.getCardinality();
        ItemType iType = this.type.getItemType();
        if (iType instanceof AtomicType) {
            return new AtomicTypedIter(card, (AtomicType)iType);
        }
        return new TypedIter(card, iType);
    }

    @Override
    public Item get(IntNumeric pos) {
        Item item = this.arg.get(pos);
        if (this.safe) {
            return item;
        }
        Cardinality card = this.type.getCardinality();
        if (item == null) {
            if (card.moreThanZero()) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Invalid empty typed sequence (expected %s)", new Object[]{card});
            }
        } else {
            if (pos.cmp(Int32.ONE) > 0 && card.atMostOne()) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Invalid cardinality of typed sequence (expected %s): >= %s", new Object[]{card, pos});
            }
            if (pos.cmp(Int32.ZERO) > 0 && card == Cardinality.Zero) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Invalid cardinality of typed sequence (expected %s): >= %s", new Object[]{card, pos});
            }
            if (!this.type.getItemType().matches(item)) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Item of invalid type in typed sequence (expected %s): %s", this.type.getItemType(), item);
            }
        }
        return item;
    }

    public static Sequence asTypedSequence(SequenceType sType, Sequence s, boolean builtin) {
        if (s == null) {
            if (sType.getCardinality().moreThanZero()) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Invalid empty-sequence()");
            }
            return null;
        }
        if (s instanceof Item) {
            ItemType iType = sType.getItemType();
            if (iType instanceof AtomicType) {
                Atomic atomic = ((Item)s).atomize();
                Type expected = ((AtomicType)iType).getType();
                Type type = atomic.type();
                if (type == Type.UNA && expected != Type.UNA) {
                    if (builtin && expected.isNumeric()) {
                        atomic = Cast.cast(null, atomic, expected, false);
                    } else {
                        if (expected.instanceOf(Type.QNM) || expected.instanceOf(Type.NOT)) {
                            throw new QueryException(ErrorCode.ERR_TYPE_CAST_TO_NAMESPACE_SENSITIVE_TYPE, "Cannot cast %s to namespace-sensitive type %s", type, expected);
                        }
                        atomic = Cast.cast(null, atomic, expected, false);
                    }
                } else if (!iType.matches(atomic)) {
                    if (expected.isNumeric() && type.isNumeric()) {
                        atomic = Cast.cast(null, atomic, expected, false);
                    } else if (expected.instanceOf(Type.STR) && type.instanceOf(Type.AURI)) {
                        atomic = Cast.cast(null, atomic, expected, false);
                    } else {
                        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Item of invalid atomic type in typed sequence (expected %s): %s", iType, atomic);
                    }
                }
                return atomic;
            }
            if (!iType.matches((Item)s)) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Item of invalid type in typed sequence (expected %s): %s", iType, s);
            }
            return s;
        }
        FunctionConversionSequence ts = new FunctionConversionSequence(sType, s, builtin);
        if (sType.getCardinality().atMostOne()) {
            try (Iter it = ts.iterate();){
                Item item = it.next();
                return item;
            }
        }
        return ts;
    }

    private final class AtomicTypedIter
    extends BaseIter {
        final Cardinality card;
        final AtomicType iType;
        final Type expected;
        Counter pos = new Counter();
        Iter s;

        AtomicTypedIter(Cardinality card, AtomicType iType) {
            this.card = card;
            this.iType = iType;
            this.expected = iType.getType();
        }

        @Override
        public Item next() {
            Item item;
            if (this.s == null) {
                this.s = FunctionConversionSequence.this.arg.iterate();
            }
            if ((item = this.s.next()) == null) {
                if (this.pos.cmp(Int32.ZERO) == 0 && this.card.moreThanZero()) {
                    throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Invalid empty typed sequence (expected %s)", new Object[]{this.card});
                }
                FunctionConversionSequence.this.safe = true;
                return null;
            }
            this.pos.inc();
            if (this.card == Cardinality.Zero || this.pos.cmp(TWO) == 0 && this.card.atMostOne()) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Invalid cardinality of typed sequence (expected %s): >= %s", new Object[]{this.card, this.pos});
            }
            Atomic atomic = item.atomize();
            Type type = atomic.type();
            if (type == Type.UNA && this.expected != Type.UNA) {
                if (FunctionConversionSequence.this.builtin && this.expected.isNumeric()) {
                    atomic = Cast.cast(null, atomic, Type.DBL, false);
                } else {
                    if (this.expected.instanceOf(Type.QNM) || this.expected.instanceOf(Type.NOT)) {
                        throw new QueryException(ErrorCode.ERR_TYPE_CAST_TO_NAMESPACE_SENSITIVE_TYPE, "Cannot cast %s to namespace-sensitive type %s", type, this.expected);
                    }
                    atomic = Cast.cast(null, atomic, this.expected, false);
                }
            } else if (!this.iType.matches(atomic)) {
                if (this.expected.isNumeric() && type.isNumeric()) {
                    atomic = Cast.cast(null, atomic, this.expected, false);
                } else if (this.expected.instanceOf(Type.STR) && type.instanceOf(Type.AURI)) {
                    atomic = Cast.cast(null, atomic, this.expected, false);
                } else {
                    throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Item of invalid atomic type in typed sequence (expected %s): %s", this.iType, atomic);
                }
            }
            return atomic;
        }

        @Override
        public void skip(IntNumeric i) {
            if (this.s == null) {
                this.s = FunctionConversionSequence.this.arg.iterate();
            }
            this.s.skip(i);
        }

        @Override
        public void close() {
            if (this.s != null) {
                this.s.close();
            }
        }
    }

    private final class TypedIter
    extends BaseIter {
        final Cardinality card;
        final ItemType iType;
        Counter pos = new Counter();
        Iter s;

        TypedIter(Cardinality card, ItemType iType) {
            this.card = card;
            this.iType = iType;
        }

        @Override
        public Item next() {
            Item item;
            if (this.s == null) {
                this.s = FunctionConversionSequence.this.arg.iterate();
            }
            if ((item = this.s.next()) == null) {
                if (this.pos.cmp(Int32.ZERO) == 0 && this.card.moreThanZero()) {
                    throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Invalid empty typed sequence (expected %s)", new Object[]{this.card});
                }
                FunctionConversionSequence.this.safe = true;
                return null;
            }
            this.pos.inc();
            if (this.card == Cardinality.Zero || this.pos.cmp(TWO) == 0 && this.card.atMostOne()) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Invalid cardinality of typed sequence (expected %s): >= %s", new Object[]{this.card, this.pos});
            }
            if (!this.iType.matches(item)) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Item of invalid type %s in typed sequence (expected %s): %s", item.itemType(), this.iType, item);
            }
            return item;
        }

        @Override
        public void skip(IntNumeric i) {
            if (this.s == null) {
                this.s = FunctionConversionSequence.this.arg.iterate();
            }
            this.s.skip(i);
        }

        @Override
        public void close() {
            if (this.s != null) {
                this.s.close();
            }
        }
    }
}

