/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.sequence;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Stream;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.sequence.BaseIter;
import io.brackit.query.sequence.LazySequence;
import io.brackit.query.util.sort.TupleSort;
import java.util.Comparator;

public class SortedNodeSequence
extends LazySequence {
    private final Comparator<Tuple> cmp;
    private final Sequence in;
    private final boolean dedup;

    public SortedNodeSequence(Comparator<Tuple> cmp, Sequence in, boolean dedup) {
        this.cmp = cmp;
        this.in = in;
        this.dedup = dedup;
    }

    @Override
    public Iter iterate() {
        return new BaseIter(){
            final TupleSort sort;
            final Sequence source;
            Stream<? extends Tuple> sorted;
            Node<?> p;
            Node<?> n;
            {
                this.sort = new TupleSort(SortedNodeSequence.this.cmp, -1L);
                this.source = SortedNodeSequence.this.in;
            }

            @Override
            public Item next() {
                if (this.sorted == null) {
                    this.loadAndSort();
                    this.sorted = this.sort.stream();
                    this.n = (Node)this.sorted.next();
                }
                if (this.n != null) {
                    if (SortedNodeSequence.this.dedup && this.p != null && this.p.cmp(this.n) == 0) {
                        this.n = (Node)this.sorted.next();
                    }
                    Node<?> deliver = this.n;
                    this.p = this.n;
                    this.n = (Node)this.sorted.next();
                    return deliver;
                }
                return null;
            }

            @Override
            public void close() {
                if (this.sorted != null) {
                    this.sorted.close();
                }
            }

            private void loadAndSort() {
                this.loadSorter(this.source, this.sort);
            }

            private void loadSorter(Sequence sequence, TupleSort sort) {
                if (sequence instanceof Item) {
                    if (!(sequence instanceof Node)) {
                        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal atomic item found in sequence: '%s'", sequence);
                    }
                    sort.add(sequence);
                } else {
                    try (Iter it = sequence.iterate();){
                        Item item;
                        while ((item = it.next()) != null) {
                            if (!(item instanceof Node)) {
                                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal atomic item found in sequence: '%s'", item);
                            }
                            sort.add(item);
                        }
                    }
                }
                sort.sort();
            }
        };
    }
}

