/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.update;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.QNm;
import io.brackit.query.expr.ConstructedNodeBuilder;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.module.StaticContext;
import io.brackit.query.update.op.RenameOp;
import java.util.EnumSet;

public class Rename
extends ConstructedNodeBuilder
implements Expr {
    private static final EnumSet<Kind> renameNodeKind = EnumSet.of(Kind.ELEMENT, Kind.ATTRIBUTE, Kind.PROCESSING_INSTRUCTION);
    private final StaticContext sctx;
    private final Expr sourceExpr;
    private final Expr targetExpr;

    public Rename(StaticContext sctx, Expr sourceExpr, Expr targetExpr) {
        this.sctx = sctx;
        this.sourceExpr = sourceExpr;
        this.targetExpr = targetExpr;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Item targetItem;
        Sequence target = this.targetExpr.evaluate(ctx, tuple);
        if (target == null) {
            throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
        }
        if (target instanceof Item) {
            targetItem = (Item)target;
        } else {
            try (Iter it = target.iterate();){
                targetItem = it.next();
                if (targetItem == null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
                }
                if (it.next() != null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_RENAME_TARGET_NOT_A_EAP_NODE);
                }
            }
        }
        if (!(targetItem instanceof Node)) {
            throw new QueryException(ErrorCode.ERR_UPDATE_RENAME_TARGET_NOT_A_EAP_NODE, "Target item is atomic value %s", targetItem);
        }
        Node node = (Node)targetItem;
        if (!renameNodeKind.contains((Object)node.getKind())) {
            throw new QueryException(ErrorCode.ERR_UPDATE_RENAME_TARGET_NOT_A_EAP_NODE, "Target node kind is not allowed for rename node: %s", new Object[]{node.getKind()});
        }
        Item nameItem = this.sourceExpr.evaluateToItem(ctx, tuple);
        QNm name = node.getKind() == Kind.ELEMENT ? this.buildElementName(this.sctx, nameItem) : (node.getKind() == Kind.ATTRIBUTE ? this.buildAttributeName(this.sctx, nameItem) : this.buildPITarget(nameItem));
        ctx.addPendingUpdate(new RenameOp(node, name));
        return null;
    }

    @Override
    public boolean isUpdating() {
        return true;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

