/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.update.json;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.expr.ConstructedNodeBuilder;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.json.Object;
import io.brackit.query.update.json.op.RenameRecordFieldOp;

public final class RenameJsonField
extends ConstructedNodeBuilder
implements Expr {
    private final Expr oldFieldNameExpr;
    private final Expr targetExpr;
    private final Expr newFieldNameExpr;

    public RenameJsonField(Expr targetExpr, Expr oldFieldNameExpr, Expr newFieldNameExpr) {
        this.targetExpr = targetExpr;
        this.oldFieldNameExpr = oldFieldNameExpr;
        this.newFieldNameExpr = newFieldNameExpr;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) throws QueryException {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) throws QueryException {
        Item targetItem;
        Sequence target = this.targetExpr.evaluate(ctx, tuple);
        if (target == null) {
            throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
        }
        if (target instanceof Item) {
            targetItem = (Item)target;
        } else {
            try (Iter it = target.iterate();){
                targetItem = it.next();
                if (targetItem == null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
                }
                if (it.next() != null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_REPLACE_TARGET_NOT_A_EATCP_NODE);
                }
            }
        }
        if (!(targetItem instanceof Object)) {
            throw new QueryException(ErrorCode.ERR_UPDATE_REPLACE_TARGET_NOT_A_EATCP_NODE, "Target item is atomic value %s", targetItem);
        }
        Object objectItem = (Object)targetItem;
        QNm oldFieldName = (QNm)this.oldFieldNameExpr.evaluateToItem(ctx, tuple);
        QNm newFieldName = new QNm(((Str)this.newFieldNameExpr.evaluateToItem(ctx, tuple)).stringValue());
        ctx.addPendingUpdate(new RenameRecordFieldOp(objectItem, oldFieldName, newFieldName));
        return null;
    }

    @Override
    public boolean isUpdating() {
        return true;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

