/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.update.json;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.QNm;
import io.brackit.query.expr.ConstructedNodeBuilder;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.json.Array;
import io.brackit.query.jdm.json.JsonItem;
import io.brackit.query.jdm.json.Object;
import io.brackit.query.update.json.op.ReplaceArrayValueOp;
import io.brackit.query.update.json.op.ReplaceRecordValueOp;

public final class ReplaceJsonValue
extends ConstructedNodeBuilder
implements Expr {
    private final Expr sourceExpr;
    private final Expr targetExpr;
    private final Expr recordFieldOrArrayIndex;

    public ReplaceJsonValue(Expr sourceExpr, Expr targetExpr, Expr recordFieldOrArrayIndex) {
        this.sourceExpr = sourceExpr;
        this.targetExpr = targetExpr;
        this.recordFieldOrArrayIndex = recordFieldOrArrayIndex;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) throws QueryException {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) throws QueryException {
        Item targetItem;
        Sequence target = this.targetExpr.evaluate(ctx, tuple);
        if (target == null) {
            throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
        }
        if (target instanceof Item) {
            targetItem = (Item)target;
        } else {
            try (Iter it = target.iterate();){
                targetItem = it.next();
                if (targetItem == null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
                }
                if (it.next() != null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_REPLACE_TARGET_NOT_A_EATCP_NODE);
                }
            }
        }
        if (!(targetItem instanceof JsonItem)) {
            throw new QueryException(ErrorCode.ERR_UPDATE_REPLACE_TARGET_NOT_A_EATCP_NODE, "Target item is atomic value %s", targetItem);
        }
        Item recordFieldOrArrayIndexSeq = this.recordFieldOrArrayIndex.evaluateToItem(ctx, tuple);
        Item source = this.sourceExpr.evaluateToItem(ctx, tuple);
        if (target instanceof Array) {
            Int32 index = (Int32)recordFieldOrArrayIndexSeq;
            ctx.addPendingUpdate(new ReplaceArrayValueOp((Array)target, index.intValue(), source));
        } else {
            QNm field = (QNm)recordFieldOrArrayIndexSeq;
            ctx.addPendingUpdate(new ReplaceRecordValueOp((Object)target, field, source));
        }
        return null;
    }

    @Override
    public boolean isUpdating() {
        return true;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

