/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.update.op;

import io.brackit.query.QueryException;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.update.op.UpdateOp;
import java.util.Arrays;

public abstract class AbstractInsertOp
implements UpdateOp {
    private final Node<?> target;
    private Node<?>[] content;
    private int size;

    public AbstractInsertOp(Node<?> target) {
        this.target = target;
        this.content = new Node[1];
    }

    @Override
    public void apply() {
        for (int i = 0; i < this.size; ++i) {
            this.doInsert(this.target, this.content[i]);
        }
    }

    @Override
    public Node<?> getTarget() {
        return this.target;
    }

    public void addContent(Node<?> node) {
        if (this.size == this.content.length) {
            this.content = Arrays.copyOf(this.content, this.content.length * 3 / 2 + 1);
        }
        this.content[this.size++] = node;
    }

    protected abstract void doInsert(Node<?> var1, Node<?> var2) throws QueryException;

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append((Object)this.getType());
        out.append(" {");
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                out.append(", ");
            }
            out.append(this.content[i]);
        }
        out.append("} on ");
        out.append(this.target);
        return out.toString();
    }
}

