/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util;

public class Whitespace {
    public static String replace(String str) {
        char c;
        int pos;
        int end = str.length();
        for (pos = 0; pos < end && ((c = str.charAt(pos)) == '\r' || c == '\t' || c == '\n'); ++pos) {
        }
        if (pos == end) {
            return str;
        }
        char[] chars = str.toCharArray();
        StringBuilder buf = new StringBuilder(end);
        buf.append(chars, 0, pos);
        while (pos < end) {
            if ((c = chars[pos++]) == '\r' || c == '\t' || c == '\n') {
                buf.append(' ');
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String collapseTrimOnly(String str) {
        char c;
        int start;
        int length;
        int end = length = str.length();
        for (start = 0; start < length && ((c = str.charAt(start)) == ' ' || c == '\r' || c == '\t' || c == '\n'); ++start) {
        }
        while (end > start && ((c = str.charAt(end - 1)) == ' ' || c == '\r' || c == '\t' || c == '\n')) {
            --end;
        }
        return start == 0 && end == length ? str : str.substring(start, end);
    }

    public static String collapse(String str) {
        int pos;
        int c;
        int start;
        int length;
        int end = length = str.length();
        for (start = 0; start < length && ((c = str.charAt(start)) == 32 || c == 13 || c == 9 || c == 10); ++start) {
        }
        while (end > start && ((c = str.charAt(end - 1)) == 32 || c == 13 || c == 9 || c == 10)) {
            --end;
        }
        int p = 0;
        for (pos = start; pos < end && (c = str.charAt(pos)) != 13 && c != 9 && c != 10 && (c != 32 || c != p); ++pos) {
            p = c;
        }
        if (pos == end) {
            return start == 0 && end == length ? str : str.substring(start, end);
        }
        char[] chars = str.toCharArray();
        StringBuilder buf = new StringBuilder(end);
        buf.append(chars, start, pos - start);
        while (pos < end) {
            if ((c = chars[pos++]) == 13 || c == 9 || c == 10 || c == 32) {
                if (p != 32) {
                    buf.append(' ');
                }
                p = 32;
                continue;
            }
            buf.append((char)c);
            p = c;
        }
        return buf.toString();
    }

    public static String fullcollapse(String str) {
        int pos;
        char c;
        int start;
        int length;
        int end = length = str.length();
        for (start = 0; start < length && ((c = str.charAt(start)) == ' ' || c == '\r' || c == '\t' || c == '\n'); ++start) {
        }
        while (end > start && ((c = str.charAt(end - 1)) == ' ' || c == '\r' || c == '\t' || c == '\n')) {
            --end;
        }
        for (pos = start; pos < end && (c = str.charAt(pos)) != '\r' && c != '\t' && c != '\n' && c != ' '; ++pos) {
        }
        if (pos == end) {
            return start == 0 && end == length ? str : str.substring(start, end);
        }
        char[] chars = str.toCharArray();
        StringBuilder buf = new StringBuilder(end);
        buf.append(chars, start, pos);
        while (pos < end) {
            if ((c = chars[pos++]) == ' ' || c == '\r' || c == '\t' || c == '\n') continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static String trimBoundaryWS(String str, boolean fromHead, boolean fromTail) {
        char c;
        int start;
        int end = str.length();
        int trimTo = str.length();
        if (fromHead) {
            for (start = 0; start < trimTo && ((c = str.charAt(start)) == ' ' || c == '\n' || c == '\t' || c == '\r'); ++start) {
            }
        }
        if (fromTail) {
            while (trimTo > start && ((c = str.charAt(trimTo - 1)) == ' ' || c == '\n' || c == '\t' || c == '\r')) {
                --trimTo;
            }
        }
        return start != 0 || end != trimTo ? str.substring(start, trimTo) : str;
    }

    public static String normalizeXML11(String str) {
        char c;
        int pos;
        int end = str.length();
        for (pos = 0; pos < end && (c = str.charAt(pos)) != '\r' && c != '\u0085' && c != '\u2028'; ++pos) {
        }
        if (pos == end) {
            return str;
        }
        char[] chars = str.toCharArray();
        StringBuilder buf = new StringBuilder(end);
        buf.append(chars, 0, pos);
        while (pos < end) {
            if ((c = chars[pos++]) == '\r') {
                if (pos < end && (chars[pos] == '\n' || chars[pos] == '\u0085')) {
                    ++pos;
                }
                buf.append('\n');
                continue;
            }
            if (c == '\u0085' || c == '\u2028') {
                buf.append('\n');
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String normalizeXML10(String str) {
        char c;
        int pos;
        int end = str.length();
        for (pos = 0; pos < end && (c = str.charAt(pos)) != '\r'; ++pos) {
        }
        if (pos == end) {
            return str;
        }
        char[] chars = str.toCharArray();
        StringBuilder buf = new StringBuilder(end);
        buf.append(chars, 0, pos);
        while (pos < end) {
            if ((c = chars[pos++]) == '\r') {
                if (pos < end && chars[pos] == '\n') {
                    ++pos;
                }
                buf.append('\n');
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static boolean isWS(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == ' ' || c == '\n' || c == '\t' || c == '\r') continue;
            return false;
        }
        return true;
    }
}

