/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.aggregator;

import io.brackit.query.util.aggregator.Aggregator;
import io.brackit.query.util.aggregator.CountAggregator;
import io.brackit.query.util.aggregator.MinMaxAggregator;
import io.brackit.query.util.aggregator.SequenceAggregator;
import io.brackit.query.util.aggregator.SingleAggregator;
import io.brackit.query.util.aggregator.SumAvgAggregator;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Aggregate {
    SEQUENCE{

        @Override
        public Aggregator aggregator() {
            return new SequenceAggregator();
        }
    }
    ,
    COUNT{

        @Override
        public Aggregator aggregator() {
            return new CountAggregator();
        }
    }
    ,
    SUM{

        @Override
        public Aggregator aggregator() {
            return new SumAvgAggregator(false, null);
        }
    }
    ,
    AVG{

        @Override
        public Aggregator aggregator() {
            return new SumAvgAggregator(true, null);
        }
    }
    ,
    MIN{

        @Override
        public Aggregator aggregator() {
            return new MinMaxAggregator(true);
        }
    }
    ,
    MAX{

        @Override
        public Aggregator aggregator() {
            return new MinMaxAggregator(false);
        }
    }
    ,
    SINGLE{

        @Override
        public Aggregator aggregator() {
            return new SingleAggregator();
        }
    };


    public abstract Aggregator aggregator();
}

