/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.forkjoin;

import io.brackit.query.util.forkjoin.Deque;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class CASDeque<E>
implements Deque<E> {
    private static final int INITIAL_QUEUE_CAPACITY = 64;
    private static final int MAXIMUM_QUEUE_CAPACITY = Integer.MIN_VALUE;
    private volatile int queueBase;
    private volatile int queueTop;
    private volatile AtomicReferenceArray<E> queue = new AtomicReferenceArray(64);

    CASDeque() {
    }

    @Override
    public void add(E t) {
        E x;
        AtomicReferenceArray<E> q = this.queue;
        Object[] tmp = new Object[q.length()];
        int len = 0;
        while ((x = this.poll()) != null) {
            tmp[len++] = x;
        }
        this.push(t);
        for (int i = len - 1; i >= 0; --i) {
            this.push(tmp[i]);
        }
    }

    @Override
    public void push(E t) {
        AtomicReferenceArray<E> q = this.queue;
        if (q != null) {
            int s = this.queueTop;
            int m = q.length() - 1;
            int i = s & m;
            q.set(i, t);
            this.queueTop = s + 1;
            if ((s -= this.queueBase) == m) {
                this.growQueue();
            }
        }
    }

    @Override
    public E poll() {
        int m;
        AtomicReferenceArray<E> q = this.queue;
        if (q != null && (m = q.length() - 1) >= 0) {
            int i;
            E t;
            int s;
            while ((s = this.queueTop) != this.queueBase && (t = q.get(i = m & --s)) != null) {
                if (!q.compareAndSet(i, t, null)) continue;
                this.queueTop = s;
                return t;
            }
        }
        return null;
    }

    @Override
    public E pollLast() {
        E t;
        int i;
        AtomicReferenceArray<E> q;
        int b = this.queueBase;
        if (this.queueTop != b && (q = this.queue) != null && (i = q.length() - 1 & b) >= 0 && (t = q.get(i)) != null && this.queueBase == b && q.compareAndSet(i, t, null)) {
            this.queueBase = b + 1;
            return t;
        }
        return null;
    }

    private void growQueue() {
        int oldMask;
        int size;
        AtomicReferenceArray<E> oldQ = this.queue;
        int n = size = oldQ != null ? oldQ.length() << 1 : 64;
        if (size > Integer.MIN_VALUE) {
            throw new RuntimeException("Queue capacity exceeded");
        }
        if (size < 64) {
            size = 64;
        }
        this.queue = new AtomicReferenceArray<E>(size);
        AtomicReferenceArray<E> q = this.queue;
        int mask = size - 1;
        int top = this.queueTop;
        if (oldQ != null && (oldMask = oldQ.length() - 1) >= 0) {
            for (int b = this.queueBase; b != top; ++b) {
                int oldI = b & oldMask;
                E t = oldQ.get(oldI);
                if (t == null || !oldQ.compareAndSet(b & oldMask, t, null)) continue;
                int i = b & mask;
                q.set(i, t);
            }
        }
    }

    @Override
    public int size() {
        throw new RuntimeException("Not implemented yet");
    }
}

