/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.forkjoin;

import io.brackit.query.util.forkjoin.Deque;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class CircularDeque<E>
implements Deque<E> {
    private static final AtomicLongFieldUpdater<CircularDeque> UPDATER = AtomicLongFieldUpdater.newUpdater(CircularDeque.class, "top");
    private static final int INITIAL_CAPACITY = 6;
    private volatile long bottom;
    private volatile long top;
    private volatile CircularArray<E> activeArray;

    CircularDeque() {
        this.activeArray = new CircularArray(6);
    }

    CircularDeque(int maxCapacity) {
        int c;
        for (c = 1; c < maxCapacity; c <<= 1) {
        }
        this.activeArray = new CircularArray(c);
    }

    @Override
    public void add(E o) {
        E x;
        CircularArray<E> a = this.activeArray;
        Object[] tmp = new Object[(int)a.size()];
        int len = 0;
        while ((x = this.poll()) != null) {
            tmp[len++] = x;
        }
        this.push(o);
        for (int i = len - 1; i >= 0; --i) {
            this.push(tmp[i]);
        }
    }

    @Override
    public void push(E o) {
        long b = this.bottom;
        long t = this.top;
        long size = b - t;
        CircularArray<E> a = this.activeArray;
        if (size >= a.size() - 1L) {
            a = a.grow(b, t);
            this.activeArray = a;
        }
        a.put(b, o);
        this.bottom = b + 1L;
    }

    @Override
    public E poll() {
        long b = this.bottom;
        CircularArray<E> a = this.activeArray;
        this.bottom = --b;
        long t = this.top;
        long size = b - t;
        if (size < 0L) {
            this.bottom = t;
            return null;
        }
        E o = a.get(b);
        if (size > 0L) {
            return o;
        }
        if (!UPDATER.compareAndSet(this, t, t + 1L)) {
            o = null;
        }
        this.bottom = t + 1L;
        return o;
    }

    @Override
    public E pollLast() {
        long t = this.top;
        long b = this.bottom;
        CircularArray<E> a = this.activeArray;
        long size = b - t;
        if (size <= 0L) {
            return null;
        }
        E o = a.get(t);
        if (!UPDATER.compareAndSet(this, t, t + 1L)) {
            return null;
        }
        return o;
    }

    @Override
    public int size() {
        long t = this.top;
        long b = this.bottom;
        return (int)(b - t);
    }

    static class CircularArray<E> {
        private final int log_size;
        private final Object[] segment;

        CircularArray(int log_size) {
            this.log_size = log_size;
            this.segment = new Object[1 << this.log_size];
        }

        long size() {
            return 1L << this.log_size;
        }

        E get(long i) {
            return (E)this.segment[(int)(i % this.size())];
        }

        void put(long i, E o) {
            this.segment[(int)(i % this.size())] = o;
        }

        CircularArray<E> grow(long b, long t) {
            CircularArray<E> a = new CircularArray<E>(this.log_size + 1);
            for (long i = t; i < b; ++i) {
                a.put(i, this.get(i));
            }
            return a;
        }
    }
}

