/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.forkjoin;

import io.brackit.query.util.forkjoin.Task;
import io.brackit.query.util.forkjoin.Worker;
import io.brackit.query.util.forkjoin.WorkerFactory;
import io.brackit.query.util.forkjoin.WorkerStats;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.LockSupport;

public class Pool {
    private static final boolean LOG = false;
    private final Random rnd = new Random();
    private final int size;
    private final Worker[] workers;
    private final ConcurrentLinkedQueue<Worker> inactive;
    private final ConcurrentLinkedQueue<Task> queue;

    public Pool(int size, WorkerFactory factory) {
        int i;
        this.size = size;
        this.inactive = new ConcurrentLinkedQueue();
        this.queue = new ConcurrentLinkedQueue();
        this.workers = new Worker[size];
        for (i = 0; i < size; ++i) {
            this.workers[i] = factory.newThread(this);
            this.workers[i].setDaemon(true);
        }
        for (i = 0; i < size; ++i) {
            this.workers[i].start();
        }
    }

    public int getSize() {
        return this.size;
    }

    public void signalWork() {
        Worker w = this.inactive.poll();
        if (w != null) {
            LockSupport.unpark(w);
        }
    }

    Task stealTask(Worker stealer) {
        Task t;
        if (stealer.victim != null && (t = stealer.victim.steal()) != null) {
            ++stealer.stats.stealCnt;
            ++stealer.victim.stats.robbedCnt;
            return t;
        }
        for (Worker w : this.workers) {
            t = w.steal();
            if (t == null) continue;
            stealer.victim = w;
            ++stealer.stats.stealCnt;
            ++stealer.victim.stats.robbedCnt;
            return t;
        }
        stealer.victim = null;
        return null;
    }

    public Task submit(Task task) {
        Thread me = Thread.currentThread();
        if (me instanceof Worker) {
            ((Worker)me).fork(task);
            return task;
        }
        Worker w = this.inactive.poll();
        if (w != null) {
            w.push(task);
            LockSupport.unpark(w);
        } else {
            w = this.workers[this.rnd.nextInt(this.size)];
            w.push(task);
            LockSupport.unpark(w);
        }
        return task;
    }

    public boolean dispatch(Task task) {
        Worker w = this.inactive.poll();
        if (w != null) {
            w.push(task);
            LockSupport.unpark(w);
            return true;
        }
        this.queue.add(task);
        return false;
    }

    void join(Worker w, Task join, boolean serial) {
        if (serial && this.exec(w, join)) {
            this.queue.remove(join);
            return;
        }
        int retry = 0;
        while (join.status <= 0) {
            Task t;
            if (serial && (t = this.queue.poll()) != null) {
                t.exec();
                retry = 0;
                continue;
            }
            t = w.poll();
            if (t != null) {
                this.exec(w, t);
                retry = 0;
                continue;
            }
            t = this.stealTask(w);
            if (t != null) {
                t.exec();
                retry = 0;
                continue;
            }
            if (!serial && (t = this.queue.poll()) != null) {
                t.exec();
                retry = 0;
                continue;
            }
            if (++retry != 16) continue;
            ++w.stats.joinParkCnt;
            join.park(w);
            retry = 0;
        }
        ++w.stats.joinCnt;
    }

    void run(Worker w) {
        int retry = 0;
        while (!w.isTerminate()) {
            Task t = w.poll();
            if (t != null) {
                this.exec(w, t);
                retry = 0;
                continue;
            }
            t = this.stealTask(w);
            if (t != null) {
                t.exec();
                retry = 0;
                continue;
            }
            t = this.queue.poll();
            if (t != null) {
                t.exec();
                retry = 0;
                continue;
            }
            if (++retry == 64) {
                this.inactive.add(w);
                t = w.poll();
                if (t == null) {
                    ++w.stats.parkCnt;
                    LockSupport.park();
                } else {
                    this.exec(w, t);
                }
                retry = 0;
                continue;
            }
            if (retry % 16 != 0) continue;
        }
    }

    private boolean exec(Worker w, Task t) {
        long start = System.currentTimeMillis();
        boolean executed = t.exec();
        long end = System.currentTimeMillis();
        if (executed) {
            ++w.stats.execCnt;
            w.stats.execTime += end - start;
        }
        return executed;
    }

    public List<WorkerStats> getStats() {
        ArrayList<WorkerStats> stats = new ArrayList<WorkerStats>(this.workers.length);
        for (Worker w : this.workers) {
            stats.add(w.stats);
        }
        return stats;
    }

    public void shutdown() {
        for (Worker w : this.workers) {
            w.setTerminate(true);
            LockSupport.unpark(w);
        }
    }
}

