/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.forkjoin;

import io.brackit.query.util.forkjoin.Deque;
import io.brackit.query.util.forkjoin.Pool;
import io.brackit.query.util.forkjoin.SyncDeque;
import io.brackit.query.util.forkjoin.Task;
import io.brackit.query.util.forkjoin.WorkerStats;

public class Worker
extends Thread {
    private final Pool pool;
    private volatile Deque<Task> deque;
    private volatile boolean terminate;
    Worker victim;
    final WorkerStats stats;

    protected Worker(Pool pool, int no) {
        super("FJWorker:" + no);
        this.setDaemon(true);
        this.stats = new WorkerStats(this.getId());
        this.pool = pool;
        this.deque = new SyncDeque<Task>();
    }

    void fork(Task task) {
        ++this.stats.forkCnt;
        this.deque.push(task);
        this.pool.signalWork();
    }

    public void adopt(Deque<Task> queue) {
        boolean adopted = false;
        Task t = queue.poll();
        while (t != null) {
            this.deque.add(t);
            ++this.stats.adoptCnt;
            adopted = true;
            t = queue.poll();
        }
        if (adopted) {
            this.pool.signalWork();
        }
    }

    void push(Task task) {
        this.deque.push(task);
    }

    Task poll() {
        Task task = this.deque.poll();
        return task;
    }

    Task pollLast() {
        return this.deque.pollLast();
    }

    Task steal() {
        return this.deque.size() > 1 ? this.deque.pollLast() : null;
    }

    @Override
    public void run() {
        this.pool.run(this);
    }

    void join(Task t, boolean serial) {
        this.pool.join(this, t, serial);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public Deque<Task> getQueue() {
        return this.deque;
    }

    public void dropQueue() {
        this.deque = new SyncDeque<Task>();
    }

    boolean isTerminate() {
        return this.terminate;
    }

    void setTerminate(boolean terminate) {
        this.terminate = terminate;
    }
}

