/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.join;

import java.util.Arrays;

public class FastList<E> {
    public static final FastList<Object> EMPTY_LIST = new FastList(0);
    private Object[] values;
    private int size;

    public FastList(int size) {
        this.values = new Object[size];
    }

    public FastList() {
        this.values = new Object[10];
    }

    public static <T> FastList<T> emptyList() {
        return EMPTY_LIST;
    }

    public int getSize() {
        return this.size;
    }

    public E get(int p) {
        return (E)this.values[p];
    }

    public void addAll(E[] v, int off, int len) {
        this.capacity(this.size + len);
        System.arraycopy(v, off, this.values, this.size, len);
        this.size += len;
    }

    public void addAllSafe(Object[] v, int off, int len) {
        this.capacity(this.size + len);
        System.arraycopy(v, off, this.values, this.size, len);
        this.size += len;
    }

    private void capacity(int capacity) {
        if (this.values.length < capacity) {
            this.values = Arrays.copyOf(this.values, capacity);
        }
    }

    public void sort() {
        Arrays.sort(this.values, 0, this.size);
    }

    public void add(E v) {
        if (this.size == this.values.length) {
            this.values = Arrays.copyOf(this.values, this.values.length * 3 / 2 + 1);
        }
        this.values[this.size++] = v;
    }

    public void addUnchecked(E v) {
        this.values[this.size++] = v;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void ensureAdditional(int len) {
        this.capacity(this.size + len);
    }
}

