/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.join;

import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.expr.Cast;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Type;
import io.brackit.query.util.Cmp;
import io.brackit.query.util.join.AbstractJoinTable;
import io.brackit.query.util.join.FastList;
import io.brackit.query.util.join.HashJoinTable;
import io.brackit.query.util.join.SortedJoinTable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MultiTypeJoinTable {
    private final Cmp cmp;
    private final boolean isGCmp;
    private final boolean skipSort;
    private final Map<Type, AbstractJoinTable> tables = new HashMap<Type, AbstractJoinTable>();
    private final Set<Type> convertedUntypedAtomic = new HashSet<Type>();
    private final Set<Type> nonNumericTypes = new HashSet<Type>();
    private boolean convertedUntypedAtomicToDbl;
    private boolean promotedNumericToDbl;
    private boolean promotedNumericToFlo;
    private boolean promotedNumericToDec;
    private boolean numericPresent;

    public MultiTypeJoinTable(Cmp cmp, boolean isGCmp, boolean skipSort) {
        this.cmp = cmp;
        this.isGCmp = isGCmp;
        this.skipSort = skipSort;
    }

    private AbstractJoinTable createTable() {
        return this.cmp == Cmp.eq ? new HashJoinTable() : new SortedJoinTable(this.cmp);
    }

    private void addItem(Item key, Sequence[] bindings, int pos) throws QueryException {
        AbstractJoinTable table;
        Atomic atomic = key.atomize();
        Type type = atomic.type().getPrimitiveBase();
        if (!this.isGCmp && type == Type.UNA) {
            atomic = Cast.cast(null, atomic, Type.STR, false);
            type = Type.STR;
        }
        if ((table = this.tables.get(type)) == null) {
            table = this.createTable();
            this.tables.put(type, table);
        }
        table.add(atomic, pos, bindings);
        if (type.isNumeric()) {
            this.numericPresent = true;
        } else {
            this.nonNumericTypes.add(type);
        }
    }

    private void probeItem(FastList<AbstractJoinTable.TValue> matches, Item key) throws QueryException {
        Atomic atomic = key.atomize();
        Type type = atomic.type().getPrimitiveBase();
        if (!this.isGCmp && type == Type.UNA) {
            atomic = Cast.cast(null, atomic, Type.STR, false);
            type = Type.STR;
        }
        if (type == Type.UNA) {
            for (Type nnType : this.nonNumericTypes) {
                this.probeAtomic(matches, Cast.cast(null, atomic, nnType, false), nnType);
            }
            if (this.numericPresent) {
                if (!this.promotedNumericToDbl) {
                    this.addToTable(Type.INR, Type.DBL);
                    this.addToTable(Type.DEC, Type.DBL);
                    this.addToTable(Type.FLO, Type.DBL);
                    this.promotedNumericToDbl = true;
                }
                this.probeAtomic(matches, Cast.cast(null, atomic, Type.DBL, false), Type.DBL);
            }
        } else if (type.isNumeric()) {
            if (!this.convertedUntypedAtomicToDbl) {
                this.addToTable(Type.UNA, Type.DBL);
                this.convertedUntypedAtomicToDbl = true;
            }
            if (type == Type.DBL && !this.promotedNumericToDbl) {
                this.addToTable(Type.INR, Type.DBL);
                this.addToTable(Type.DEC, Type.DBL);
                this.addToTable(Type.FLO, Type.DBL);
                this.promotedNumericToDbl = true;
            } else if (type == Type.FLO && !this.promotedNumericToFlo) {
                this.addToTable(Type.INR, Type.FLO);
                this.addToTable(Type.DEC, Type.FLO);
                this.promotedNumericToFlo = true;
                this.probeAtomic(matches, Cast.cast(null, atomic, Type.DBL, false), Type.DBL);
            } else if (type == Type.DEC && !this.promotedNumericToDec) {
                this.addToTable(Type.INR, Type.DEC);
                this.promotedNumericToDec = true;
                this.probeAtomic(matches, Cast.cast(null, atomic, Type.DBL, false), Type.DBL);
                this.probeAtomic(matches, Cast.cast(null, atomic, Type.FLO, false), Type.FLO);
            } else if (type == Type.INR) {
                this.probeAtomic(matches, Cast.cast(null, atomic, Type.DBL, false), Type.DBL);
                this.probeAtomic(matches, Cast.cast(null, atomic, Type.FLO, false), Type.FLO);
                this.probeAtomic(matches, Cast.cast(null, atomic, Type.DEC, false), Type.DEC);
            }
            this.probeAtomic(matches, atomic, type);
        } else {
            if (!this.convertedUntypedAtomic.contains(type)) {
                this.addToTable(Type.UNA, type);
                this.convertedUntypedAtomic.add(type);
            }
            this.probeAtomic(matches, atomic, type);
            if (type == Type.STR) {
                this.probeAtomic(matches, Cast.cast(null, atomic, Type.AURI, false), Type.AURI);
            } else if (type == Type.AURI) {
                this.probeAtomic(matches, Cast.cast(null, atomic, Type.STR, false), Type.STR);
            }
        }
    }

    private void addToTable(Type from, Type to) throws QueryException {
        AbstractJoinTable fromTable = this.tables.get(from);
        if (fromTable == null) {
            return;
        }
        AbstractJoinTable table = this.tables.get(to);
        if (table == null) {
            table = this.createTable();
            this.tables.put(to, table);
        }
        for (AbstractJoinTable.TEntry entry : fromTable.entries()) {
            table.add(Cast.cast(null, entry.key.atomic, to, false), entry.value.pos, entry.value.bindings);
        }
        if (to.isNumeric()) {
            this.numericPresent = true;
        } else {
            this.nonNumericTypes.add(to);
        }
    }

    private void probeAtomic(FastList<AbstractJoinTable.TValue> matches, Atomic atomic, Type type) throws QueryException {
        AbstractJoinTable table = this.tables.get(type);
        if (table != null) {
            table.lookup(matches, atomic);
        }
    }

    protected final FastList<Sequence[]> sortAndDeduplicate(FastList<AbstractJoinTable.TValue> in) throws QueryException {
        int inSize = in.getSize();
        if (this.skipSort || inSize < 2) {
            FastList<Sequence[]> out = new FastList<Sequence[]>(inSize);
            for (int i = 0; i < inSize; ++i) {
                out.add(in.get((int)i).bindings);
            }
            return out;
        }
        in.sort();
        FastList<Sequence[]> out = new FastList<Sequence[]>();
        AbstractJoinTable.TValue p = null;
        for (int i = 0; i < inSize; ++i) {
            AbstractJoinTable.TValue v = in.get(i);
            if (p == null || p.pos < v.pos) {
                out.add(v.bindings);
            }
            p = v;
        }
        return out;
    }

    public final void add(Sequence keys, Sequence[] bindings, int pos) throws QueryException {
        if (keys == null) {
            return;
        }
        if (keys instanceof Item) {
            Item item = (Item)keys;
            this.addItem(item, bindings, pos);
        } else {
            try (Iter it = keys.iterate();){
                Item key;
                while ((key = it.next()) != null) {
                    this.addItem(key, bindings, pos);
                }
            }
        }
    }

    public final FastList<Sequence[]> probe(Sequence keys) throws QueryException {
        if (keys == null) {
            return FastList.emptyList();
        }
        FastList<AbstractJoinTable.TValue> matches = new FastList<AbstractJoinTable.TValue>();
        if (keys instanceof Item) {
            this.probeItem(matches, (Item)keys);
        } else {
            try (Iter it = keys.iterate();){
                Item key;
                while ((key = it.next()) != null) {
                    this.probeItem(matches, key);
                }
            }
        }
        if (matches.isEmpty()) {
            return FastList.emptyList();
        }
        return this.sortAndDeduplicate(matches);
    }
}

