/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.join;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.util.join.AbstractJoinTable;
import io.brackit.query.util.join.FastList;

public class SingleTypeJoinTable {
    protected final QueryContext ctx;
    protected final AbstractJoinTable table;

    public SingleTypeJoinTable(QueryContext ctx, AbstractJoinTable table) {
        this.ctx = ctx;
        this.table = table;
    }

    protected final FastList<Sequence[]> sortAndDeduplicate(FastList<AbstractJoinTable.TValue> in) throws QueryException {
        in.sort();
        FastList<Sequence[]> out = new FastList<Sequence[]>();
        AbstractJoinTable.TValue p = null;
        int inSize = in.getSize();
        for (int i = 0; i < inSize; ++i) {
            AbstractJoinTable.TValue v = in.get(i);
            if (p == null || p.pos < v.pos) {
                out.add(v.bindings);
            }
            p = v;
        }
        return out;
    }

    public final void add(Sequence keys, Sequence[] bindings, int pos) throws QueryException {
        if (keys instanceof Item) {
            this.table.add(((Item)keys).atomize(), pos, bindings);
        } else {
            try (Iter it = keys.iterate();){
                Item key;
                while ((key = it.next()) != null) {
                    this.table.add(key.atomize(), pos, bindings);
                }
            }
        }
    }

    public final FastList<Sequence[]> probe(Sequence keys) throws QueryException {
        if (keys == null) {
            return FastList.emptyList();
        }
        FastList<AbstractJoinTable.TValue> matches = new FastList<AbstractJoinTable.TValue>();
        if (keys instanceof Item) {
            this.table.lookup(matches, ((Item)keys).atomize());
        } else {
            try (Iter it = keys.iterate();){
                Item key;
                while ((key = it.next()) != null) {
                    this.table.lookup(matches, key.atomize());
                }
            }
        }
        if (matches.isEmpty()) {
            return FastList.emptyList();
        }
        return this.sortAndDeduplicate(matches);
    }
}

