/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.serialize;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.Bool;
import io.brackit.query.atomic.Numeric;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.Record;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.json.Array;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.util.serialize.StringSerializer;
import io.brackit.query.util.serialize.SubtreePrinter;
import java.io.PrintStream;
import java.io.PrintWriter;

public class SerializationHandler {
    private final PrintWriter out;
    private final SubtreePrinter printer;
    private boolean format;
    private String indent = "    ";
    boolean first = true;

    public SerializationHandler(PrintWriter out) {
        this.out = out;
        this.printer = new SubtreePrinter(out);
        this.printer.setPrettyPrint(this.format);
        this.printer.setIndent(this.indent);
        this.printer.setAutoFlush(false);
    }

    public SerializationHandler(PrintStream out) {
        this(new PrintWriter(out));
    }

    public boolean isFormat() {
        return this.format;
    }

    public void setFormat(boolean format) {
        this.format = format;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public void begin() throws QueryException {
        this.first = true;
    }

    public void end() throws QueryException {
        this.printer.flush();
        this.out.flush();
    }

    public void node(Node<?> node) throws QueryException {
        Kind kind = node.getKind();
        if (kind == Kind.ATTRIBUTE) {
            throw new QueryException(ErrorCode.ERR_SERIALIZE_ATTRIBUTE_OR_NAMESPACE_NODE);
        }
        if (kind == Kind.DOCUMENT) {
            node = node.getFirstChild();
            while (node.getKind() != Kind.ELEMENT) {
                node = node.getNextSibling();
            }
        }
        this.printer.print(node);
        this.first = true;
    }

    public void atomic(Atomic atomic) throws QueryException {
        if (!this.first) {
            this.out.write(" ");
        }
        this.out.write(atomic.toString());
        this.first = false;
    }

    public void item(Item item) throws QueryException {
        if (item instanceof Node) {
            Node node = (Node)item;
            Kind kind = node.getKind();
            if (kind == Kind.ATTRIBUTE) {
                throw new QueryException(ErrorCode.ERR_SERIALIZE_ATTRIBUTE_OR_NAMESPACE_NODE);
            }
            if (kind == Kind.DOCUMENT) {
                node = node.getFirstChild();
                while (node.getKind() != Kind.ELEMENT) {
                    node = node.getNextSibling();
                }
            }
            this.printer.print(node);
            this.first = true;
        } else if (item instanceof Atomic) {
            if (!this.first) {
                this.out.write(" ");
            }
            this.out.write(item.toString());
            this.first = false;
        } else if (item instanceof Array || item instanceof Record) {
            this.json(item, this.printer);
        } else {
            throw new QueryException(ErrorCode.BIT_DYN_RT_NOT_IMPLEMENTED_YET_ERROR, "Serialization of item type '%s' not implemented yet.", item.itemType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void json(Sequence s, SubtreePrinter p) throws QueryException {
        if (s == null) {
            this.out.print("null");
            return;
        }
        if (s instanceof Item) {
            if (s instanceof Atomic) {
                if (s instanceof Numeric) {
                    this.out.write(s.toString());
                    return;
                } else if (s instanceof Bool) {
                    this.out.write(((Bool)s).booleanValue() ? "true" : "false");
                    return;
                } else {
                    this.out.write("\"");
                    this.out.write(s.toString());
                    this.out.write("\"");
                }
                return;
            } else if (s instanceof Array) {
                Array a = (Array)s;
                this.out.write("[");
                for (int i = 0; i < a.len(); ++i) {
                    if (i > 0) {
                        this.out.append(",");
                    }
                    this.json(a.at(i), p);
                }
                this.out.write("]");
                return;
            } else if (s instanceof Record) {
                Record r = (Record)s;
                this.out.write("{");
                for (int i = 0; i < r.len(); ++i) {
                    if (i > 0) {
                        this.out.write(", ");
                    }
                    this.out.write(r.name(i).stringValue());
                    this.out.write(" : ");
                    this.json(r.value(i), p);
                }
                this.out.write("}");
                return;
            } else {
                if (!(s instanceof Node)) throw new QueryException(ErrorCode.BIT_DYN_RT_NOT_IMPLEMENTED_YET_ERROR, "Serialization of item type '%s' not implemented yet.", ((Item)s).itemType());
                StringSerializer.serializeNode((Node)s, p, this.out);
            }
            return;
        }
        this.out.write("[");
        try (Iter it = s.iterate();){
            Item i;
            boolean first = true;
            while ((i = it.next()) != null) {
                if (!first) {
                    this.out.write(",");
                }
                this.json(i, p);
                first = false;
            }
        }
        this.out.write("]");
    }
}

