/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.sort;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.expr.Cast;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Stream;
import io.brackit.query.jdm.Type;
import io.brackit.query.node.stream.TransformerStream;
import io.brackit.query.util.sort.TupleSort;
import java.util.Comparator;

public class Ordering
implements Comparator<Tuple> {
    final Expr[] orderByExprs;
    final OrderModifier[] modifier;
    int offset;
    TupleSort sort;

    public Ordering(Expr[] orderByExprs, OrderModifier[] modifier) {
        this.orderByExprs = orderByExprs;
        this.modifier = modifier;
    }

    public void add(QueryContext ctx, Tuple t) throws QueryException {
        if (this.sort == null) {
            this.offset = t.getSize();
            this.sort = new TupleSort(this, 1L);
        }
        this.sort.add(t.concat(this.sortKeys(ctx, t)));
    }

    public void add(Sequence[] keys, Tuple t) throws QueryException {
        if (this.sort == null) {
            this.offset = t.getSize();
            this.sort = new TupleSort(this, 1L);
        }
        this.sort.add(t.concat(keys));
    }

    public Stream<Tuple> sorted() throws QueryException {
        this.sort.sort();
        TransformerStream<Tuple, Tuple> s = new TransformerStream<Tuple, Tuple>(this.sort.stream()){

            @Override
            protected Tuple transform(Tuple next) throws DocumentException {
                try {
                    return next.project(0, Ordering.this.offset);
                }
                catch (QueryException e) {
                    throw new DocumentException(e);
                }
            }
        };
        this.sort = null;
        return s;
    }

    public Sequence[] sortKeys(QueryContext ctx, Tuple t) throws QueryException {
        Sequence[] concat = new Sequence[this.orderByExprs.length];
        for (int i = 0; i < this.orderByExprs.length; ++i) {
            Atomic atomic;
            Item item = this.orderByExprs[i].evaluateToItem(ctx, t);
            Atomic atomic2 = atomic = item != null ? item.atomize() : null;
            if (atomic != null && atomic.type().instanceOf(Type.UNA)) {
                atomic = Cast.cast(null, atomic, Type.STR);
            }
            concat[i] = atomic;
        }
        return concat;
    }

    @Override
    public int compare(Tuple o1, Tuple o2) {
        try {
            for (int i = 0; i < this.modifier.length; ++i) {
                int pos = this.offset + i;
                Atomic lAtomic = (Atomic)o1.get(pos);
                Atomic rAtomic = (Atomic)o2.get(pos);
                if (lAtomic == null && rAtomic != null) {
                    return this.modifier[i].EMPTY_LEAST ? -1 : 1;
                }
                if (rAtomic == null) {
                    return this.modifier[i].EMPTY_LEAST ? 1 : -1;
                }
                int res = lAtomic.cmp(rAtomic);
                if (res == 0) continue;
                return this.modifier[i].ASC ? res : -res;
            }
            return 0;
        }
        catch (QueryException e) {
            if (e.getCode() == ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE) {
                throw new ClassCastException(e.getMessage());
            }
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        if (this.sort != null) {
            this.sort.clear();
            this.sort = null;
        }
    }

    public static class OrderModifier {
        public final boolean ASC;
        public final boolean EMPTY_LEAST;
        public final String collation;

        public OrderModifier(boolean asc, boolean emptyLeast, String collation) {
            this.ASC = asc;
            this.EMPTY_LEAST = emptyLeast;
            this.collation = collation;
        }
    }
}

