/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler;

import io.brackit.query.Query;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.ResultChecker;
import io.brackit.query.XQueryBaseTest;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.Str;
import io.brackit.query.compiler.BaseResolver;
import io.brackit.query.compiler.CompileChain;
import io.brackit.query.compiler.ModuleResolver;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.sequence.ItemSequence;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class LibraryModulesTest
extends XQueryBaseTest {
    private static final String RIGHT = "module namespace right='right'; import module namespace left='left'; declare function right:foo() {2};";
    private static final String LEFT = "module namespace left='left'; import module namespace right='right'; declare function left:foo() {1};";
    private static final String FOO = "module namespace foo=\"http://brackit.org/lib/foo\"; declare function foo:echo($s as item()*) as item()* { ($s, $s) };";
    private static final String FOO2 = "module namespace foo=\"http://brackit.org/lib/foo\"; declare function foo:echo2($s as item()*) as item()* { ($s, $s) };";
    private static final String BAR = "module namespace bar=\"http://brackit.org/lib/bar\"; declare function bar:echo2($s as item()*) as item()* { ($s, $s) };";
    private static final String IMPORT_FOO = "import module namespace foo=\"http://brackit.org/lib/foo\"; ";
    private static final String IMPORT_BAR = "import module namespace bar=\"http://brackit.org/lib/bar\"; ";

    @Test
    public void defineModule() {
        Query xq = new Query(FOO);
        xq.getModule();
    }

    @Test
    public void importModule() throws Exception {
        final BaseResolver res = new BaseResolver();
        CompileChain chain = new CompileChain(this){
            private final ModuleResolver resolver;
            {
                this.resolver = res;
            }

            protected ModuleResolver getModuleResolver() {
                return this.resolver;
            }
        };
        new Query(chain, FOO);
        Query xq = new Query(chain, "import module namespace foo=\"http://brackit.org/lib/foo\"; foo:echo('y')");
        QueryContext ctx = this.createContext();
        Sequence result = xq.execute(ctx);
        ResultChecker.check((Sequence)new ItemSequence(new Item[]{new Str("y"), new Str("y")}), result);
    }

    @Test
    public void importModulesInSameTargetNS() throws Exception {
        final BaseResolver res = new BaseResolver();
        CompileChain chain = new CompileChain(this){
            private final ModuleResolver resolver;
            {
                this.resolver = res;
            }

            protected ModuleResolver getModuleResolver() {
                return this.resolver;
            }
        };
        new Query(chain, FOO);
        new Query(chain, FOO2);
        Query xq = new Query(chain, "import module namespace foo=\"http://brackit.org/lib/foo\"; (foo:echo('y'), foo:echo2('y'))");
        QueryContext ctx = this.createContext();
        Sequence result = xq.execute(ctx);
        ResultChecker.check((Sequence)new ItemSequence(new Item[]{new Str("y"), new Str("y"), new Str("y"), new Str("y")}), result);
    }

    @Test
    public void importModulesInDifferentTargetNS() throws Exception {
        final BaseResolver res = new BaseResolver();
        CompileChain chain = new CompileChain(this){
            private final ModuleResolver resolver;
            {
                this.resolver = res;
            }

            protected ModuleResolver getModuleResolver() {
                return this.resolver;
            }
        };
        new Query(chain, FOO);
        new Query(chain, BAR);
        Query xq = new Query(chain, "import module namespace foo=\"http://brackit.org/lib/foo\"; import module namespace bar=\"http://brackit.org/lib/bar\"; (foo:echo('y'), bar:echo2('y'))");
        QueryContext ctx = this.createContext();
        Sequence result = xq.execute(ctx);
        ResultChecker.check((Sequence)new ItemSequence(new Item[]{new Str("y"), new Str("y"), new Str("y"), new Str("y")}), result);
    }

    @Test
    public void importModulesInSameTargetNSWithConflict() {
        final BaseResolver res = new BaseResolver();
        CompileChain chain = new CompileChain(this){
            private final ModuleResolver resolver;
            {
                this.resolver = res;
            }

            protected ModuleResolver getModuleResolver() {
                return this.resolver;
            }
        };
        new Query(chain, FOO);
        new Query(chain, FOO);
        try {
            new Query(chain, "import module namespace foo=\"http://brackit.org/lib/foo\"; foo:echo('y')");
            Assert.fail((String)"double definition of function not detected");
        }
        catch (QueryException e) {
            Assert.assertEquals((Object)"XQST0034", (Object)e.getCode().getLocalName());
        }
    }

    @Test
    public void importDirectCyclicModule() {
        final BaseResolver res = new BaseResolver(this){

            public List<String> load(String uri, String[] locations) {
                if (!uri.equals("right")) {
                    return null;
                }
                ArrayList<String> list = new ArrayList<String>(1);
                list.add(LibraryModulesTest.RIGHT);
                return list;
            }
        };
        CompileChain chain = new CompileChain(this){
            private final ModuleResolver resolver;
            {
                this.resolver = res;
            }

            protected ModuleResolver getModuleResolver() {
                return this.resolver;
            }
        };
        new Query(chain, LEFT);
    }

    @Test
    public void importDirectCyclicModule2() {
        final BaseResolver res = new BaseResolver(this){

            public List<String> load(String uri, String[] locations) {
                if (uri.equals("right")) {
                    ArrayList<String> l = new ArrayList<String>(1);
                    l.add(LibraryModulesTest.RIGHT);
                    return l;
                }
                if (uri.equals("left")) {
                    ArrayList<String> l = new ArrayList<String>(1);
                    l.add(LibraryModulesTest.LEFT);
                    return l;
                }
                return null;
            }
        };
        CompileChain chain = new CompileChain(this){
            private final ModuleResolver resolver;
            {
                this.resolver = res;
            }

            protected ModuleResolver getModuleResolver() {
                return this.resolver;
            }
        };
        Query xq = new Query(chain, "import module namespace left='left'; import module namespace right='right'; right:foo() + left:foo()");
        Sequence result = xq.execute(this.ctx);
        ResultChecker.check((Sequence)new Int32(3), result);
    }
}

