/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler.parser;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.XQueryBaseTest;
import io.brackit.query.compiler.parser.JsoniqParser;
import java.nio.file.Files;
import java.nio.file.Path;
import org.junit.Assert;
import org.junit.Test;

public class XQParserTest
extends XQueryBaseTest {
    private static final Path PARSER = RESOURCES.resolve("parser");

    @Test
    public void emptyArray() {
        new JsoniqParser("[]").parse();
    }

    @Test
    public void emptyRecord() {
        new JsoniqParser("{}").parse();
    }

    @Test
    public void ncname() {
        new JsoniqParser("declare").parse();
    }

    @Test
    public void qname() {
        new JsoniqParser("declare").parse();
    }

    @Test
    public void emptyElement() {
        new JsoniqParser("<a/>").parse();
    }

    @Test
    public void nestedElements() {
        new JsoniqParser("<a><b></b></a>").parse();
    }

    @Test
    public void emptyElementWithAttribute() {
        new JsoniqParser("<a b='a'/>").parse();
    }

    @Test
    public void elementWithAttribute() {
        new JsoniqParser("<a b='a'></a>").parse();
    }

    @Test
    public void elementsWithComplexContent() {
        new JsoniqParser("<a>1&amp;<b/>12 {'aha'}soso<c/></a>").parse();
    }

    @Test
    public void elementWithComplexContent2() {
        new JsoniqParser("string(<elem>{'a'} a {1,2,3} b <![CDATA[ b ]]> c {'a', 'b'}</elem>)").parse();
    }

    @Test
    public void illegallyNestedElements() {
        try {
            new JsoniqParser("<a><b></a>").parse();
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"illegal error code", (Object)ErrorCode.ERR_PARSING_ERROR, (Object)e.getCode());
        }
    }

    @Test
    public void nestedForBindNameOverlap() {
        new JsoniqParser("for $a in for $a in 1 return $a return $a").parse();
    }

    @Test
    public void nestedForBindRename() {
        new JsoniqParser("for $a in 1 return for $a in 2 return for $a in $a return $a").parse();
    }

    @Test
    public void weirdPart2() {
        new JsoniqParser("else- +-++-**-* instance  of element(*)* * * **---++div- div -div").parse();
    }

    @Test
    public void weird() throws Exception {
        new JsoniqParser(Files.readString(PARSER.resolve("weird.xq"))).parse();
    }

    @Test
    public void constructedAttributeWithEmptyContentSequence() {
        new JsoniqParser("attribute {'foo'} {}").parse();
    }

    @Test
    public void constructedPI() {
        new JsoniqParser("processing-instruction XmL {'pi'}").parse();
    }

    @Test
    public void onlyWSbetweenToken() {
        new JsoniqParser("for\n$\na in 1 return $a").parse();
    }

    @Test
    public void parentAxis() {
        new JsoniqParser("a/../b").parse();
    }

    @Test
    public void stringLiteralWithEntityReference() {
        new JsoniqParser("\"a string &amp;\"").parse();
    }
}

