/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.ErrorCode;
import io.brackit.query.Query;
import io.brackit.query.QueryException;
import io.brackit.query.ResultChecker;
import io.brackit.query.XQueryBaseTest;
import io.brackit.query.atomic.AbstractTimeInstant;
import io.brackit.query.atomic.Bool;
import io.brackit.query.atomic.DTD;
import io.brackit.query.atomic.Date;
import io.brackit.query.atomic.DateTime;
import io.brackit.query.atomic.Dbl;
import io.brackit.query.atomic.Dur;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.YMD;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Type;
import org.junit.Assert;
import org.junit.Test;

public class CastTest
extends XQueryBaseTest {
    @Test
    public void durationFromString() {
        Sequence res = new Query("xs:duration('P1Y20MT20S')").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new Dur(false, 2, 8, 0, 0, 0, 20000000), res);
    }

    @Test
    public void durationFromString2() {
        Sequence res = new Query("xs:duration('P1Y20M16DT23H1502M')").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new Dur(false, 2, 8, 18, 0, 2, 0), res);
    }

    @Test
    public void durationFromString3() {
        Sequence res = new Query("xs:duration('PT1M123.123456789S')").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new Dur(false, 0, 0, 0, 0, 3, 3123456), res);
    }

    @Test
    public void durationFromString4() {
        Sequence res = new Query("xs:duration('PT1M123.2S')").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new Dur(false, 0, 0, 0, 0, 3, 3200000), res);
    }

    @Test
    public void durationFromString5() {
        try {
            new Query("xs:duration('P1YM')").execute(this.ctx);
            Assert.fail((String)"Invalid duration parsed");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_INVALID_VALUE_FOR_CAST, (Object)e.getCode());
        }
    }

    @Test
    public void castDurationToYearMonthDuration() {
        Sequence res = new Query("xs:duration('P1Y20M16DT23H1502M') cast as xs:yearMonthDuration").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new YMD(false, 2, 8), res);
    }

    @Test
    public void castDurationToDayTimeDuration() {
        Sequence res = new Query("xs:duration('P6Y9M21DT16H1M3.123456789S') cast as xs:dayTimeDuration").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new DTD(false, 21, 16, 1, 3123456), res);
    }

    @Test
    public void divideDayTimeDuration() {
        Sequence res = new Query("xs:dayTimeDuration('-P12DT10H') div -0.5").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new DTD(false, 24, 20, 0, 0), res);
    }

    @Test
    public void dateTimeAddYearMonthDuration() {
        Sequence res = new Query("xs:dateTime('1981-12-31T12:05:35.1234567') + xs:yearMonthDuration('P1Y2M')").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new DateTime(1983, 2, 28, 12, 5, 35123456, null), res);
    }

    @Test
    public void dateTimeAddYearMonthDuration2() {
        Sequence res = new Query("xs:dateTime('1981-12-12T12:05:35.1234567') + xs:yearMonthDuration('-P1Y1M')").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new DateTime(1980, 11, 12, 12, 5, 35123456, null), res);
    }

    @Test
    public void dateTimeAddDayTImeDuration() {
        Sequence res = new Query("xs:dateTime('1981-12-12T12:05:35.1234567') + xs:dayTimeDuration('P19DT14H40.654321S')").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new DateTime(1982, 1, 1, 2, 6, 15777777, null), res);
    }

    @Test
    public void castDateTimeFromString() {
        Sequence res = new Query("'1981-11-11T12:05:35.1234567+07:00' cast as xs:dateTime").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new DateTime(1981, 11, 11, 12, 5, 35123456, new DTD(false, 0, 7, 0, 0)), res);
    }

    @Test
    public void castDateTimeFromString2() {
        Sequence res = new Query("'19811-11-11T12:05:35' cast as xs:dateTime").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new DateTime(19811, 11, 11, 12, 5, 35000000, null), res);
    }

    @Test
    public void castDateTimeFromString3() {
        Sequence res = new Query("'0333-03-01T09:05:35' cast as xs:dateTime").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new DateTime(333, 3, 1, 9, 5, 35000000, null), res);
    }

    @Test
    public void castDateTimeFromString4() {
        Sequence res = new Query("'-0005-03-01T09:05:35Z' cast as xs:dateTime").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new DateTime(-5, 3, 1, 9, 5, 35000000, AbstractTimeInstant.UTC_TIMEZONE), res);
    }

    @Test
    public void castDateTimeFromString5() {
        try {
            new Query("'0000-03-01T09:05:35Z' cast as xs:dateTime").execute(this.ctx);
            Assert.fail((String)"Invalid dateTime parsed");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_INVALID_VALUE_FOR_CAST, (Object)e.getCode());
        }
    }

    @Test
    public void castDateTimeFromString6() {
        Sequence res = new Query("'2010-03-01T24:00:00Z' cast as xs:dateTime").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new DateTime(2010, 3, 2, 0, 0, 0, AbstractTimeInstant.UTC_TIMEZONE), res);
    }

    @Test
    public void castDateTimeFromString7() {
        Sequence res = new Query("'2000-02-28T24:00:00Z' cast as xs:dateTime").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new DateTime(2000, 2, 29, 0, 0, 0, AbstractTimeInstant.UTC_TIMEZONE), res);
    }

    @Test
    public void castDateTimeFromString8() {
        Sequence res = new Query("'2001-02-28T24:00:00Z' cast as xs:dateTime").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new DateTime(2001, 3, 1, 0, 0, 0, AbstractTimeInstant.UTC_TIMEZONE), res);
    }

    @Test
    public void castDateTimeFromString9() {
        try {
            new Query("'0000-03-01T24:01:00Z' cast as xs:dateTime").execute(this.ctx);
            Assert.fail((String)"Invalid dateTime parsed");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_INVALID_VALUE_FOR_CAST, (Object)e.getCode());
        }
    }

    @Test
    public void castDateTimeFromString10() {
        Sequence res = new Query("'19811-11-11T12:05:35.1000' cast as xs:dateTime").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new DateTime(19811, 11, 11, 12, 5, 35100000, null), res);
    }

    @Test
    public void castDateFromString() {
        Sequence res = new Query("'2002-10-09-11:00' cast as xs:date").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new Date(2002, 10, 9, new DTD(true, 0, 11, 0, 0)), res);
    }

    @Test
    public void castDateFromString2() {
        Sequence res = new Query("'2002-10-10+13:00' cast as xs:date").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new Date(2002, 10, 10, new DTD(false, 0, 13, 0, 0)), res);
    }

    @Test
    public void subtractDateTimes() {
        Sequence res = new Query("xs:dateTime(\"2000-10-30T06:12:00\") -  xs:dateTime(\"1999-11-28T09:00:00\")").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new DTD(false, 336, 21, 12, 0), res);
    }

    @Test
    public void subtractDateTimes2() {
        Sequence res = new Query("xs:dateTime(\"2000-10-30T06:12:00\") -  xs:dateTime(\"1999-11-28T09:00:00Z\")").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new DTD(false, 336, 21, 12, 0), res);
    }

    @Test
    public void castStringAsDouble() {
        Sequence result = new Query("'-1.000E4' cast as xs:double").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new Dbl(-10000.0), result);
    }

    @Test
    public void doubleConstructorFunction() {
        Sequence result = new Query("xs:double('-1.000E4')").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new Dbl(-10000.0), result);
    }

    @Test
    public void castStringAsUnsignedByte() {
        Sequence result = new Query("'     255    ' cast as xs:unsignedByte").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new Int32(255).asType(Type.UBYT), result);
    }

    @Test
    public void illegalCastStringAsUnsignedByte() {
        try {
            new Query("'256' cast as xs:unsignedByte").execute(this.ctx);
            Assert.fail((String)"Illegal cast not detected");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_INVALID_VALUE_FOR_CAST, (Object)e.getCode());
        }
    }

    @Test
    public void stringCastableAsDouble() {
        Sequence result = new Query("'-1.000E4' castable as xs:double").execute(this.ctx);
        ResultChecker.dCheck((Sequence)Bool.TRUE, result);
    }

    @Test
    public void integerTreatAsDecimal() {
        Sequence result = new Query("3 treat as xs:decimal").execute(this.ctx);
        ResultChecker.dCheck((Sequence)new Int32(3), result);
    }

    @Test
    public void integerInstanceOfDecimal() {
        Sequence result = new Query("3 instance of xs:decimal").execute(this.ctx);
        ResultChecker.dCheck((Sequence)Bool.TRUE, result);
    }

    @Test
    public void illegalStringTreatAsDouble() {
        try {
            new Query("'foo' treat as xs:double").execute(this.ctx);
            Assert.fail((String)"Illegal treat not detected");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_DYNAMIC_TYPE_DOES_NOT_MATCH_TREAT_TYPE, (Object)e.getCode());
        }
    }

    @Test
    public void stringNotCastableAsDouble() {
        Sequence result = new Query("'Foo' castable as xs:double").execute(this.ctx);
        ResultChecker.dCheck((Sequence)Bool.FALSE, result);
    }

    @Test
    public void castLegalEmptySequenceAsDouble() {
        Sequence result = new Query("() cast as xs:double?").execute(this.ctx);
        ResultChecker.dCheck(null, result);
    }

    @Test
    public void castIllegalEmptySequenceAsDouble() {
        try {
            new Query("() cast as xs:double").execute(this.ctx);
            Assert.fail((String)"Illegal case not detected");
        }
        catch (QueryException e) {
            Assert.assertEquals((String)"Correct error code", (Object)ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, (Object)e.getCode());
        }
    }
}

