/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.Query;
import io.brackit.query.ResultChecker;
import io.brackit.query.XQueryBaseTest;
import io.brackit.query.atomic.Bool;
import io.brackit.query.jdm.Sequence;
import org.junit.Test;

public class QuantifiedBindingsTest
extends XQueryBaseTest {
    @Test
    public void someQuantifiedExprOneBindingTrue() throws Exception {
        Sequence result = new Query("some $a in (1,2,3) satisfies $a > 2").execute(this.ctx);
        ResultChecker.dCheck((Sequence)Bool.TRUE, result);
    }

    @Test
    public void someQuantifiedExprOneBindingFalse() throws Exception {
        Sequence result = new Query("some $a in (1,2,3) satisfies $a > 3").execute(this.ctx);
        ResultChecker.dCheck((Sequence)Bool.FALSE, result);
    }

    @Test
    public void someQuantifiedExprTwoBindingsTrue() throws Exception {
        Sequence result = new Query("some $a in (1,2,3), $b in (3,4,5) satisfies $a = $b").execute(this.ctx);
        ResultChecker.dCheck((Sequence)Bool.TRUE, result);
    }

    @Test
    public void someQuantifiedExprTwoBindingsFalse() throws Exception {
        Sequence result = new Query("some $a in (1,2,3), $b in (4,5,6) satisfies $a = $b").execute(this.ctx);
        ResultChecker.dCheck((Sequence)Bool.FALSE, result);
    }

    @Test
    public void everyQuantifiedExprOneBindingTrue() throws Exception {
        Sequence result = new Query("every $a in (1,2,3) satisfies $a < 4").execute(this.ctx);
        ResultChecker.dCheck((Sequence)Bool.TRUE, result);
    }

    @Test
    public void everyQuantifiedExprOneBindingFalse() throws Exception {
        Sequence result = new Query("every $a in (1,2,3) satisfies $a < 3").execute(this.ctx);
        ResultChecker.dCheck((Sequence)Bool.FALSE, result);
    }

    @Test
    public void everyQuantifiedExprTwoBindingsTrue() throws Exception {
        Sequence result = new Query("every $a in (1,2,3), $b in (4,5,6) satisfies $a < $b").execute(this.ctx);
        ResultChecker.dCheck((Sequence)Bool.TRUE, result);
    }

    @Test
    public void everyQuantifiedExprTwoBindingsFalse() throws Exception {
        Sequence result = new Query("every $a in (1,2,3), $b in (3,4,5) satisfies $a < $b").execute(this.ctx);
        ResultChecker.dCheck((Sequence)Bool.FALSE, result);
    }
}

