/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.node;

import io.brackit.query.ResultChecker;
import io.brackit.query.XQueryBaseTest;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Una;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Stream;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.jdm.node.NodeCollection;
import io.brackit.query.node.parser.DocumentParser;
import io.brackit.query.node.parser.NodeSubtreeParser;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public abstract class NodeTest<E extends Node<E>>
extends XQueryBaseTest {
    private static final Path DOCS = RESOURCES.resolve("docs");

    @Test
    public void testStoreDocument() throws Exception {
        this.createDocument(new DocumentParser(this.readFile(DOCS, "orga.xml")));
    }

    @Test
    public void testGetFirstChildForDocumentNode() throws Exception {
        NodeCollection<E> coll = this.createDocument(new DocumentParser("<a><b/><c/></a>"));
        Assert.assertEquals((String)"First child is document root node", (Object)coll.getDocument().getFirstChild(), (Object)coll.getDocument().getFirstChild());
    }

    @Test
    public void testGetLastChildForDocumentNode() throws Exception {
        NodeCollection<E> coll = this.createDocument(new DocumentParser("<a><b/><c/></a>"));
        Assert.assertEquals((String)"Last child is document root node", (Object)coll.getDocument().getFirstChild(), (Object)coll.getDocument().getLastChild());
    }

    @Test
    public void testGetChildrenForDocumentNode() throws Exception {
        NodeCollection<E> coll = this.createDocument(new DocumentParser("<a><b/><c/></a>"));
        Stream children = coll.getDocument().getChildren();
        Node n = (Node)children.next();
        Assert.assertNotNull((String)"Document node has a child node", (Object)n);
        Assert.assertEquals((String)"First child is document root node", (Object)coll.getDocument().getFirstChild(), (Object)n);
        n = (Node)children.next();
        Assert.assertNull((String)"Document node no further children", (Object)n);
        children.close();
    }

    @Test
    public void testGetSubtreeForDocumentNode() throws Exception {
        NodeCollection<E> coll = this.createDocument(new DocumentParser("<a><b/><c/></a>"));
        Stream subtree = coll.getDocument().getSubtree();
        Node n = (Node)subtree.next();
        Assert.assertNotNull((String)"Stream not empty", (Object)n);
        Assert.assertEquals((String)"First node is document node", (Object)coll.getDocument(), (Object)n);
        n = (Node)subtree.next();
        Assert.assertNotNull((String)"Stream not empty", (Object)n);
        Assert.assertEquals((String)"Second node is document root node", (Object)coll.getDocument().getFirstChild(), (Object)n);
        n = (Node)subtree.next();
        Assert.assertNotNull((String)"Stream not empty", (Object)n);
        Assert.assertEquals((String)"Third node is document root node's first child", (Object)coll.getDocument().getFirstChild().getFirstChild(), (Object)n);
        n = (Node)subtree.next();
        Assert.assertNotNull((String)"Stream not empty", (Object)n);
        Assert.assertEquals((String)"Fourth node is document root node's last child", (Object)coll.getDocument().getFirstChild().getLastChild(), (Object)n);
        subtree.close();
    }

    @Test
    public void testGetSubtreeForRootNode() throws Exception {
        NodeCollection<E> coll = this.createDocument(new DocumentParser("<a><b/><c/></a>"));
        Stream subtree = coll.getDocument().getFirstChild().getSubtree();
        Node n = (Node)subtree.next();
        Assert.assertNotNull((String)"Stream not empty", (Object)n);
        Assert.assertEquals((String)"First node is document root node", (Object)coll.getDocument().getFirstChild(), (Object)n);
        n = (Node)subtree.next();
        Assert.assertNotNull((String)"Stream not empty", (Object)n);
        Assert.assertEquals((String)"Second node is document root node's first child", (Object)coll.getDocument().getFirstChild().getFirstChild(), (Object)n);
        n = (Node)subtree.next();
        Assert.assertNotNull((String)"Stream not empty", (Object)n);
        Assert.assertEquals((String)"Third node is document root node's last child", (Object)coll.getDocument().getFirstChild().getLastChild(), (Object)n);
        subtree.close();
    }

    @Test
    public void testGetSubtreeForNonRootNode() throws Exception {
        NodeCollection<E> coll = this.createDocument(new DocumentParser("<a><b><d/><e/></b><c/></a>"));
        Stream subtree = coll.getDocument().getFirstChild().getFirstChild().getSubtree();
        Node n = (Node)subtree.next();
        Assert.assertNotNull((String)"Stream not empty", (Object)n);
        Assert.assertEquals((String)"First node is document root node", (Object)coll.getDocument().getFirstChild().getFirstChild(), (Object)n);
        n = (Node)subtree.next();
        Assert.assertNotNull((String)"Stream not empty", (Object)n);
        Assert.assertEquals((String)"Second node is document root node's first child first child", (Object)coll.getDocument().getFirstChild().getFirstChild().getFirstChild(), (Object)n);
        n = (Node)subtree.next();
        Assert.assertNotNull((String)"Stream not empty", (Object)n);
        Assert.assertEquals((String)"Third node is document root node's first child last child", (Object)coll.getDocument().getFirstChild().getFirstChild().getLastChild(), (Object)n);
        subtree.close();
    }

    @Test
    public void traverseDocumentInPreorder() throws Exception {
        NodeCollection<E> coll = this.createDocument(new DocumentParser(this.readFile(DOCS, "orga.xml")));
        Node root = coll.getDocument().getFirstChild();
        org.w3c.dom.Node domRoot = this.createDomTree(new InputSource(new StringReader(this.readFile(DOCS, "orga.xml"))));
        this.checkSubtreePreOrder(root, domRoot);
    }

    protected org.w3c.dom.Node createDomTree(InputSource source) throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(source);
            return document.getDocumentElement();
        }
        catch (Exception e) {
            throw new DocumentException("An error occured while creating DOM input source: %s", new Object[]{e.getMessage()});
        }
    }

    protected void checkSubtreePreOrder(E node, org.w3c.dom.Node domNode) throws Exception {
        Node child = null;
        if (domNode instanceof Element) {
            Element element = (Element)domNode;
            Assert.assertEquals((String)(String.valueOf(node) + " is of type element"), (Object)Kind.ELEMENT, (Object)node.getKind());
            Assert.assertEquals((String)String.format("Name of node %s", node), (Object)element.getNodeName(), (Object)node.getName().toString());
            this.compareAttributes(node, element);
            NodeList domChildNodes = element.getChildNodes();
            ArrayList<Node> children = new ArrayList<Node>();
            for (Node c = node.getFirstChild(); c != null; c = c.getNextSibling()) {
                Object ancestor;
                int ancestorLevel = 0;
                for (ancestor = node; ancestor != null; ancestor = ancestor.getParent()) {
                    if (ancestorLevel == 0) {
                        Assert.assertTrue((String)String.format("node %s is child of %s", c, ancestor), (boolean)c.isChildOf((Node)ancestor));
                        Assert.assertTrue((String)String.format("node %s is parent of %s", ancestor, c), (boolean)ancestor.isParentOf(c));
                    }
                    Assert.assertTrue((String)String.format("node %s is descendant of %s", c, ancestor), (boolean)c.isDescendantOf((Node)ancestor));
                    Assert.assertTrue((String)String.format("node %s is ancestor of %s", ancestor, c), (boolean)ancestor.isAncestorOf(c));
                    ++ancestorLevel;
                }
                ancestor = children.iterator();
                while (ancestor.hasNext()) {
                    Node sibling = (Node)ancestor.next();
                    Assert.assertTrue((String)String.format("node %s is sibling of %s", c, sibling), (boolean)c.isSiblingOf(sibling));
                    Assert.assertTrue((String)String.format("node %s is sibling of %s", sibling, c), (boolean)sibling.isSiblingOf(c));
                    Assert.assertTrue((String)String.format("node %s is preceding sibling of %s", sibling, c), (boolean)sibling.isPrecedingSiblingOf(c));
                    Assert.assertTrue((String)String.format("node %s is following sibling of %s", c, sibling), (boolean)c.isFollowingSiblingOf(sibling));
                    Assert.assertTrue((String)String.format("node %s is preceding of %s", sibling, c), (boolean)sibling.isPrecedingOf(c));
                    Assert.assertTrue((String)String.format("node %s is following of %s", c, sibling), (boolean)c.isFollowingOf(sibling));
                    try {
                        Assert.assertFalse((String)String.format("node %s is not preceding sibling of %s", c, sibling), (boolean)c.isPrecedingSiblingOf(sibling));
                    }
                    catch (AssertionError e) {
                        c.isPrecedingSiblingOf(sibling);
                        throw e;
                    }
                    Assert.assertFalse((String)String.format("node %s is following sibling of %s", sibling, c), (boolean)sibling.isFollowingSiblingOf(c));
                    Assert.assertFalse((String)String.format("node %s is not preceding of %s", c, sibling), (boolean)c.isPrecedingOf(sibling));
                    Assert.assertFalse((String)String.format("node %s is following of %s", sibling, c), (boolean)sibling.isFollowingOf(c));
                }
                children.add(c);
            }
            for (int i = 0; i < domChildNodes.getLength(); ++i) {
                org.w3c.dom.Node domChild = domChildNodes.item(i);
                if (child == null) {
                    child = node.getFirstChild();
                } else {
                    Node oldChild = child;
                    child = child.getNextSibling();
                }
                Assert.assertNotNull((String)String.format("child node %s of node %s", i, node), (Object)child);
                this.checkSubtreePreOrder(child, domChild);
            }
            Assert.assertEquals((String)String.format("child count of element %s", node), (long)domChildNodes.getLength(), (long)children.size());
        } else if (domNode instanceof Text) {
            Text text = (Text)domNode;
            Assert.assertEquals((String)(String.valueOf(node) + " is of type text : \"" + text.getNodeValue() + "\""), (Object)Kind.TEXT, (Object)node.getKind());
            Assert.assertEquals((String)String.format("Text of node %s", node), (Object)text.getNodeValue().trim(), (Object)node.getValue().stringValue());
        } else {
            throw new DocumentException("Unexpected dom node: %s", new Object[]{domNode.getClass()});
        }
    }

    @Test
    public void traverseDocumentInPostorder() throws Exception {
        Element domRoot;
        NodeCollection<E> coll = this.createDocument(new DocumentParser(this.readFile(DOCS, "orga.xml")));
        Node root = coll.getDocument().getFirstChild();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(this.readFile(DOCS, "orga.xml"))));
            domRoot = document.getDocumentElement();
        }
        catch (Exception e) {
            throw new DocumentException("An error occured while creating DOM input source: %s", new Object[]{e.getMessage()});
        }
        this.checkSubtreePostOrder(root, domRoot);
    }

    protected void checkSubtreePostOrder(E node, org.w3c.dom.Node domNode) throws Exception {
        Node child = null;
        if (domNode instanceof Element) {
            Element element = (Element)domNode;
            Assert.assertEquals((String)(String.valueOf(node) + " is of type element"), (Object)Kind.ELEMENT, (Object)node.getKind());
            Assert.assertEquals((String)String.format("Name of node %s", node), (Object)element.getNodeName(), (Object)node.getName().stringValue());
            this.compareAttributes(node, element);
            NodeList domChildNodes = element.getChildNodes();
            ArrayList<Node> children = new ArrayList<Node>();
            for (Node c = node.getLastChild(); c != null; c = c.getPreviousSibling()) {
                children.add(c);
            }
            for (int i = domChildNodes.getLength() - 1; i >= 0; --i) {
                org.w3c.dom.Node domChild = domChildNodes.item(i);
                if (child == null) {
                    child = node.getLastChild();
                } else {
                    Node oldChild = child;
                    child = child.getPreviousSibling();
                }
                Assert.assertNotNull((String)String.format("child node %s of node %s", i, node), (Object)child);
                this.checkSubtreePostOrder(child, domChild);
            }
            Assert.assertEquals((String)String.format("child count of element %s", node), (long)domChildNodes.getLength(), (long)children.size());
        } else if (domNode instanceof Text) {
            Text text = (Text)domNode;
            Assert.assertEquals((String)(String.valueOf(node) + " is of type text"), (Object)Kind.TEXT, (Object)node.getKind());
            Assert.assertEquals((String)String.format("Text of node %s", node), (Object)text.getNodeValue().trim(), (Object)node.getValue().stringValue());
        } else {
            throw new DocumentException("Unexpected dom node: %s", new Object[]{domNode.getClass()});
        }
    }

    protected void compareAttributes(E node, Element element) throws Exception {
        Node c;
        NamedNodeMap domAttributes = element.getAttributes();
        Stream attributes = node.getAttributes();
        int attributesSize = 0;
        while ((c = (Node)attributes.next()) != null) {
            ++attributesSize;
            int ancestorLevel = 0;
            for (Object ancestor = node; ancestor != null; ancestor = ancestor.getParent()) {
                if (ancestorLevel == 0) {
                    try {
                        Assert.assertTrue((String)String.format("node %s is attribute of %s", c, ancestor), (boolean)c.isAttributeOf(ancestor));
                    }
                    catch (AssertionError e) {
                        c.isAttributeOf(ancestor);
                        throw e;
                    }
                    Assert.assertTrue((String)String.format("node %s is parent of %s", ancestor, c), (boolean)ancestor.isParentOf(c));
                }
                Assert.assertTrue((String)String.format("node %s is ancestor of %s", ancestor, c), (boolean)ancestor.isAncestorOf(c));
                ++ancestorLevel;
            }
        }
        attributes.close();
        Assert.assertEquals((String)String.format("attribute count of element %s", node), (long)domAttributes.getLength(), (long)attributesSize);
        for (int i = 0; i < domAttributes.getLength(); ++i) {
            Attr domAttribute = (Attr)domAttributes.item(i);
            Node attribute = node.getAttribute(new QNm(domAttribute.getName()));
            Assert.assertNotNull((String)String.format("Attribute \"%s\" of node %s", domAttribute.getName(), node), (Object)attribute);
            Assert.assertEquals((String)(String.valueOf(attribute) + " is of type attribute"), (Object)Kind.ATTRIBUTE, (Object)attribute.getKind());
            Assert.assertEquals((String)String.format("Value of attribute \"%s\" (%s) of node %s", domAttribute.getName(), attribute, node), (Object)domAttribute.getValue(), (Object)attribute.getValue().stringValue());
        }
    }

    @Test
    public void testAppendSubtree() throws Exception {
        NodeCollection<E> orig = this.createDocument(new DocumentParser(this.readFile(DOCS, "orga.xml")));
        NodeCollection<E> doc = this.createDocument(new DocumentParser(this.readFile(DOCS, "orga.xml")));
        Node onode = orig.getDocument().getFirstChild().getLastChild();
        Node test = onode.append(Kind.ELEMENT, new QNm("test"), null);
        test.append(Kind.ELEMENT, new QNm("a"), null);
        test.append(Kind.ELEMENT, new QNm("b"), null);
        Node cnode = doc.getDocument().getFirstChild().getLastChild();
        DocumentParser docParser = new DocumentParser("<test><a/><b/></test>");
        docParser.setParseAsFragment(true);
        cnode.append((NodeSubtreeParser)docParser);
        ResultChecker.check((Sequence)orig.getDocument(), (Sequence)doc.getDocument(), false);
    }

    @Test
    public void testReplaceSubtree() throws Exception {
        NodeCollection<E> orig = this.createDocument(new DocumentParser(this.readFile(DOCS, "orga.xml")));
        NodeCollection<E> doc = this.createDocument(new DocumentParser(this.readFile(DOCS, "orga.xml")));
        Node onode = orig.getDocument().getFirstChild().getLastChild();
        Node test = onode.replaceWith(Kind.ELEMENT, new QNm("test"), null);
        test.append(Kind.ELEMENT, new QNm("a"), null);
        test.append(Kind.ELEMENT, new QNm("b"), null);
        Node cnode = doc.getDocument().getFirstChild().getLastChild();
        DocumentParser docParser = new DocumentParser("<test><a/><b/></test>");
        docParser.setParseAsFragment(true);
        cnode.replaceWith((NodeSubtreeParser)docParser);
        ResultChecker.check((Sequence)orig.getDocument(), (Sequence)doc.getDocument(), false);
    }

    @Test
    public void testSetAttribute() throws Exception {
        NodeCollection<E> coll = this.createDocument(new DocumentParser(this.readFile(DOCS, "orga.xml")));
        Node root = coll.getDocument().getFirstChild();
        Node node = root.getFirstChild();
        node = root.getFirstChild();
        node = root.getFirstChild();
        node = node.getNextSibling();
        node = node.getNextSibling();
        node.setAttribute(new QNm("new"), (Atomic)new Una("CHECKME"));
        Assert.assertEquals((String)"updated attribute value", (Object)new Una("CHECKME"), (Object)node.getAttribute(new QNm("new")).getValue());
    }

    @After
    public void tearDown() throws Exception {
    }

    protected abstract NodeCollection<E> createDocument(DocumentParser var1) throws Exception;
}

