/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.path;

import io.brackit.query.atomic.QNm;
import io.brackit.query.util.path.Path;
import io.brackit.query.util.path.PathParser;
import org.junit.Assert;
import org.junit.Test;

public final class PathParserTest {
    @Test
    public void testParseDescendantArray() {
        PathParser pathParser = new PathParser("//[]", PathParser.Type.JSON);
        Path path = pathParser.parse();
        Assert.assertEquals((Object)new Path().descendantArray(), (Object)path);
    }

    @Test
    public void testParseChildArray() {
        PathParser pathParser = new PathParser("/[]", PathParser.Type.JSON);
        Path path = pathParser.parse();
        Assert.assertEquals((Object)new Path().childArray(), (Object)path);
    }

    @Test
    public void testParseDescendantWithAtSign() {
        PathParser pathParser = new PathParser("//@a", PathParser.Type.JSON);
        Path path = pathParser.parse();
        Assert.assertEquals((Object)new Path().descendantObjectField((Object)new QNm("@a")), (Object)path);
    }

    @Test
    public void testJsonFieldWithSlash1() {
        PathParser pathParser = new PathParser("//@a/\\/", PathParser.Type.JSON);
        Path path = pathParser.parse();
        Assert.assertEquals((Object)new Path().descendantObjectField((Object)new QNm("@a")).childObjectField((Object)new QNm("/")), (Object)path);
    }

    @Test
    public void testJsonFieldWithSlash2() {
        PathParser pathParser = new PathParser("//@a/\\//*", PathParser.Type.JSON);
        Path path = pathParser.parse();
        Assert.assertEquals((Object)new Path().descendantObjectField((Object)new QNm("@a")).childObjectField((Object)new QNm("/")).childObjectField(), (Object)path);
    }

    @Test
    public void testJsonFieldWithSlash3() {
        PathParser pathParser = new PathParser("//\\/\\/\\/", PathParser.Type.JSON);
        Path path = pathParser.parse();
        Assert.assertEquals((Object)new Path().descendantObjectField((Object)new QNm("///")), (Object)path);
    }

    @Test
    public void testJsonFieldWithBrackets() {
        PathParser pathParser = new PathParser("//\\[\\]", PathParser.Type.JSON);
        Path path = pathParser.parse();
        Assert.assertEquals((Object)new Path().descendantObjectField((Object)new QNm("[]")), (Object)path);
    }
}

