/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.path;

import io.brackit.query.atomic.QNm;
import io.brackit.query.util.path.Path;
import io.brackit.query.util.path.PathException;
import io.brackit.query.util.path.PathParser;
import org.junit.Assert;
import org.junit.Test;

public class PathTest {
    @Test
    public void testJsonPathMatches() {
        Path expected = new Path().descendantArray();
        Path parsed = new PathParser("/[]/test/[]", PathParser.Type.JSON).parse();
        Assert.assertTrue((String)"Path parsed correctly", (boolean)expected.matches(parsed));
    }

    @Test
    public void testJsonPathWithArrayMatching() {
        Path expected = new Path().childObjectField((Object)new QNm("paths")).childObjectField((Object)new QNm("/business_service_providers/search/")).descendantArray().childObjectField((Object)new QNm("get/"));
        Path parsed = new PathParser(expected.toString(), PathParser.Type.JSON).parse();
        Assert.assertEquals((String)"Path parsed correctly", (Object)expected, (Object)parsed);
        Path toCheck = new Path().childObjectField((Object)new QNm("paths")).childObjectField((Object)new QNm("/business_service_providers/search/")).childObjectField((Object)new QNm("foobar")).childArray().childObjectField((Object)new QNm("get/"));
        Assert.assertTrue((boolean)expected.matches(toCheck));
    }

    @Test
    public void testSJsonPath3() {
        Path expected = new Path().childObjectField((Object)new QNm("paths")).childObjectField((Object)new QNm("/business_service_providers")).childObjectField((Object)new QNm("search")).childObjectField((Object)new QNm("get"));
        Path parsed = new PathParser(expected.toString(), PathParser.Type.JSON).parse();
        Assert.assertEquals((String)"Path parsed correctly", (Object)expected, (Object)parsed);
    }

    @Test
    public void testSJsonPath4() {
        Path expected = new Path().childObjectField((Object)new QNm("paths")).childObjectField((Object)new QNm("/business_service_providers")).childObjectField((Object)new QNm("/")).childObjectField((Object)new QNm("search")).childObjectField((Object)new QNm("get")).childObjectField((Object)new QNm("/"));
        Path parsed = new PathParser(expected.toString(), PathParser.Type.JSON).parse();
        Assert.assertEquals((String)"Path parsed correctly", (Object)expected, (Object)parsed);
    }

    @Test
    public void testJsonPathToString1() {
        Path expected = new Path().childObjectField((Object)new QNm("paths")).childObjectField((Object)new QNm("/business_service_providers")).childObjectField((Object)new QNm("/")).childObjectField((Object)new QNm("@foobar")).childObjectField((Object)new QNm("search")).childObjectField((Object)new QNm("get")).childObjectField((Object)new QNm("/"));
        Path parsed = new PathParser(expected.toString(), PathParser.Type.JSON).parse();
        Assert.assertEquals((String)"Path parsed correctly", (Object)expected, (Object)parsed);
    }

    @Test
    public void testJsonPathToString2() {
        Path expected = new Path().childArray().descendantArray().childObjectField((Object)new QNm("\\[\\]"));
        Assert.assertEquals((Object)"/[]//[]/\\[\\]", (Object)expected.toString());
    }

    @Test
    public void testJsonPathToString() {
        Path expected = new Path().childObjectField((Object)new QNm("paths")).childObjectField((Object)new QNm("/business_service_providers")).childObjectField((Object)new QNm("/")).childObjectField((Object)new QNm("@foobar")).childObjectField((Object)new QNm("search")).childObjectField((Object)new QNm("get")).childObjectField((Object)new QNm("/"));
        Assert.assertEquals((Object)"/paths/\\/business_service_providers/\\//@foobar/search/get/\\/", (Object)expected.toString());
    }

    @Test
    public void testJsonPathWithArrayNotMatching() {
        Path expected = new Path().childObjectField((Object)new QNm("paths")).childObjectField((Object)new QNm("\\/business_service_providers\\/search")).descendantArray().childObjectField((Object)new QNm("get"));
        Path parsed = new PathParser(expected.toString(), PathParser.Type.JSON).parse();
        Assert.assertEquals((String)"Path parsed correctly", (Object)expected, (Object)parsed);
        Path toCheck = new Path().childObjectField((Object)new QNm("paths")).childArray().childObjectField((Object)new QNm("\\/business_service_providers\\/search")).childObjectField((Object)new QNm("foobar")).childObjectField((Object)new QNm("get"));
        Assert.assertFalse((boolean)expected.matches(toCheck));
    }

    @Test
    public void testSJsonPath1() {
        Path expected = new Path().childObjectField((Object)new QNm("paths")).childObjectField((Object)new QNm("/business_service_providers/search")).childObjectField((Object)new QNm("get"));
        Path parsed = new PathParser(expected.toString(), PathParser.Type.JSON).parse();
        Assert.assertEquals((String)"Path parsed correctly", (Object)expected, (Object)parsed);
    }

    @Test
    public void testSJsonPath2() {
        Path expected = new Path().childObjectField((Object)new QNm("paths")).childObjectField((Object)new QNm("/business_service_providers\\"));
        Path parsed = new PathParser(expected.toString(), PathParser.Type.JSON).parse();
        Assert.assertEquals((String)"Path parsed correctly", (Object)expected, (Object)parsed);
    }

    @Test
    public void testSimplePath() {
        Path expected = new Path().child((Object)new QNm("tag"));
        Path parsed = new PathParser(expected.toString()).parse();
        Assert.assertEquals((String)"Path parsed correctly", (Object)expected, (Object)parsed);
    }

    @Test
    public void testSimplePath2() {
        Path expected = new Path().child((Object)new QNm("tag")).child((Object)new QNm("hallo")).descendant((Object)new QNm("aha"));
        Path parsed = new PathParser(expected.toString()).parse();
        Assert.assertEquals((String)"Path parsed correctly", (Object)expected, (Object)parsed);
    }

    @Test
    public void testSimplePath3() {
        Path expected = new Path().self().child((Object)new QNm("tag")).child((Object)new QNm("hallo")).descendant((Object)new QNm("aha"));
        Path parsed = new PathParser(expected.toString()).parse();
        Assert.assertEquals((String)"Path parsed correctly", (Object)expected, (Object)parsed);
    }

    @Test
    public void testSimplePath4() {
        Path expected = new Path().self().child((Object)new QNm("tag")).child((Object)new QNm("hallo")).descendant((Object)new QNm("aha"));
        String implicitSelfPath = expected.toString().substring(2);
        Path parsed = new PathParser(implicitSelfPath).parse();
        Assert.assertEquals((String)"Path parsed correctly", (Object)expected, (Object)parsed);
    }

    @Test
    public void testSelfPath4() {
        Path expected = new Path().self().self().descendant((Object)new QNm("aha"));
        Path parsed = new PathParser(expected.toString()).parse();
        Assert.assertEquals((String)"Path parsed correctly", (Object)expected, (Object)parsed);
    }

    @Test
    public void testQualifiedPath() {
        Path expected = new Path().child((Object)new QNm(null, "foo", "tag"));
        Path parsed = new PathParser(expected.toString()).parse();
        Assert.assertEquals((String)"Path parsed correctly", (Object)expected, (Object)parsed);
    }

    @Test
    public void testQualifiedPathPreamble() {
        Path expected = new Path().child((Object)new QNm("http://brackit.org/ns/bit", "bit", "tag"));
        String path = "namespace foo = 'localhost'; namespace bit = 'http://brackit.org/ns/bit'; " + String.valueOf(expected);
        Path parsed = new PathParser(path).parse();
        Assert.assertEquals((String)"Path parsed correctly", (Object)expected, (Object)parsed);
    }

    @Test
    public void testQualifiedPathMalformedPreamble() {
        Path expected = new Path().child((Object)new QNm("http://brackit.org/ns/bit", "bit", "tag"));
        String path = "namespace foo = 'localhost'" + String.valueOf(expected);
        try {
            new PathParser(path).parse();
            Assert.fail((String)"Malformed preamble recognized");
        }
        catch (PathException pathException) {
            // empty catch block
        }
    }

    @Test
    public void testQualifiedPathUndefinedPrefix() {
        Path expected = new Path().child((Object)new QNm("http://brackit.org/ns/bit", "xzibit", "tag"));
        String path = "namespace foo = 'localhost'; " + String.valueOf(expected);
        try {
            new PathParser(path).parse();
            Assert.fail((String)"Missing namespace declaration recognized");
        }
        catch (PathException pathException) {
            // empty catch block
        }
    }

    @Test
    public void testFilePath() {
        Path parsed = new PathParser("/'test.xml'").parse();
        Assert.assertEquals((String)"Path parsed correctly", (Object)new Path().child((Object)new QNm("test.xml")), (Object)parsed);
    }

    @Test
    public void testFile2Path() {
        Path parsed = new PathParser("'_test.xml'").parse();
        Assert.assertEquals((String)"Path parsed correctly", (Object)new Path().self().child((Object)new QNm("_test.xml")), (Object)parsed);
    }

    @Test
    public void testFilePath2() {
        Path parsed = new PathParser("../'conf.d'//'test.xml'").parse();
        Assert.assertEquals((String)"Path parsed correctly", (Object)new Path().parent().child((Object)new QNm("conf.d")).descendant((Object)new QNm("test.xml")), (Object)parsed);
    }

    @Test
    public void testInvalidPath1() {
        try {
            new PathParser("/a/..b/c").parse();
            Assert.fail((String)"Parser accepted invalid input");
        }
        catch (PathException pathException) {
            // empty catch block
        }
    }

    @Test
    public void testMatchWithBacktracking() {
        Path pattern = new PathParser("//a/b//c").parse();
        Path path = new PathParser("/e/a/b/b/f/b/e/c").parse();
        Assert.assertTrue((String)"Pattern matches path", (boolean)pattern.matches(path));
    }

    @Test
    public void testMatchWithDoubleTwoStagedBacktracking() {
        Path pattern = new PathParser("//a/b/c//d").parse();
        Path path = new PathParser("/a/b/c/a/b/b/c/f/b/c/e/d").parse();
        Assert.assertTrue((String)"Pattern does match path", (boolean)pattern.matches(path));
    }

    @Test
    public void testNoMatchWithBacktrackingButNoDescendantStartAxis() {
        Path pattern = new PathParser("/a/b//c").parse();
        Path path = new PathParser("/e/a/b/b/f/b/e/c").parse();
        Assert.assertFalse((String)"Pattern matches path", (boolean)pattern.matches(path));
    }

    @Test
    public void testNoMatchWithDoubleTwoStagedBacktracking() {
        Path pattern = new PathParser("//a/b/c//d").parse();
        Path path = new PathParser("/a/b/b/c/f/b/c/e/d").parse();
        Assert.assertFalse((String)"Pattern does not match path", (boolean)pattern.matches(path));
    }

    @Test
    public void testNoMatchWithDoubleTwoStagedBacktrackingButNoDescendantStartAxis() {
        Path pattern = new PathParser("/a/b/c//d").parse();
        Path path = new PathParser("/e/a/b/c/a/b/b/c/f/b/c/e/d").parse();
        Assert.assertFalse((String)"Pattern does match path", (boolean)pattern.matches(path));
    }

    @Test
    public void testMatch() {
        Path pattern = new PathParser("//c").parse();
        Path path = new PathParser("//a/b/c").parse();
        Assert.assertTrue((String)"Pattern does match path", (boolean)pattern.matches(path));
    }

    @Test
    public void testMatchWithWildcard() {
        Path pattern = new PathParser("//*").parse();
        Path path = new PathParser("//a/b/c").parse();
        Assert.assertTrue((String)"Pattern does match path", (boolean)pattern.matches(path));
    }

    @Test
    public void testVerySimplePath() {
        Path parsed = new PathParser("l").parse();
        Assert.assertFalse((boolean)parsed.isEmpty());
    }
}

