/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.serialize;

import io.brackit.query.BrackitQueryContext;
import io.brackit.query.Query;
import io.brackit.query.QueryContext;
import io.brackit.query.function.json.JSONParser;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.util.io.IOUtils;
import io.brackit.query.util.serialize.StringSerializer;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.junit.Assert;
import org.junit.Test;

public class StringSerializerTest {
    @Test
    public final void testStringSerializer() throws IOException {
        PrintStream output = IOUtils.createBuffer();
        String expected = this.getExpected("obj");
        try (StringSerializer serializer = new StringSerializer(output);){
            serializer.setFormat(false);
            serializer.serialize((Sequence)new JSONParser(expected).parse());
        }
        Assert.assertEquals((Object)expected.replaceAll("[\\s\\r\\n]", ""), (Object)output.toString());
    }

    @Test
    public final void testSetFormatDoubleIndent() throws IOException {
        PrintStream output = IOUtils.createBuffer();
        String expected = this.getExpected("obj");
        try (StringSerializer serializer = new StringSerializer(output);){
            serializer.setFormat(true);
            serializer.setIndent("  ");
            serializer.serialize((Sequence)new JSONParser(expected).parse());
        }
        Assert.assertEquals((Object)expected, (Object)output.toString());
    }

    @Test
    public final void testSetFormatSingleIndent() throws IOException {
        PrintStream output = IOUtils.createBuffer();
        String expected = this.getExpected("array");
        try (StringSerializer serializer = new StringSerializer(output);){
            serializer.setFormat(true);
            serializer.setIndent(" ");
            serializer.serialize((Sequence)new JSONParser(expected).parse());
        }
        Assert.assertEquals((Object)expected, (Object)output.toString());
    }

    @Test
    public final void testNonItemSeqSerialization() throws IOException {
        PrintStream output = IOUtils.createBuffer();
        String expected = this.getExpected("typed-seq");
        String query = "           let $people :=\n               [\n                   { \"first_name\" : \"Caitlin\", \"last_name\" : \"Harris\" },\n                   { \"first_name\" : \"Kylie\", \"last_name\" : \"Smith\" }\n               ]\n           let $result :=\n               for $names in $people\n               return {\n                   \"first\" : $names.first_name,\n                   \"last\" : $names.last_name\n               }\n           return [$result]\n";
        try (StringSerializer serializer = new StringSerializer(output);){
            serializer.setFormat(true);
            serializer.setIndent("  ");
            serializer.serialize(new Query("           let $people :=\n               [\n                   { \"first_name\" : \"Caitlin\", \"last_name\" : \"Harris\" },\n                   { \"first_name\" : \"Kylie\", \"last_name\" : \"Smith\" }\n               ]\n           let $result :=\n               for $names in $people\n               return {\n                   \"first\" : $names.first_name,\n                   \"last\" : $names.last_name\n               }\n           return [$result]\n").execute((QueryContext)new BrackitQueryContext()));
        }
        Assert.assertEquals((Object)expected, (Object)output.toString());
    }

    private final String getExpected(String format) throws IOException {
        return Files.readString(Path.of("src/test/resources/json/formatted-" + format + ".json", new String[0]), StandardCharsets.UTF_8);
    }
}

