/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.examples;

import io.brackit.query.BrackitQueryContext;
import io.brackit.query.Query;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.compiler.BaseResolver;
import io.brackit.query.compiler.CompileChain;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LibraryModules {
    private static final String LIBRARY_URI = "http://brackit.org/lib/foo";
    private static final String LIBRARY_MODULE = "module namespace foo=\"http://brackit.org/lib/foo\";\ndeclare function foo:echo($s as item()*) as item()*\n{ ($s, $s) };";
    private static final String QUERY = "import module namespace foo=\"http://brackit.org/lib/foo\";\nfoo:echo('hello')";

    public static void main(String[] args) {
        try {
            LibraryModules.compileAndImportLibrary();
            System.out.println();
            LibraryModules.dynamicLibraryImport();
        }
        catch (QueryException e) {
            System.err.print("XQuery error ");
            System.err.print(e.getCode());
            System.err.print(": ");
            System.err.println(e.getMessage());
        }
    }

    private static void compileAndImportLibrary() throws QueryException {
        BrackitQueryContext ctx = new BrackitQueryContext();
        CompileChain cc = new CompileChain();
        System.out.println("Compiling library module:");
        System.out.println(LIBRARY_MODULE);
        new Query(cc, LIBRARY_MODULE);
        System.out.println();
        System.out.println("Run query with library import:");
        System.out.println(QUERY);
        new Query(cc, QUERY).prettyPrint().serialize((QueryContext)ctx, System.out);
        System.out.println();
    }

    private static void dynamicLibraryImport() throws QueryException {
        BrackitQueryContext ctx = new BrackitQueryContext();
        BaseResolver resolver = new BaseResolver(){

            @Override
            public List<String> load(String uri, String[] locations) throws IOException {
                if (uri.equals(LibraryModules.LIBRARY_URI)) {
                    System.out.println("-> Resolving module '" + uri + "'");
                    ArrayList<String> mod = new ArrayList<String>();
                    mod.add(LibraryModules.LIBRARY_MODULE);
                    return mod;
                }
                return super.load(uri, locations);
            }
        };
        CompileChain cc = new CompileChain(resolver);
        System.out.println();
        System.out.println("Run query with library import:");
        System.out.println(QUERY);
        new Query(cc, QUERY).prettyPrint().serialize((QueryContext)ctx, System.out);
        System.out.println();
    }
}

