/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.examples;

import io.brackit.query.BrackitQueryContext;
import io.brackit.query.Query;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;

public class Simple {
    public static void main(String[] args) {
        try {
            Simple.queryAndSerialize();
            System.out.println();
            Simple.queryAndIterate();
        }
        catch (QueryException e) {
            System.err.print("XQuery error ");
            System.err.print(e.getCode());
            System.err.print(": ");
            System.err.println(e.getMessage());
        }
    }

    private static void queryAndSerialize() throws QueryException {
        BrackitQueryContext ctx = new BrackitQueryContext();
        System.out.println("Running query:");
        String xq = "for $i in (1 to 4)\nlet $d := <no>{$i}</no>\nreturn $d";
        System.out.println(xq);
        new Query(xq).prettyPrint().serialize((QueryContext)ctx, System.out);
        System.out.println();
    }

    private static void queryAndIterate() throws QueryException {
        BrackitQueryContext ctx = new BrackitQueryContext();
        System.out.println("Running query:");
        String xq = "for $i in (1 to 4)\nlet $d := <no>{$i}</no>\nreturn $d";
        System.out.println(xq);
        Query q = new Query(xq);
        Sequence res = q.execute(ctx);
        System.out.println("result sequence size: " + String.valueOf(res.size()));
        try (Iter it = res.iterate();){
            Item item;
            int cnt = 0;
            while ((item = it.next()) != null) {
                System.out.print("Item ");
                System.out.print(cnt++);
                System.out.print(": ");
                System.out.print(item.itemType());
                System.out.print(" atomized value=");
                System.out.println(item.atomize());
            }
        }
    }
}

