/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query;

import io.brackit.query.QueryContext;
import io.brackit.query.atomic.AbstractTimeInstant;
import io.brackit.query.atomic.AnyURI;
import io.brackit.query.atomic.DTD;
import io.brackit.query.atomic.Date;
import io.brackit.query.atomic.DateTime;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Time;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.json.JsonCollection;
import io.brackit.query.jdm.json.JsonStore;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.jdm.node.NodeCollection;
import io.brackit.query.jdm.node.NodeFactory;
import io.brackit.query.jdm.node.NodeStore;
import io.brackit.query.jdm.type.ItemType;
import io.brackit.query.jsonitem.SimpleJsonStore;
import io.brackit.query.node.SimpleNodeStore;
import io.brackit.query.node.d2linked.D2NodeFactory;
import io.brackit.query.update.UpdateList;
import io.brackit.query.update.op.UpdateOp;
import java.util.HashMap;
import java.util.Map;

public class BrackitQueryContext
implements QueryContext {
    private static final NodeFactory<?> FACTORY = new D2NodeFactory();
    private final NodeFactory<?> nodeFactory;
    private final NodeStore nodeStore;
    private final JsonStore jsonStore;
    private UpdateList updates;
    private Item extCtxItem;
    private ItemType extCtxItemType;
    private Map<QNm, Sequence> externalVars;
    private Node<?> defaultDocument;
    private NodeCollection<?> defaultNodeCollection;
    private JsonCollection<?> defaultJsonCollection;
    private DateTime dateTime;
    private Date date;
    private Time time;
    private final DTD implicitTimezone = AbstractTimeInstant.LOCAL_TIMEZONE;

    public BrackitQueryContext() {
        this.nodeFactory = FACTORY;
        this.nodeStore = new SimpleNodeStore();
        this.jsonStore = new SimpleJsonStore();
    }

    public BrackitQueryContext(NodeStore store) {
        this.nodeFactory = FACTORY;
        this.nodeStore = store;
        this.jsonStore = new SimpleJsonStore();
    }

    public BrackitQueryContext(JsonStore store) {
        this.nodeFactory = FACTORY;
        this.nodeStore = new SimpleNodeStore();
        this.jsonStore = store;
    }

    public BrackitQueryContext(NodeStore nodeStore, JsonStore jsonStore) {
        this.nodeFactory = FACTORY;
        this.nodeStore = nodeStore;
        this.jsonStore = jsonStore;
    }

    @Override
    public void addPendingUpdate(UpdateOp op) {
        if (this.updates == null) {
            this.updates = new UpdateList();
        }
        this.updates.append(op);
    }

    @Override
    public void applyUpdates() {
        if (this.updates != null) {
            this.updates.apply();
        }
    }

    @Override
    public UpdateList getUpdateList() {
        return this.updates;
    }

    @Override
    public void setUpdateList(UpdateList updates) {
        this.updates = updates;
    }

    @Override
    public void bind(QNm name, Sequence sequence) {
        if (this.externalVars == null) {
            this.externalVars = new HashMap<QNm, Sequence>(3);
        }
        this.externalVars.put(name, sequence);
    }

    @Override
    public Sequence resolve(QNm name) {
        return this.externalVars != null ? this.externalVars.get(name) : null;
    }

    @Override
    public boolean isBound(QNm name) {
        return this.externalVars != null && this.externalVars.containsKey(name);
    }

    @Override
    public void setContextItem(Item item) {
        this.extCtxItem = item;
        if (item != null) {
            this.extCtxItemType = item.itemType();
        }
    }

    @Override
    public Item getContextItem() {
        return this.extCtxItem;
    }

    @Override
    public ItemType getItemType() {
        return this.extCtxItemType;
    }

    @Override
    public Node<?> getDefaultDocument() {
        return this.defaultDocument;
    }

    @Override
    public void setDefaultDocument(Node<?> defaultDocument) {
        this.defaultDocument = defaultDocument;
    }

    @Override
    public NodeCollection<?> getDefaultNodeCollection() {
        return this.defaultNodeCollection;
    }

    @Override
    public JsonCollection<?> getDefaultJsonCollection() {
        return this.defaultJsonCollection;
    }

    @Override
    public void setDefaultNodeCollection(NodeCollection<?> defaultNodeCollection) {
        this.defaultNodeCollection = defaultNodeCollection;
    }

    @Override
    public void setDefaultJsonCollection(JsonCollection<?> defaultJsonCollection) {
        this.defaultJsonCollection = defaultJsonCollection;
    }

    @Override
    public DateTime getDateTime() {
        return this.dateTime != null ? this.dateTime : (this.dateTime = new DateTime(this.implicitTimezone));
    }

    @Override
    public Date getDate() {
        return this.date != null ? this.date : (this.date = new Date(this.getDateTime()));
    }

    @Override
    public Time getTime() {
        return this.time != null ? this.time : (this.time = new Time(this.getDateTime()));
    }

    @Override
    public DTD getImplicitTimezone() {
        return this.implicitTimezone;
    }

    @Override
    public AnyURI getBaseUri() {
        return AnyURI.EMPTY;
    }

    @Override
    public NodeFactory<?> getNodeFactory() {
        return this.nodeFactory;
    }

    @Override
    public NodeStore getNodeStore() {
        return this.nodeStore;
    }

    @Override
    public JsonStore getJsonItemStore() {
        return this.jsonStore;
    }
}

