/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.compiler.CompileChain;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.module.Module;
import io.brackit.query.operator.TupleImpl;
import io.brackit.query.util.Cfg;
import io.brackit.query.util.serialize.Serializer;
import io.brackit.query.util.serialize.StringSerializer;
import java.io.PrintStream;
import java.io.PrintWriter;

public class Query {
    public static final String DEBUG_CFG = "org.brackit.xquery.debug";
    public static final String DEBUG_DIR_CFG = "org.brackit.xquery.debugDir";
    public static boolean DEBUG = Cfg.asBool("org.brackit.xquery.debug", false);
    public static String DEBUG_DIR = Cfg.asString("org.brackit.xquery.debugDir", "debug/");
    private final Module module;
    private boolean prettyPrint;

    public Query(Module module) {
        this.module = module;
    }

    public Query(String query) {
        this.module = new CompileChain().compile(query);
    }

    public Query(CompileChain chain, String query) {
        this.module = chain.compile(query);
    }

    public Module getModule() {
        return this.module;
    }

    public Sequence execute(QueryContext ctx) {
        return this.run(ctx, true);
    }

    public Sequence evaluate(QueryContext ctx) {
        return this.run(ctx, false);
    }

    private Sequence run(QueryContext ctx, boolean lazy) {
        Expr body = this.module.getBody();
        if (body == null) {
            throw new QueryException(ErrorCode.BIT_DYN_INT_ERROR, "Module does not contain a query body.");
        }
        Sequence result = body.evaluate(ctx, new TupleImpl());
        if (!lazy || body.isUpdating()) {
            if (result != null && !(result instanceof Item)) {
                try (Iter it = result.iterate();){
                    while (it.next() != null) {
                    }
                }
            }
            ctx.applyUpdates();
        }
        return result;
    }

    public void serialize(QueryContext ctx, PrintStream out) {
        this.serialize(ctx, new PrintWriter(out));
    }

    public void serialize(QueryContext ctx, PrintWriter out) {
        Sequence result = this.run(ctx, true);
        if (result == null) {
            return;
        }
        try (StringSerializer serializer = new StringSerializer(out);){
            serializer.setFormat(this.prettyPrint);
            serializer.serialize(result);
        }
    }

    public void serialize(QueryContext ctx, Serializer serializer) {
        Sequence result = this.run(ctx, true);
        if (result == null) {
            return;
        }
        try (Serializer serializer2 = serializer;){
            serializer.serialize(result);
        }
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public Query prettyPrint() {
        this.prettyPrint = true;
        return this;
    }
}

