/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.atomic;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AbstractAtomic;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.Str;
import io.brackit.query.jdm.Type;
import io.brackit.query.util.Whitespace;
import java.net.URI;
import java.net.URL;

public class AnyURI
extends AbstractAtomic {
    public static final AnyURI EMPTY = new AnyURI((URI)null);
    public final URI uri;

    public AnyURI(String str) throws QueryException {
        if (str == null || (str = Whitespace.collapse(str)).isEmpty()) {
            this.uri = null;
        } else {
            try {
                this.uri = URI.create(str);
            }
            catch (Exception e) {
                throw new QueryException(e, ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:anyURI", str);
            }
        }
    }

    public AnyURI(URI uri) {
        this.uri = uri;
    }

    public static AnyURI fromString(String str) {
        return new AnyURI(URI.create(str));
    }

    public static boolean isValid(String str) {
        if (str == null || (str = Whitespace.collapse(str)).isEmpty()) {
            return false;
        }
        try {
            new URI(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Type type() {
        return Type.AURI;
    }

    @Override
    public Atomic asType(Type type) throws QueryException {
        return new DAnyURI(this, this.uri, type);
    }

    @Override
    public boolean booleanValue() throws QueryException {
        return this.uri != null;
    }

    @Override
    public int cmp(Atomic other) throws QueryException {
        if (other instanceof AnyURI || other instanceof Str) {
            return this.stringValue().compareTo(other.stringValue());
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s' with '%s'", this.type(), other.type());
    }

    @Override
    public int atomicCmpInternal(Atomic atomic) {
        return this.stringValue().compareTo(atomic.stringValue());
    }

    @Override
    public int atomicCode() {
        return 16;
    }

    @Override
    public String stringValue() {
        return this.uri != null ? this.uri.toString() : "";
    }

    public boolean isAbsolute() {
        return this.uri != null && this.uri.isAbsolute();
    }

    @Override
    public int hashCode() {
        return this.uri != null ? this.uri.hashCode() : 0;
    }

    public AnyURI absolutize(AnyURI baseURI) throws QueryException {
        try {
            return new AnyURI(baseURI.uri.resolve(this.uri));
        }
        catch (IllegalArgumentException e) {
            throw new QueryException(e, ErrorCode.BIT_DYN_INT_ERROR);
        }
    }

    public URL toURL() throws QueryException {
        try {
            return this.uri.toURL();
        }
        catch (Exception e) {
            throw new QueryException(e, ErrorCode.BIT_DYN_INT_ERROR);
        }
    }

    private class DAnyURI
    extends AnyURI {
        private final Type type;

        public DAnyURI(AnyURI anyURI, URI uri, Type type) {
            super(uri);
            this.type = type;
        }

        @Override
        public Type type() {
            return this.type;
        }
    }
}

