/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.atomic;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AbstractDuration;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.Dbl;
import io.brackit.query.atomic.Dec;
import io.brackit.query.atomic.Dur;
import io.brackit.query.atomic.Numeric;
import io.brackit.query.jdm.Type;
import io.brackit.query.util.Whitespace;
import java.math.BigDecimal;

public class DTD
extends AbstractDuration {
    private final short days;
    private final byte hours;
    private final byte minutes;
    private final int micros;

    public DTD(boolean negative, short days, byte hours, byte minutes, int micros) {
        this.days = days;
        this.hours = !negative ? hours : (byte)(hours | 0x80);
        this.minutes = minutes;
        this.micros = micros;
    }

    public DTD(String str) throws QueryException {
        int v;
        boolean negative = false;
        short days = 0;
        byte hours = 0;
        byte minutes = 0;
        int micros = 0;
        str = Whitespace.collapseTrimOnly(str);
        char[] charArray = str.toCharArray();
        int pos = 0;
        int length = charArray.length;
        if (pos == length || charArray[pos] == '-') {
            negative = true;
            ++pos;
        }
        if (length - pos < 3 || charArray[pos++] != 'P') {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dayTimeDuration", str);
        }
        int start = pos;
        while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
            ++pos;
        }
        int end = pos;
        int sectionTerminator = pos < length ? charArray[pos++] : -1;
        int n = v = start != end ? Integer.parseInt(str.substring(start, end)) : -1;
        if (sectionTerminator == 68 && v > -1) {
            if (v > Short.MAX_VALUE) {
                throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dayTimeDuration: component too large", str);
            }
            days = (short)v;
            start = pos;
            while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
                ++pos;
            }
            end = pos;
            sectionTerminator = pos < length ? charArray[pos++] : -1;
            int n2 = v = start != end ? Integer.parseInt(str.substring(start, end)) : -1;
        }
        if (sectionTerminator == 84) {
            int newHours;
            int newDays;
            start = pos;
            while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
                ++pos;
            }
            end = pos;
            sectionTerminator = pos < length ? charArray[pos++] : -1;
            int n3 = v = start != end ? Integer.parseInt(str.substring(start, end)) : -1;
            if (sectionTerminator == -1) {
                throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dayTimeDuration", str);
            }
            if (sectionTerminator == 72 && v > -1) {
                newDays = days + v / 24;
                v %= 24;
                if (newDays > Short.MAX_VALUE) {
                    throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dayTimeDuration: component too large", str);
                }
                days = (short)newDays;
                hours = (byte)v;
                start = pos;
                while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
                    ++pos;
                }
                end = pos;
                sectionTerminator = pos < length ? charArray[pos++] : -1;
                int n4 = v = start != end ? Integer.parseInt(str.substring(start, end)) : -1;
            }
            if (sectionTerminator == 77 && v > -1) {
                newDays = days + v / 1440;
                newHours = hours + (v %= 1440) / 60;
                v %= 60;
                newDays += newHours / 24;
                newHours %= 24;
                if (newDays > Short.MAX_VALUE) {
                    throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dayTimeDuration: component too large", str);
                }
                days = (short)newDays;
                hours = (byte)newHours;
                minutes = (byte)v;
                start = pos;
                while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
                    ++pos;
                }
                end = pos;
                sectionTerminator = pos < length ? charArray[pos++] : -1;
                int n5 = v = start != end ? Integer.parseInt(str.substring(start, end)) : -1;
            }
            if ((sectionTerminator == 46 || sectionTerminator == 83) && v > -1) {
                newDays = days + v / 86400;
                newHours = hours + (v %= 86400) / 3600;
                int newMinutes = minutes + (v %= 3600) / 60;
                v %= 60;
                newHours += newMinutes / 60;
                newMinutes %= 60;
                newDays += newHours / 24;
                newHours %= 24;
                if (newDays > Short.MAX_VALUE) {
                    throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dayTimeDuration: component too large", str);
                }
                days = (short)newDays;
                hours = (byte)newHours;
                minutes = (byte)newMinutes;
                micros = v * 1000000;
                if (sectionTerminator == 46) {
                    start = pos;
                    while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
                        ++pos;
                    }
                    end = pos;
                    sectionTerminator = pos < length ? charArray[pos++] : -1;
                    int l = end - start;
                    int n6 = v = start != end ? Integer.parseInt(str.substring(start, start + Math.min(l, 6))) : -1;
                    if (sectionTerminator == 83 && v > -1) {
                        if (v > 0) {
                            for (int i = 0; i < 6 - l; ++i) {
                                v *= 10;
                            }
                            micros += v;
                        }
                        sectionTerminator = pos < length ? charArray[pos++] : -1;
                    } else {
                        sectionTerminator = 88;
                    }
                } else {
                    sectionTerminator = -1;
                }
            }
        }
        if (sectionTerminator != -1) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dayTimeDuration", str);
        }
        this.days = days;
        this.hours = !negative ? hours : (byte)(hours | 0x80);
        this.minutes = minutes;
        this.micros = micros;
    }

    @Override
    public Atomic asType(Type type) throws QueryException {
        return type.instanceOf(type) ? new DTDDur(this, this.hours < 0, this.days, (byte)(this.hours & 0x7F), this.minutes, this.micros, type) : new Dur(this.hours < 0, 0, 0, this.days, (byte)(this.hours & 0x7F), this.minutes, this.micros).asType(type);
    }

    @Override
    protected boolean zeroMonthsWhenZero() {
        return false;
    }

    @Override
    public int cmp(Atomic atomic) throws QueryException {
        if (!(atomic instanceof DTD)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s with '%s'", this.type(), atomic.type());
        }
        return this.atomicCmpInternal(atomic);
    }

    @Override
    public int atomicCmpInternal(Atomic atomic) {
        DTD other = (DTD)atomic;
        int sign = this.hours & 0x80;
        int oSign = other.hours & 0x80;
        if (sign != oSign) {
            return sign < oSign ? -1 : 1;
        }
        int res = this.days - other.days;
        if (res != 0) {
            return res;
        }
        res = (this.hours & 0x7F) - (other.hours & 0x7F);
        if (res != 0) {
            return res;
        }
        res = this.hours - other.hours;
        if (res != 0) {
            return res;
        }
        res = this.minutes - other.minutes;
        if (res != 0) {
            return res;
        }
        res = this.micros - other.micros;
        return res;
    }

    @Override
    public int atomicCode() {
        return 6;
    }

    @Override
    public Type type() {
        return Type.DTD;
    }

    public DTD add(DTD other) throws QueryException {
        return this.addInternal(other.isNegative(), other.getDays(), other.getHours(), other.getMinutes(), other.getMicros());
    }

    public DTD subtract(DTD other) throws QueryException {
        return this.addInternal(!other.isNegative(), other.getDays(), other.getHours(), other.getMinutes(), other.getMicros());
    }

    public DTD multiply(Dbl dbl) throws QueryException {
        double v = dbl.doubleValue();
        if (Double.isNaN(v)) {
            throw new QueryException(ErrorCode.ERR_PARAMETER_NAN);
        }
        if (Double.isInfinite(v)) {
            throw new QueryException(ErrorCode.ERR_OVERFLOW_UNDERFLOW_IN_DURATION);
        }
        long newDays = Math.round((double)this.getDays() * v);
        long newHours = Math.round((double)this.getHours() * v);
        long newMinutes = Math.round((double)this.getMinutes() * v);
        long newMicros = Math.round((double)this.getMicros() * v);
        boolean newNegative = this.isNegative() ^ v < 0.0;
        if (this.isNegative() ^ newNegative) {
            newDays *= -1L;
            newHours *= -1L;
            newMinutes *= -1L;
            newMicros *= -1L;
        }
        newMinutes += newMicros / 60000000L;
        newMicros %= 60000000L;
        newHours += newMinutes / 60L;
        newMinutes %= 60L;
        newDays += newHours / 24L;
        newHours %= 24L;
        if (newDays > 32767L) {
            throw new QueryException(ErrorCode.ERR_OVERFLOW_UNDERFLOW_IN_DURATION);
        }
        return new DTD(newNegative, (short)newDays, (byte)newHours, (byte)newMinutes, (int)newMicros);
    }

    public DTD divide(Dbl dbl) throws QueryException {
        double v = dbl.doubleValue();
        if (Double.isNaN(v)) {
            throw new QueryException(ErrorCode.ERR_PARAMETER_NAN);
        }
        if (Double.isInfinite(v)) {
            return new DTD(false, 0, 0, 0, 0);
        }
        long newDays = Math.round((double)this.getDays() / v);
        long newHours = Math.round((double)this.getHours() / v);
        long newMinutes = Math.round((double)this.getMinutes() / v);
        long newMicros = Math.round((double)this.getMicros() / v);
        boolean newNegative = this.isNegative() ^ v < 0.0;
        if (this.isNegative() ^ newNegative) {
            newDays *= -1L;
            newHours *= -1L;
            newMinutes *= -1L;
            newMicros *= -1L;
        }
        newMinutes += newMicros / 60000000L;
        newMicros %= 60000000L;
        newHours += newMinutes / 60L;
        newMinutes %= 60L;
        newDays += newHours / 24L;
        newHours %= 24L;
        if (newDays > 32767L) {
            throw new QueryException(ErrorCode.ERR_OVERFLOW_UNDERFLOW_IN_DURATION);
        }
        return new DTD(newNegative, (short)newDays, (byte)newHours, (byte)newMinutes, (int)newMicros);
    }

    public Numeric divide(DTD dur) throws QueryException {
        long a = (((long)this.getDays() * 24L + (long)this.getHours()) * 60L + (long)this.getMinutes()) * 60L * 1000000L + (long)this.getMicros();
        long b = (((long)dur.getDays() * 24L + (long)dur.getHours()) * 60L + (long)dur.getMinutes()) * 60L * 1000000L + (long)dur.getMicros();
        if (b == 0L) {
            throw new QueryException(ErrorCode.ERR_DIVISION_BY_ZERO);
        }
        return new Dec(new BigDecimal(a)).div(new Dec(new BigDecimal(b)));
    }

    private DTD addInternal(boolean n2, short d2, byte h2, byte m2, int mic2) throws QueryException {
        boolean newNegative;
        boolean n1 = this.isNegative();
        int mic1 = this.getMicros();
        byte m1 = this.getMinutes();
        byte h1 = this.getHours();
        short d1 = this.getDays();
        if (n1) {
            d1 = (short)(d1 * -1);
            h1 = (byte)(h1 * -1);
            m1 = (byte)(m1 * -1);
            mic1 *= -1;
        }
        if (n2) {
            d2 = (short)(d2 * -1);
            h2 = (byte)(h2 * -1);
            m2 = (byte)(m2 * -1);
            mic2 *= -1;
        }
        int newDays = d1 + d2;
        int newHours = h1 + h2;
        int newMinutes = m1 + m2;
        int newMicros = mic1 + mic2;
        boolean bl = newNegative = newDays < 0;
        if (newNegative) {
            newDays *= -1;
            newHours *= -1;
            newMinutes *= -1;
            newMicros *= -1;
        }
        newMinutes += newMicros / 60000000;
        newMicros %= 60000000;
        newHours += newMinutes / 60;
        newMinutes %= 60;
        newDays += newHours / 24;
        newHours %= 24;
        if (newDays > Short.MAX_VALUE) {
            throw new QueryException(ErrorCode.ERR_OVERFLOW_UNDERFLOW_IN_DURATION);
        }
        return new DTD(newNegative, (short)newDays, (byte)newHours, (byte)newMinutes, newMicros);
    }

    @Override
    public boolean isNegative() {
        return this.hours < 0;
    }

    @Override
    public byte getMonths() {
        return 0;
    }

    @Override
    public short getYears() {
        return 0;
    }

    @Override
    public short getDays() {
        return this.days;
    }

    @Override
    public byte getHours() {
        return (byte)(this.hours & 0x7F);
    }

    @Override
    public byte getMinutes() {
        return this.minutes;
    }

    @Override
    public int getMicros() {
        return this.micros;
    }

    private class DTDDur
    extends DTD {
        private final Type type;

        public DTDDur(DTD dTD, boolean negative, short days, byte hours, byte minutes, int micros, Type type) {
            super(negative, days, hours, minutes, micros);
            this.type = type;
        }

        @Override
        public Type type() {
            return this.type;
        }
    }
}

