/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.atomic;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AbstractTimeInstant;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.DTD;
import io.brackit.query.atomic.YMD;
import io.brackit.query.jdm.Type;
import io.brackit.query.util.Whitespace;
import java.util.Calendar;
import java.util.TimeZone;

public class DateTime
extends AbstractTimeInstant {
    private final short year;
    private final byte month;
    private final byte day;
    private final byte hour;
    private final byte minute;
    private final int micros;
    private final DTD timezone;

    public DateTime(short year, byte month, byte day, byte hour, byte minute, int micros, DTD timezone) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.micros = micros;
        this.timezone = timezone;
    }

    public DateTime(String str) throws QueryException {
        byte maxDaysInMonth;
        short year;
        int v;
        DTD timezone = null;
        str = Whitespace.collapseTrimOnly(str);
        char[] charArray = str.toCharArray();
        int pos = 0;
        int length = charArray.length;
        boolean negative = false;
        if (pos == length || charArray[pos] == '-') {
            negative = true;
            ++pos;
        }
        int start = pos;
        while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
            ++pos;
        }
        int end = pos;
        if (end - start < 4) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dateTime", str);
        }
        if (end - start > 4 && negative) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dateTime", str);
        }
        int n = v = start != end ? Integer.parseInt(str.substring(start, end)) : -1;
        if (v > Short.MAX_VALUE || v == 0) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dateTime", str);
        }
        short s = year = negative ? (short)(-v) : (short)v;
        if (pos >= length || charArray[pos++] != '-') {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dateTime", str);
        }
        start = pos;
        while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
            ++pos;
        }
        end = pos;
        int n2 = v = end - start == 2 ? Integer.parseInt(str.substring(start, end)) : -1;
        if (v < 1 || v > 12) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dateTime: illegal month", str);
        }
        byte month = (byte)v;
        if (pos >= length || charArray[pos++] != '-') {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dateTime", str);
        }
        start = pos;
        while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
            ++pos;
        }
        end = pos;
        int n3 = v = end - start == 2 ? Integer.parseInt(str.substring(start, end)) : -1;
        if (v < 1 || v > 31) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dateTime: illegal day", str);
        }
        byte day = (byte)v;
        if (pos >= length || charArray[pos++] != 'T') {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dateTime", str);
        }
        start = pos;
        while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
            ++pos;
        }
        end = pos;
        int n4 = v = end - start == 2 ? Integer.parseInt(str.substring(start, end)) : -1;
        if (v < 0 || v > 24) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dateTime: illegal hour", str);
        }
        byte hour = (byte)v;
        if (pos >= length || charArray[pos++] != ':') {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dateTime", str);
        }
        start = pos;
        while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
            ++pos;
        }
        end = pos;
        int n5 = v = end - start == 2 ? Integer.parseInt(str.substring(start, end)) : -1;
        if (v < 0 || v > 59) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dateTime: illegal minute", str);
        }
        byte minute = (byte)v;
        if (pos >= length || charArray[pos++] != ':') {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dateTime", str);
        }
        start = pos;
        while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
            ++pos;
        }
        end = pos;
        int n6 = v = end - start == 2 ? Integer.parseInt(str.substring(start, end)) : -1;
        if (v < 0 || v > 59) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dateTime: illegal seconds", str);
        }
        int micros = v * 1000000;
        if (pos < length && charArray[pos] == '.') {
            start = ++pos;
            while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
                ++pos;
            }
            end = pos;
            int l = end - start;
            int n7 = v = start != end ? Integer.parseInt(str.substring(start, start + Math.min(l, 6))) : -1;
            if (v == -1) {
                throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dateTime: illegal seconds", str);
            }
            if (v > 0) {
                for (int i = 0; i < 6 - l; ++i) {
                    v *= 10;
                }
                micros += v;
            }
        }
        if (day > (maxDaysInMonth = this.maxDayInMonth(year, month))) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dateTime: Day %s does not exist in month %s of year %s", day, month, year, str);
        }
        if (hour == 24) {
            if (minute != 0) {
                throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dateTime: 24 hours is not allowed when minutes is non-zero", str);
            }
            if (day < maxDaysInMonth) {
                day = (byte)(day + 1);
                hour = 0;
            } else {
                month = (byte)(month + 1);
                day = 1;
                hour = 0;
                if (month == 13) {
                    year = (short)(year + 1);
                    month = 1;
                }
            }
        }
        if (pos < length) {
            timezone = this.parseTimezone(str, charArray, pos, length);
        }
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.micros = micros;
        this.timezone = timezone;
    }

    public DateTime(DTD timezone) {
        int utcDiff = timezone.getHours() * 60 + (timezone.isNegative() ? -1 : 1) * timezone.getMinutes();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.add(12, utcDiff);
        this.year = (short)cal.get(1);
        this.month = (byte)(cal.get(2) + 1);
        this.day = (byte)cal.get(5);
        this.hour = (byte)cal.get(11);
        this.minute = (byte)cal.get(12);
        this.micros = (cal.get(13) * 1000 + cal.get(14)) * 1000;
        this.timezone = timezone;
    }

    @Override
    public Type type() {
        return Type.DATI;
    }

    public DateTime add(DTD dayTimeDuration) throws QueryException {
        return (DateTime)this.add(dayTimeDuration.isNegative(), dayTimeDuration, this.timezone);
    }

    public DateTime add(YMD yearMonthDuration) throws QueryException {
        return (DateTime)this.add(yearMonthDuration.isNegative(), yearMonthDuration, this.timezone);
    }

    public DateTime subtract(DTD dayTimeDuration) throws QueryException {
        return (DateTime)this.add(!dayTimeDuration.isNegative(), dayTimeDuration, this.timezone);
    }

    public DateTime subtract(YMD yearMonthDuration) throws QueryException {
        return (DateTime)this.add(!yearMonthDuration.isNegative(), yearMonthDuration, this.timezone);
    }

    public DTD subtract(DateTime dateTime) throws QueryException {
        return super.subtract(dateTime);
    }

    @Override
    public int cmp(Atomic atomic) throws QueryException {
        if (!(atomic instanceof DateTime)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s with '%s'", this.type(), atomic.type());
        }
        return this.cmp((DateTime)atomic);
    }

    @Override
    public int atomicCode() {
        return 1;
    }

    @Override
    public String stringValue() {
        String yTmp = this.year < 0 ? "-" : (this.year < 10 ? "000" : (this.year < 100 ? "00" : (this.year < 1000 ? "0" : ""))) + this.year;
        String mTmp = (this.month < 10 ? "0" : "") + this.month;
        String dTmp = (this.day < 10 ? "0" : "") + this.day;
        String hTmp = (this.hour < 10 ? "0" : "") + this.hour;
        String minTmp = (this.minute < 10 ? "0" : "") + this.minute;
        String tzTmp = this.timezoneString();
        int seconds = this.micros / 1000000;
        int remainder = this.micros - seconds * 1000000;
        String sTmp = (seconds < 10 ? "0" : "") + String.valueOf(seconds);
        if (remainder != 0) {
            while (remainder / 10 == 0) {
                remainder /= 10;
            }
            sTmp = sTmp + ":" + remainder;
        }
        return String.format("%s-%s-%sT%s:%s:%s%s", yTmp, mTmp, dTmp, hTmp, minTmp, sTmp, tzTmp);
    }

    @Override
    public short getYear() {
        return this.year;
    }

    @Override
    public byte getMonth() {
        return this.month;
    }

    @Override
    public byte getDay() {
        return this.day;
    }

    @Override
    public byte getHours() {
        return this.hour;
    }

    @Override
    public byte getMinutes() {
        return this.minute;
    }

    @Override
    public int getMicros() {
        return this.micros;
    }

    @Override
    public DTD getTimezone() {
        return this.timezone;
    }

    @Override
    protected AbstractTimeInstant create(short year, byte month, byte day, byte hours, byte minutes, int micros, DTD timezone) {
        return new DateTime(year, month, day, hours, minutes, micros, timezone);
    }
}

