/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.atomic;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AbstractNumeric;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.DblNumeric;
import io.brackit.query.atomic.Int64;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.atomic.Numeric;
import io.brackit.query.jdm.Type;
import io.brackit.query.util.Whitespace;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class Dbl
extends AbstractNumeric
implements DblNumeric {
    public static final Dbl NaN = new Dbl(Double.NaN);
    public static final Dbl NINF = new Dbl(Double.NEGATIVE_INFINITY);
    public static final Dbl PINF = new Dbl(Double.POSITIVE_INFINITY);
    public double v;

    public Dbl(Double v) {
        this.v = v;
    }

    public Dbl(double v) {
        this.v = v;
    }

    public Dbl(Dbl v) {
        this.v = v.v;
    }

    public Dbl(String str) throws QueryException {
        double parsed1;
        try {
            str = Whitespace.collapseTrimOnly(str);
            parsed1 = Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            switch (str) {
                case "INF": {
                    parsed1 = Double.POSITIVE_INFINITY;
                    break;
                }
                case "-INF": {
                    parsed1 = Double.NEGATIVE_INFINITY;
                    break;
                }
                case "NaN": {
                    parsed1 = Double.NaN;
                    break;
                }
                default: {
                    throw new QueryException(e, ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast %s to xs:double", str);
                }
            }
        }
        this.v = parsed1;
    }

    public static Dbl parse(String str) throws QueryException {
        try {
            str = Whitespace.collapseTrimOnly(str);
            double dbl = Double.parseDouble(str);
            return new Dbl(dbl);
        }
        catch (NumberFormatException e) {
            if (str.equals("INF")) {
                return PINF;
            }
            if (str.equals("-INF")) {
                return NINF;
            }
            if (str.equals("NaN")) {
                return NaN;
            }
            throw new QueryException(e, ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast %s to xs:double", str);
        }
    }

    @Override
    public Type type() {
        return Type.DBL;
    }

    @Override
    public IntNumeric asIntNumeric() {
        if (Double.isNaN(this.v) || Double.isInfinite(this.v)) {
            return null;
        }
        long i = (long)this.v;
        double f = this.v - (double)i;
        return f == 0.0 ? new Int64(i) : null;
    }

    @Override
    public Atomic asType(Type type) throws QueryException {
        return this.validate(Type.DBL, new DDbl(this.v, type));
    }

    @Override
    public boolean booleanValue() throws QueryException {
        return this.v != 0.0 && !Double.isNaN(this.v) && !Double.isInfinite(this.v);
    }

    @Override
    public int cmp(Atomic other) throws QueryException {
        if (other instanceof Numeric) {
            return Double.compare(this.v, ((Numeric)other).doubleValue());
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s' with '%s'", this.type(), other.type());
    }

    @Override
    public int atomicCmpInternal(Atomic atomic) {
        return Double.compare(this.v, ((Numeric)atomic).doubleValue());
    }

    @Override
    public String stringValue() {
        if (Double.isNaN(this.v)) {
            return "NaN";
        }
        if (Double.isInfinite(this.v)) {
            return this.v > 0.0 ? "INF" : "-INF";
        }
        if (this.v == 0.0) {
            return 1.0 / this.v == Double.POSITIVE_INFINITY ? "0" : "-0";
        }
        return this.killTrailingZeros(this.v > 0.0 && this.v >= 1.0E-6 && this.v < 1000000.0 || -this.v >= 1.0E-6 && -this.v < 1000000.0 ? DD.format(this.v) : SD.format(this.v));
    }

    @Override
    public BigDecimal decimalValue() {
        return new BigDecimal(this.v);
    }

    @Override
    public BigDecimal integerValue() {
        return BigDecimal.valueOf(Math.floor(this.v));
    }

    @Override
    public double doubleValue() {
        return this.v;
    }

    @Override
    public float floatValue() {
        return (float)this.v;
    }

    @Override
    public long longValue() {
        return (long)this.v;
    }

    @Override
    public int intValue() {
        return (int)this.v;
    }

    @Override
    public Numeric add(Numeric other) throws QueryException {
        return this.addDouble(this.v, other.doubleValue());
    }

    @Override
    public Numeric subtract(Numeric other) throws QueryException {
        return this.subtractDouble(this.v, other.doubleValue());
    }

    @Override
    public Numeric multiply(Numeric other) throws QueryException {
        return this.multiplyDouble(this.v, other.doubleValue());
    }

    @Override
    public Numeric div(Numeric other) throws QueryException {
        return this.divideDouble(this.v, other.doubleValue());
    }

    @Override
    public Numeric idiv(Numeric other) throws QueryException {
        return this.idivideDouble(this.v, other.doubleValue());
    }

    @Override
    public Numeric mod(Numeric other) throws QueryException {
        return this.modDouble(this.v, other.doubleValue());
    }

    @Override
    public Numeric negate() throws QueryException {
        return new Dbl(-this.v);
    }

    @Override
    public Numeric round() throws QueryException {
        return Double.isInfinite(this.v) || this.v == 0.0 || Double.isNaN(this.v) ? this : new Dbl(Math.round(this.v));
    }

    @Override
    public Numeric abs() throws QueryException {
        return this.v >= 0.0 || Double.isNaN(this.v) ? this : new Dbl(Math.abs(this.v));
    }

    @Override
    public Numeric ceiling() throws QueryException {
        return Double.isInfinite(this.v) || this.v == 0.0 || Double.isNaN(this.v) ? this : new Dbl(Math.ceil(this.v));
    }

    @Override
    public Numeric floor() throws QueryException {
        return Double.isInfinite(this.v) || this.v == 0.0 || Double.isNaN(this.v) ? this : new Dbl(Math.floor(this.v));
    }

    @Override
    public Numeric roundHalfToEven(int precision) throws QueryException {
        if (Double.isInfinite(this.v) || this.v == 0.0 || Double.isNaN(this.v)) {
            return this;
        }
        double factor = Math.pow(10.0, precision);
        double scaled = this.v * factor;
        if (Double.isInfinite(scaled)) {
            BigDecimal bd = new BigDecimal(this.v);
            bd = bd.scaleByPowerOfTen(precision);
            bd = bd.setScale(0, RoundingMode.HALF_EVEN);
            bd = bd.scaleByPowerOfTen(-precision);
            return new Dbl(bd.doubleValue());
        }
        scaled = Math.rint(scaled);
        return new Dbl(scaled / factor);
    }

    private static class DDbl
    extends Dbl {
        private final Type type;

        public DDbl(double v, Type type) {
            super(v);
            this.type = type;
        }

        @Override
        public Type type() {
            return this.type;
        }
    }
}

