/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.atomic;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AbstractDuration;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.jdm.Type;
import io.brackit.query.util.Whitespace;

public class Dur
extends AbstractDuration {
    private final short years;
    private final byte months;
    private final short days;
    private final byte hours;
    private final byte minutes;
    private final int micros;

    public Dur(boolean negative, short years, byte months, short days, byte hours, byte minutes, int micros) {
        this.years = years;
        this.months = !negative ? months : (byte)(months | 0x80);
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.micros = micros;
    }

    public Dur(String str) throws QueryException {
        int v;
        boolean negative = false;
        short years = 0;
        byte months = 0;
        short days = 0;
        byte hours = 0;
        byte minutes = 0;
        int micros = 0;
        str = Whitespace.collapseTrimOnly(str);
        char[] charArray = str.toCharArray();
        int pos = 0;
        int length = charArray.length;
        if (pos == length || charArray[pos] == '-') {
            negative = true;
            ++pos;
        }
        if (length - pos < 3 || charArray[pos++] != 'P') {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:duration", str);
        }
        int start = pos;
        while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
            ++pos;
        }
        int end = pos;
        int sectionTerminator = pos < length ? charArray[pos++] : -1;
        int n = v = start != end ? Integer.parseInt(str.substring(start, end)) : -1;
        if (sectionTerminator == 89) {
            if (v > Short.MAX_VALUE) {
                throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:duration: component too large", str);
            }
            years = (short)v;
            start = pos;
            while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
                ++pos;
            }
            end = pos;
            sectionTerminator = pos < length ? charArray[pos++] : -1;
            int n2 = v = start != end ? Integer.parseInt(str.substring(start, end)) : -1;
        }
        if (sectionTerminator == 77 && v > -1) {
            int newYears = years + v / 12;
            v %= 12;
            if (newYears > Short.MAX_VALUE) {
                throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:duration: component too large", str);
            }
            months = (byte)(months | v);
            years = (short)newYears;
            start = pos;
            while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
                ++pos;
            }
            end = pos;
            sectionTerminator = pos < length ? charArray[pos++] : -1;
            int n3 = v = start != end ? Integer.parseInt(str.substring(start, end)) : -1;
        }
        if (sectionTerminator == 68 && v > -1) {
            if (v > Short.MAX_VALUE) {
                throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:duration: component too large", str);
            }
            days = (short)v;
            start = pos;
            while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
                ++pos;
            }
            end = pos;
            sectionTerminator = pos < length ? charArray[pos++] : -1;
            int n4 = v = start != end ? Integer.parseInt(str.substring(start, end)) : -1;
        }
        if (sectionTerminator == 84) {
            int newHours;
            int newDays;
            start = pos;
            while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
                ++pos;
            }
            end = pos;
            sectionTerminator = pos < length ? charArray[pos++] : -1;
            int n5 = v = start != end ? Integer.parseInt(str.substring(start, end)) : -1;
            if (sectionTerminator == -1) {
                throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:duration", str);
            }
            if (sectionTerminator == 72 && v > -1) {
                newDays = days + v / 24;
                v %= 24;
                if (newDays > Short.MAX_VALUE) {
                    throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:duration: component too large", str);
                }
                days = (short)newDays;
                hours = (byte)v;
                start = pos;
                while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
                    ++pos;
                }
                end = pos;
                sectionTerminator = pos < length ? charArray[pos++] : -1;
                int n6 = v = start != end ? Integer.parseInt(str.substring(start, end)) : -1;
            }
            if (sectionTerminator == 77 && v > -1) {
                newDays = days + v / 1440;
                newHours = hours + (v %= 1440) / 60;
                v %= 60;
                newDays += newHours / 24;
                newHours %= 24;
                if (newDays > Short.MAX_VALUE) {
                    throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:duration: component too large", str);
                }
                days = (short)newDays;
                hours = (byte)newHours;
                minutes = (byte)v;
                start = pos;
                while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
                    ++pos;
                }
                end = pos;
                sectionTerminator = pos < length ? charArray[pos++] : -1;
                int n7 = v = start != end ? Integer.parseInt(str.substring(start, end)) : -1;
            }
            if ((sectionTerminator == 46 || sectionTerminator == 83) && v > -1) {
                newDays = days + v / 86400;
                newHours = hours + (v %= 86400) / 3600;
                int newMinutes = minutes + (v %= 3600) / 60;
                v %= 60;
                newHours += newMinutes / 60;
                newMinutes %= 60;
                newDays += newHours / 24;
                newHours %= 24;
                if (newDays > Short.MAX_VALUE) {
                    throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:duration: component too large", str);
                }
                days = (short)newDays;
                hours = (byte)newHours;
                minutes = (byte)newMinutes;
                micros = v * 1000000;
                if (sectionTerminator == 46) {
                    start = pos;
                    while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
                        ++pos;
                    }
                    end = pos;
                    sectionTerminator = pos < length ? charArray[pos++] : -1;
                    int l = end - start;
                    int n8 = v = start != end ? Integer.parseInt(str.substring(start, start + Math.min(l, 6))) : -1;
                    if (sectionTerminator == 83 && v > -1) {
                        if (v > 0) {
                            for (int i = 0; i < 6 - l; ++i) {
                                v *= 10;
                            }
                            micros += v;
                        }
                        sectionTerminator = pos < length ? charArray[pos] : -1;
                    } else {
                        sectionTerminator = 88;
                    }
                } else {
                    sectionTerminator = -1;
                }
            }
        }
        if (sectionTerminator != -1) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:duration", str);
        }
        this.years = years;
        this.months = !negative ? months : (byte)(months | 0x80);
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.micros = micros;
    }

    @Override
    public Atomic asType(Type type) throws QueryException {
        return new DDur(this, this.months < 0, this.years, (byte)(this.months & 0x7F), this.days, this.hours, this.minutes, this.micros, type);
    }

    @Override
    public int cmp(Atomic atomic) throws QueryException {
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s with '%s'", this.type(), atomic.type());
    }

    @Override
    public int atomicCmpInternal(Atomic atomic) {
        AbstractDuration other = (AbstractDuration)atomic;
        if (this.getYears() != other.getYears()) {
            return this.getYears() - other.getYears();
        }
        if (this.getMonths() != other.getMonths()) {
            return this.getMonths() - other.getMonths();
        }
        if (this.getDays() != other.getDays()) {
            return this.getDays() - other.getDays();
        }
        if (this.getHours() != other.getHours()) {
            return this.getHours() - other.getHours();
        }
        if (this.getMinutes() != other.getMinutes()) {
            return this.getMinutes() - other.getMinutes();
        }
        if (this.getMicros() != other.getMicros()) {
            return this.getMicros() - other.getMicros();
        }
        return 0;
    }

    @Override
    public int atomicCode() {
        return 4;
    }

    @Override
    protected boolean zeroMonthsWhenZero() {
        return true;
    }

    @Override
    public Type type() {
        return Type.DUR;
    }

    @Override
    public boolean isNegative() {
        return this.months < 0;
    }

    @Override
    public byte getMonths() {
        return (byte)(this.months & 0x7F);
    }

    @Override
    public short getYears() {
        return this.years;
    }

    @Override
    public short getDays() {
        return this.days;
    }

    @Override
    public byte getHours() {
        return this.hours;
    }

    @Override
    public byte getMinutes() {
        return this.minutes;
    }

    @Override
    public int getMicros() {
        return this.micros;
    }

    private class DDur
    extends Dur {
        private final Type type;

        public DDur(Dur dur, boolean negative, short years, byte months, short days, byte hours, byte minutes, int micros, Type type) {
            super(negative, years, months, days, hours, minutes, micros);
            this.type = type;
        }

        @Override
        public Type type() {
            return this.type;
        }
    }
}

