/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.atomic;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AbstractTimeInstant;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.DTD;
import io.brackit.query.jdm.Type;
import io.brackit.query.util.Whitespace;

public class GDay
extends AbstractTimeInstant {
    private final byte day;
    private final DTD timezone;

    public GDay(byte day, DTD timezone) {
        this.day = day;
        this.timezone = timezone;
    }

    public GDay(String str) throws QueryException {
        int v;
        DTD timezone = null;
        str = Whitespace.collapseTrimOnly(str);
        char[] charArray = str.toCharArray();
        int pos = 0;
        int length = charArray.length;
        if (pos + 2 >= length || charArray[pos++] != '-' || charArray[pos++] != '-' || charArray[pos++] != '-') {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:gDay", str);
        }
        int start = pos;
        while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
            ++pos;
        }
        int end = pos;
        int n = v = end - start == 2 ? Integer.parseInt(str.substring(start, end)) : -1;
        if (v < 1 || v > 31) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:gDay: illegal day", str);
        }
        byte day = (byte)v;
        if (pos < length) {
            timezone = this.parseTimezone(str, charArray, pos, length);
        }
        this.day = day;
        this.timezone = timezone;
    }

    @Override
    public int atomicCode() {
        return 11;
    }

    @Override
    protected AbstractTimeInstant create(short year, byte month, byte day, byte hours, byte minutes, int micros, DTD timezone) {
        return new GDay(day, timezone);
    }

    @Override
    public byte getDay() {
        return this.day;
    }

    @Override
    public byte getHours() {
        return 0;
    }

    @Override
    public byte getMinutes() {
        return 0;
    }

    @Override
    public byte getMonth() {
        return 0;
    }

    @Override
    public int getMicros() {
        return 0;
    }

    @Override
    public DTD getTimezone() {
        return this.timezone;
    }

    @Override
    public short getYear() {
        return 0;
    }

    @Override
    public int cmp(Atomic atomic) throws QueryException {
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s with '%s'", this.type(), atomic.type());
    }

    @Override
    public boolean eq(Atomic atomic) throws QueryException {
        if (!(atomic instanceof GDay)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s with '%s'", this.type(), atomic.type());
        }
        return this.cmp((GDay)atomic) == 0;
    }

    @Override
    public String stringValue() {
        String dTmp = (this.day < 10 ? "0" : "") + this.day;
        String tzTmp = this.timezoneString();
        return String.format("---%s%s", dTmp, tzTmp);
    }

    @Override
    public Type type() {
        return Type.GDAY;
    }
}

