/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.atomic;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AbstractNumeric;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.DblNumeric;
import io.brackit.query.atomic.DecNumeric;
import io.brackit.query.atomic.FltNumeric;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.atomic.Numeric;
import io.brackit.query.jdm.Type;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class Int
extends AbstractNumeric
implements IntNumeric {
    private final BigDecimal v;

    public Int(String v) throws QueryException {
        try {
            this.v = new BigDecimal(v);
        }
        catch (Exception e) {
            throw new QueryException(e, ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE);
        }
    }

    public Int(BigDecimal v) {
        this.v = v.setScale(0, RoundingMode.FLOOR);
    }

    public Int(double v) {
        this.v = new BigDecimal((int)v);
    }

    @Override
    public Type type() {
        return Type.INR;
    }

    @Override
    public IntNumeric asIntNumeric() {
        return this;
    }

    @Override
    public Atomic asType(Type type) throws QueryException {
        return this.validate(Type.INR, new DInt(this, this.v, type));
    }

    @Override
    public IntNumeric inc() {
        return new Int(this.v.add(BigDecimal.ONE));
    }

    @Override
    public boolean booleanValue() throws QueryException {
        return !this.v.equals(BigDecimal.ZERO);
    }

    @Override
    public int cmp(Atomic other) throws QueryException {
        if (other instanceof DecNumeric) {
            return this.v.compareTo(((Numeric)other).decimalValue());
        }
        if (other instanceof DblNumeric) {
            return Double.compare(this.v.doubleValue(), ((Numeric)other).doubleValue());
        }
        if (other instanceof FltNumeric) {
            return Float.compare(this.v.floatValue(), ((Numeric)other).floatValue());
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s' with '%s'", this.type(), other.type());
    }

    @Override
    public int atomicCmpInternal(Atomic other) {
        if (other instanceof DecNumeric) {
            return this.v.compareTo(((Numeric)other).decimalValue());
        }
        if (other instanceof DblNumeric) {
            return Double.compare(this.v.doubleValue(), ((Numeric)other).doubleValue());
        }
        return Float.compare(this.v.floatValue(), ((Numeric)other).floatValue());
    }

    @Override
    public String stringValue() {
        return this.v.toString();
    }

    @Override
    public BigDecimal decimalValue() {
        return this.v;
    }

    @Override
    public BigDecimal integerValue() {
        return this.v;
    }

    @Override
    public double doubleValue() {
        return this.v.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.v.floatValue();
    }

    @Override
    public long longValue() {
        return this.v.longValue();
    }

    @Override
    public int intValue() {
        return this.v.intValue();
    }

    @Override
    public Numeric add(Numeric other) throws QueryException {
        if (other instanceof DecNumeric) {
            return this.addBigDecimal(this.v, other.decimalValue(), false);
        }
        if (other instanceof DblNumeric) {
            return this.addDouble(this.v.doubleValue(), other.doubleValue());
        }
        return this.addFloat(this.v.floatValue(), other.floatValue());
    }

    @Override
    public Numeric subtract(Numeric other) throws QueryException {
        if (other instanceof DecNumeric) {
            return this.subtractBigDecimal(this.v, other.decimalValue(), false);
        }
        if (other instanceof DblNumeric) {
            return this.subtractDouble(this.v.doubleValue(), other.doubleValue());
        }
        return this.subtractFloat(this.v.floatValue(), other.floatValue());
    }

    @Override
    public Numeric multiply(Numeric other) throws QueryException {
        if (other instanceof IntNumeric) {
            return this.multiplyBigDecimal(this.v, other.decimalValue(), false);
        }
        if (other instanceof DecNumeric) {
            return this.multiplyBigDecimal(this.v, other.decimalValue(), true);
        }
        if (other instanceof DblNumeric) {
            return this.multiplyDouble(this.v.doubleValue(), other.doubleValue());
        }
        return this.multiplyFloat(this.v.floatValue(), other.floatValue());
    }

    @Override
    public Numeric div(Numeric other) throws QueryException {
        if (other instanceof DecNumeric) {
            return this.divideBigDecimal(this.v, other.decimalValue(), false);
        }
        if (other instanceof DblNumeric) {
            return this.divideDouble(this.v.doubleValue(), other.doubleValue());
        }
        return this.divideFloat(this.v.floatValue(), other.floatValue());
    }

    @Override
    public Numeric idiv(Numeric other) throws QueryException {
        if (other instanceof DecNumeric) {
            return this.idivideBigDecimal(this.v, other.decimalValue());
        }
        if (other instanceof DblNumeric) {
            return this.idivideDouble(this.v.doubleValue(), other.doubleValue());
        }
        return this.idivideFloat(this.v.floatValue(), other.floatValue());
    }

    @Override
    public Numeric mod(Numeric other) throws QueryException {
        if (other instanceof DecNumeric) {
            return this.modBigDecimal(this.v, other.decimalValue());
        }
        if (other instanceof DblNumeric) {
            return this.modDouble(this.v.doubleValue(), other.doubleValue());
        }
        return this.modFloat(this.v.floatValue(), other.floatValue());
    }

    @Override
    public Numeric negate() throws QueryException {
        return new Int(this.v.negate());
    }

    @Override
    public Numeric round() throws QueryException {
        return this;
    }

    @Override
    public Numeric abs() throws QueryException {
        return this.v.signum() >= 0 ? this : new Int(this.v.negate());
    }

    @Override
    public Numeric ceiling() throws QueryException {
        return this;
    }

    @Override
    public Numeric floor() throws QueryException {
        return this;
    }

    @Override
    public Numeric roundHalfToEven(int precision) throws QueryException {
        return this;
    }

    private class DInt
    extends Int {
        private final Type type;

        public DInt(Int intVal, BigDecimal v, Type type) {
            super(v);
            this.type = type;
        }

        @Override
        public Type type() {
            return this.type;
        }
    }
}

