/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.atomic;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AbstractNumeric;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.Dbl;
import io.brackit.query.atomic.DecNumeric;
import io.brackit.query.atomic.Int;
import io.brackit.query.atomic.Int64;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.atomic.LonNumeric;
import io.brackit.query.atomic.Numeric;
import io.brackit.query.jdm.Type;
import io.brackit.query.util.Whitespace;
import java.math.BigDecimal;

public class Int32
extends AbstractNumeric
implements LonNumeric {
    public static final Int32 MIN_VALUE = new Int32(Integer.MIN_VALUE);
    public static final Int32 MAX_VALUE = new Int32(Integer.MAX_VALUE);
    public static final BigDecimal MIN_VALUE_AS_DECIMAL = new BigDecimal(Integer.MIN_VALUE);
    public static final BigDecimal MAX_VALUE_AS_DECIMAL = new BigDecimal(Integer.MAX_VALUE);
    public static final Int32 N_ONE = new Int32(-1);
    public static final Int32 ZERO = new Int32(0);
    public static final Int32 ONE = new Int32(1);
    public static final Int32[] ZERO_TO_TWENTY = new Int32[]{ZERO, ONE, new Int32(2), new Int32(3), new Int32(4), new Int32(5), new Int32(6), new Int32(7), new Int32(8), new Int32(9), new Int32(10), new Int32(11), new Int32(12), new Int32(13), new Int32(14), new Int32(15), new Int32(16), new Int32(17), new Int32(18), new Int32(19), new Int32(20)};
    private final int v;

    public Int32(String v) throws QueryException {
        try {
            this.v = Integer.parseInt(v);
        }
        catch (Exception e) {
            throw new QueryException(e, ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE);
        }
    }

    public Int32(Integer v) {
        this.v = v;
    }

    public Int32(int v) {
        this.v = v;
    }

    public static IntNumeric parse(String str) throws QueryException {
        str = Whitespace.collapseTrimOnly(str);
        int length = str.length();
        try {
            if (length > 0 && str.charAt(0) == '+') {
                str = str.substring(1, length--);
            }
            if (length < 9) {
                return new Int32(Integer.parseInt(str));
            }
            if (length < 18) {
                long lValue = Long.parseLong(str);
                return lValue <= Integer.MAX_VALUE && lValue >= Integer.MIN_VALUE ? new Int32((int)lValue) : new Int64(lValue);
            }
            BigDecimal dValue = new BigDecimal(str);
            if (dValue.scale() > 0) {
                throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast %s to xs:integer", str);
            }
            return new Int(dValue);
        }
        catch (NumberFormatException e) {
            throw new QueryException(e, ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast %s to xs:integer", str);
        }
    }

    @Override
    public Type type() {
        return Type.INR;
    }

    @Override
    public IntNumeric asIntNumeric() {
        return this;
    }

    @Override
    public Atomic asType(Type type) throws QueryException {
        return this.validate(Type.INR, new DInt32(this.v, type));
    }

    @Override
    public IntNumeric inc() {
        return this.v < 20 && this.v > 0 ? ZERO_TO_TWENTY[this.v + 1] : (this.v != Integer.MAX_VALUE ? new Int32(this.v + 1) : new Int64((long)this.v + 1L));
    }

    @Override
    public boolean booleanValue() throws QueryException {
        return this.v != 0 && this.v != Integer.MAX_VALUE && this.v != Integer.MIN_VALUE;
    }

    @Override
    public int cmp(Atomic other) throws QueryException {
        if (other instanceof Int32) {
            return Integer.compare(this.v, ((Int32)other).v);
        }
        if (other instanceof Numeric) {
            return -other.cmp(this);
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s' with '%s'", this.type(), other.type());
    }

    @Override
    public int atomicCmpInternal(Atomic other) {
        if (other instanceof Int32) {
            return Integer.compare(this.v, ((Int32)other).v);
        }
        return -((AbstractNumeric)other).atomicCmpInternal(this);
    }

    @Override
    public String stringValue() {
        return Integer.toString(this.v);
    }

    @Override
    public BigDecimal decimalValue() {
        return new BigDecimal(this.v);
    }

    @Override
    public BigDecimal integerValue() {
        return new BigDecimal(this.v);
    }

    @Override
    public double doubleValue() {
        return this.v;
    }

    @Override
    public float floatValue() {
        return this.v;
    }

    @Override
    public long longValue() {
        return this.v;
    }

    @Override
    public int intValue() {
        return this.v;
    }

    @Override
    public Numeric add(Numeric other) throws QueryException {
        if (other instanceof IntNumeric) {
            if (other instanceof LonNumeric) {
                if (other instanceof Int32) {
                    return this.addInt(this.v, other.intValue());
                }
                return this.addLong(this.v, other.longValue());
            }
            return other.add(this);
        }
        if (other instanceof DecNumeric) {
            return this.addBigDecimal(new BigDecimal(this.v), other.decimalValue(), false);
        }
        if (other instanceof Dbl) {
            return this.addDouble(this.v, other.doubleValue());
        }
        return this.addFloat(this.v, other.floatValue());
    }

    @Override
    public Numeric subtract(Numeric other) throws QueryException {
        if (other instanceof IntNumeric) {
            if (other instanceof LonNumeric) {
                if (other instanceof Int32) {
                    return this.subtractInt(this.v, other.intValue());
                }
                return this.subtractLong(this.v, other.longValue());
            }
            return other.negate().add(this);
        }
        if (other instanceof DecNumeric) {
            return this.subtractBigDecimal(new BigDecimal(this.v), other.decimalValue(), false);
        }
        if (other instanceof Dbl) {
            return this.subtractDouble(this.v, other.doubleValue());
        }
        return this.subtractFloat(this.v, other.floatValue());
    }

    @Override
    public Numeric multiply(Numeric other) throws QueryException {
        if (other instanceof IntNumeric) {
            if (other instanceof LonNumeric) {
                if (other instanceof Int32) {
                    return this.multiplyInt(this.v, other.intValue());
                }
                return this.multiplyLong(this.v, other.longValue());
            }
            return other.multiply(this);
        }
        if (other instanceof DecNumeric) {
            return this.multiplyBigDecimal(new BigDecimal(this.v), other.decimalValue(), true);
        }
        if (other instanceof Dbl) {
            return this.multiplyDouble(this.v, other.doubleValue());
        }
        return this.multiplyFloat(this.v, other.floatValue());
    }

    @Override
    public Numeric div(Numeric other) throws QueryException {
        if (other instanceof IntNumeric) {
            if (other instanceof LonNumeric) {
                if (other instanceof Int32) {
                    return this.divideInt(this.v, other.intValue());
                }
                return this.divideLong(this.v, other.longValue());
            }
            return other.add(this);
        }
        if (other instanceof DecNumeric) {
            return this.divideBigDecimal(new BigDecimal(this.v), other.decimalValue(), false);
        }
        if (other instanceof Dbl) {
            return this.divideDouble(this.v, other.doubleValue());
        }
        return this.divideFloat(this.v, other.floatValue());
    }

    @Override
    public Numeric idiv(Numeric other) throws QueryException {
        if (other instanceof IntNumeric) {
            if (other instanceof LonNumeric) {
                if (other instanceof Int32) {
                    return this.idivideInt(this.v, other.intValue());
                }
                return this.idivideLong(this.v, other.longValue());
            }
            return other.add(this);
        }
        if (other instanceof DecNumeric) {
            return this.idivideBigDecimal(new BigDecimal(this.v), other.decimalValue());
        }
        if (other instanceof Dbl) {
            return this.idivideDouble(this.v, other.doubleValue());
        }
        return this.idivideFloat(this.v, other.floatValue());
    }

    @Override
    public Numeric mod(Numeric other) throws QueryException {
        if (other instanceof IntNumeric) {
            if (other instanceof LonNumeric) {
                if (other instanceof Int32) {
                    return this.modInt(this.v, other.intValue());
                }
                return this.modLong(this.v, other.longValue());
            }
            return other.add(this);
        }
        if (other instanceof DecNumeric) {
            return this.modBigDecimal(new BigDecimal(this.v), other.decimalValue());
        }
        if (other instanceof Dbl) {
            return this.modDouble(this.v, other.doubleValue());
        }
        return this.divideFloat(this.v, other.floatValue());
    }

    @Override
    public Numeric negate() throws QueryException {
        return this.v != Integer.MIN_VALUE ? new Int32(-this.v) : new Int64(-((long)this.v));
    }

    @Override
    public Numeric round() throws QueryException {
        return this;
    }

    @Override
    public Numeric abs() throws QueryException {
        return this.v >= 0 ? this : (this.v != Integer.MIN_VALUE ? new Int32(-this.v) : new Int(-((long)this.v)));
    }

    @Override
    public Numeric ceiling() throws QueryException {
        return this;
    }

    @Override
    public Numeric floor() throws QueryException {
        return this;
    }

    @Override
    public Numeric roundHalfToEven(int precision) throws QueryException {
        return this;
    }

    private static class DInt32
    extends Int32 {
        private final Type type;

        public DInt32(int v, Type type) {
            super(v);
            this.type = type;
        }

        @Override
        public Type type() {
            return this.type;
        }
    }
}

