/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.atomic;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AbstractNumeric;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.Dbl;
import io.brackit.query.atomic.DecNumeric;
import io.brackit.query.atomic.Flt;
import io.brackit.query.atomic.Int;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.atomic.LonNumeric;
import io.brackit.query.atomic.Numeric;
import io.brackit.query.jdm.Type;
import java.math.BigDecimal;

public class Int64
extends AbstractNumeric
implements LonNumeric {
    public static final Int64 MIN_VALUE = new Int64(Long.MIN_VALUE);
    public static final Int64 MAX_VALUE = new Int64(Long.MAX_VALUE);
    public static final BigDecimal MIN_VALUE_AS_DECIMAL = new BigDecimal(Long.MIN_VALUE);
    public static final BigDecimal MAX_VALUE_AS_DECIMAL = new BigDecimal(Long.MAX_VALUE);
    private final long v;

    public Int64(Long v) {
        this.v = v;
    }

    public Int64(long v) {
        this.v = v;
    }

    @Override
    public Type type() {
        return Type.INR;
    }

    @Override
    public IntNumeric asIntNumeric() {
        return this;
    }

    @Override
    public Atomic asType(Type type) throws QueryException {
        return this.validate(Type.INR, new DInt64(this.v, type));
    }

    @Override
    public IntNumeric inc() {
        return this.v != Long.MAX_VALUE ? new Int64(this.v + 1L) : new Int(new BigDecimal(this.v).add(BigDecimal.ONE));
    }

    @Override
    public boolean booleanValue() throws QueryException {
        return this.v != 0L;
    }

    @Override
    public int cmp(Atomic other) throws QueryException {
        if (other instanceof IntNumeric) {
            if (other instanceof LonNumeric) {
                long v2 = ((LonNumeric)other).longValue();
                return Long.compare(this.v, v2);
            }
            return -other.cmp(this);
        }
        if (other instanceof DecNumeric) {
            return new BigDecimal(this.v).compareTo(((Numeric)other).decimalValue());
        }
        if (other instanceof Dbl) {
            return Double.compare(this.v, ((Numeric)other).doubleValue());
        }
        if (other instanceof Flt) {
            return Float.compare(this.v, ((Numeric)other).floatValue());
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s' with '%s'", this.type(), other.type());
    }

    @Override
    public int atomicCmpInternal(Atomic other) {
        if (other instanceof IntNumeric) {
            if (other instanceof LonNumeric) {
                long v2 = ((LonNumeric)other).longValue();
                return Long.compare(this.v, v2);
            }
            return -((AbstractNumeric)other).atomicCmpInternal(this);
        }
        if (other instanceof DecNumeric) {
            return new BigDecimal(this.v).compareTo(((Numeric)other).decimalValue());
        }
        if (other instanceof Dbl) {
            return Double.compare(this.v, ((Numeric)other).doubleValue());
        }
        return Float.compare(this.v, ((Numeric)other).floatValue());
    }

    @Override
    public String stringValue() {
        return Long.toString(this.v);
    }

    @Override
    public BigDecimal decimalValue() {
        return new BigDecimal(this.v);
    }

    @Override
    public BigDecimal integerValue() {
        return new BigDecimal(this.v);
    }

    @Override
    public double doubleValue() {
        return this.v;
    }

    @Override
    public float floatValue() {
        return this.v;
    }

    @Override
    public long longValue() {
        return this.v;
    }

    @Override
    public int intValue() {
        return (int)this.v;
    }

    @Override
    public Numeric add(Numeric other) throws QueryException {
        if (other instanceof IntNumeric) {
            if (other instanceof LonNumeric) {
                return this.addLong(this.v, other.longValue());
            }
            return other.add(this);
        }
        if (other instanceof DecNumeric) {
            return this.addBigDecimal(new BigDecimal(this.v), other.decimalValue(), false);
        }
        if (other instanceof Dbl) {
            return this.addDouble(this.v, other.doubleValue());
        }
        return this.addFloat(this.v, other.floatValue());
    }

    @Override
    public Numeric subtract(Numeric other) throws QueryException {
        if (other instanceof IntNumeric) {
            if (other instanceof LonNumeric) {
                return this.subtractLong(this.v, other.longValue());
            }
            return other.negate().add(this);
        }
        if (other instanceof DecNumeric) {
            return this.subtractBigDecimal(new BigDecimal(this.v), other.decimalValue(), false);
        }
        if (other instanceof Dbl) {
            return this.subtractDouble(this.v, other.doubleValue());
        }
        return this.subtractFloat(this.v, other.floatValue());
    }

    @Override
    public Numeric multiply(Numeric other) throws QueryException {
        if (other instanceof IntNumeric) {
            if (other instanceof LonNumeric) {
                return this.multiplyLong(this.v, other.longValue());
            }
            return other.multiply(this);
        }
        if (other instanceof DecNumeric) {
            return this.multiplyBigDecimal(new BigDecimal(this.v), other.decimalValue(), true);
        }
        if (other instanceof Dbl) {
            return this.multiplyDouble(this.v, other.doubleValue());
        }
        return this.multiplyFloat(this.v, other.floatValue());
    }

    @Override
    public Numeric div(Numeric other) throws QueryException {
        if (other instanceof IntNumeric) {
            if (other instanceof LonNumeric) {
                return this.divideLong(this.v, other.longValue());
            }
            return other.add(this);
        }
        if (other instanceof DecNumeric) {
            return this.divideBigDecimal(new BigDecimal(this.v), other.decimalValue(), false);
        }
        if (other instanceof Dbl) {
            return this.divideDouble(this.v, other.doubleValue());
        }
        return this.divideFloat(this.v, other.floatValue());
    }

    @Override
    public Numeric idiv(Numeric other) throws QueryException {
        if (other instanceof IntNumeric) {
            if (other instanceof LonNumeric) {
                return this.idivideLong(this.v, other.longValue());
            }
            return other.add(this);
        }
        if (other instanceof DecNumeric) {
            return this.idivideBigDecimal(new BigDecimal(this.v), other.decimalValue());
        }
        if (other instanceof Dbl) {
            return this.idivideDouble(this.v, other.doubleValue());
        }
        return this.idivideFloat(this.v, other.floatValue());
    }

    @Override
    public Numeric mod(Numeric other) throws QueryException {
        if (other instanceof IntNumeric) {
            if (other instanceof LonNumeric) {
                return this.modLong(this.v, other.longValue());
            }
            return other.add(this);
        }
        if (other instanceof DecNumeric) {
            return this.modBigDecimal(new BigDecimal(this.v), other.decimalValue());
        }
        if (other instanceof Dbl) {
            return this.modDouble(this.v, other.doubleValue());
        }
        return this.divideFloat(this.v, other.floatValue());
    }

    @Override
    public Numeric negate() throws QueryException {
        return this.v != Long.MIN_VALUE ? new Int64(-this.v) : new Int(new BigDecimal(this.v).negate());
    }

    @Override
    public Numeric round() throws QueryException {
        return this;
    }

    @Override
    public Numeric abs() throws QueryException {
        return this.v >= 0L ? this : (this.v != Long.MIN_VALUE ? new Int64(-this.v) : new Int(new BigDecimal(this.v).negate()));
    }

    @Override
    public Numeric ceiling() throws QueryException {
        return this;
    }

    @Override
    public Numeric floor() throws QueryException {
        return this;
    }

    @Override
    public Numeric roundHalfToEven(int precision) throws QueryException {
        return this;
    }

    private static class DInt64
    extends Int64 {
        private final Type type;

        public DInt64(long v, Type type) {
            super(v);
            this.type = type;
        }

        @Override
        public Type type() {
            return this.type;
        }
    }
}

