/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.atomic;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AbstractAtomic;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.Str;
import io.brackit.query.jdm.Type;

public class Null
extends AbstractAtomic {
    @Override
    public Type type() {
        return Type.NULL;
    }

    @Override
    public Atomic asType(Type type) {
        return new DNull(this, type);
    }

    @Override
    public Str asStr() {
        return new Str("null");
    }

    @Override
    public boolean booleanValue() {
        return false;
    }

    @Override
    public int cmp(Atomic other) {
        if (other instanceof Null) {
            return 0;
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s' with '%s'", this.type(), other.type());
    }

    @Override
    public int atomicCmpInternal(Atomic atomic) {
        return atomic instanceof Null ? 0 : -1;
    }

    @Override
    public int atomicCode() {
        return 16;
    }

    @Override
    public String stringValue() {
        return "null";
    }

    @Override
    public int hashCode() {
        return "null".hashCode();
    }

    private final class DNull
    extends Null {
        private final Type type;

        public DNull(Null nullVal, Type type) {
            this.type = type;
        }

        @Override
        public Type type() {
            return this.type;
        }
    }
}

