/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.atomic;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AbstractAtomic;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.Str;
import io.brackit.query.jdm.Type;

public class Una
extends AbstractAtomic {
    public static final Una EMPTY = new Una("");
    public final String str;

    public Una(String str) {
        if (str == null) {
            str = "";
        }
        this.str = str;
    }

    @Override
    public Type type() {
        return Type.UNA;
    }

    @Override
    public Atomic asType(Type type) throws QueryException {
        return new DUna(this.str, type);
    }

    @Override
    public Una asUna() {
        return this;
    }

    @Override
    public boolean booleanValue() throws QueryException {
        return !this.str.isEmpty();
    }

    @Override
    public int cmp(Atomic other) throws QueryException {
        if (other instanceof Str || other instanceof Una) {
            return this.str.compareTo(other.stringValue());
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s' with '%s'", this.type(), other.type());
    }

    @Override
    public int atomicCmpInternal(Atomic atomic) {
        return this.str.compareTo(atomic.stringValue());
    }

    @Override
    public int atomicCode() {
        return 16;
    }

    @Override
    public String stringValue() {
        return this.str;
    }

    @Override
    public int hashCode() {
        return this.str.hashCode();
    }

    private static class DUna
    extends Una {
        private final Type type;

        public DUna(String str, Type type) {
            super(str);
            this.type = type;
        }

        @Override
        public Type type() {
            return this.type;
        }
    }
}

