/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.block;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.block.Block;
import io.brackit.query.block.MutexSink;
import io.brackit.query.block.Sink;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Stream;
import io.brackit.query.util.sort.Ordering;

public class OrderBy
implements Block {
    final Expr[] orderByExprs;
    final Ordering.OrderModifier[] modifier;

    public OrderBy(Expr[] orderByExprs, Ordering.OrderModifier[] modifier) {
        this.orderByExprs = orderByExprs;
        this.modifier = modifier;
    }

    @Override
    public int outputWidth(int initSize) {
        return initSize;
    }

    @Override
    public Sink create(QueryContext ctx, Sink sink) throws QueryException {
        return new OrderBySink(sink, ctx);
    }

    private class OrderBySink
    extends MutexSink {
        final Sink sink;
        final QueryContext ctx;
        final Ordering sort;

        OrderBySink(Sink sink, QueryContext ctx) {
            this.sink = sink;
            this.ctx = ctx;
            this.sort = new Ordering(OrderBy.this.orderByExprs, OrderBy.this.modifier);
        }

        @Override
        public Sink partition(Sink stopAt) {
            return new OrderBySink(this.sink.partition(stopAt), this.ctx);
        }

        @Override
        protected MutexSink.Out doPreOutput(Tuple[] buf, int len) throws QueryException {
            Sequence[][] sortKeys = new Sequence[buf.length][];
            for (int i = 0; i < len; ++i) {
                sortKeys[i] = this.sort.sortKeys(this.ctx, buf[i]);
            }
            return new Sortable(sortKeys, buf, len);
        }

        @Override
        protected void doOutput(MutexSink.Out out) throws QueryException {
            Sortable s = (Sortable)out;
            for (int i = 0; i < s.len; ++i) {
                this.sort.add(s.sortKeys[i], s.buf[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doEnd() throws QueryException {
            Stream<Tuple> s = this.sort.sorted();
            try {
                Tuple t;
                this.sink.begin();
                int bufSize = 20;
                Tuple[] buf = new Tuple[bufSize];
                int len = 0;
                while ((t = s.next()) != null) {
                    buf[len++] = t;
                    if (len != bufSize) continue;
                    this.sink.output(buf, len);
                    buf = new Tuple[bufSize];
                    len = 0;
                }
                if (len > 0) {
                    this.sink.output(buf, len);
                }
                this.sink.end();
            }
            finally {
                this.sort.clear();
                s.close();
            }
        }

        @Override
        protected void doFail() throws QueryException {
            this.sink.fail();
            if (this.sort != null) {
                this.sort.clear();
            }
        }
    }

    private static class Sortable
    extends MutexSink.Out {
        final Sequence[][] sortKeys;
        final Tuple[] buf;
        final int len;

        public Sortable(Sequence[][] sortKeys, Tuple[] buf, int len) {
            this.sortKeys = sortKeys;
            this.buf = buf;
            this.len = len;
        }
    }
}

