/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.block;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.block.Block;
import io.brackit.query.block.ChainedSink;
import io.brackit.query.block.Sink;
import io.brackit.query.expr.PrintExpr;
import java.io.PrintStream;

public class Print
implements Block {
    private final PrintStream out;

    public Print(PrintStream out) {
        this.out = out;
    }

    @Override
    public Sink create(QueryContext ctx, Sink sink) throws QueryException {
        return new PrintSink(sink, this.out);
    }

    @Override
    public int outputWidth(int initSize) {
        return initSize;
    }

    public static class PrintSink
    extends ChainedSink {
        private final PrintStream out;
        private final Sink sink;
        private int count;

        public PrintSink(Sink sink, PrintStream out) {
            this.sink = sink;
            this.out = out;
        }

        @Override
        protected ChainedSink doFork() {
            return new PrintSink(this.sink != null ? this.sink.fork() : null, this.out);
        }

        @Override
        protected ChainedSink doPartition(Sink stopAt) {
            return new PrintSink(this.sink != null ? this.sink.partition(stopAt) : null, this.out);
        }

        @Override
        protected void doOutput(Tuple[] buf, int len) throws QueryException {
            for (int i = 0; i < len; ++i) {
                ++this.count;
                this.out.println(PrintExpr.asString(buf[i]));
            }
            if (this.sink != null) {
                this.sink.output(buf, len);
            }
        }

        @Override
        protected void doBegin() throws QueryException {
            if (this.sink != null) {
                this.sink.begin();
            }
            this.out.println(">>>>");
        }

        @Override
        protected void doEnd() throws QueryException {
            if (this.sink != null) {
                this.sink.end();
            }
            this.out.println("<<<<");
        }

        @Override
        protected void doFail() throws QueryException {
            if (this.sink != null) {
                this.sink.fail();
            }
        }

        @Override
        protected void doFirstBegin() throws QueryException {
            this.count = 0;
            this.out.println("--- ");
        }

        @Override
        protected void doFinalEnd() throws QueryException {
            this.out.println("---");
            this.out.print(this.count);
            this.out.println(" results");
            this.out.flush();
        }
    }
}

