/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.block;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.block.Block;
import io.brackit.query.block.ChainedSink;
import io.brackit.query.block.ConcurrentSink;
import io.brackit.query.block.FJControl;
import io.brackit.query.block.SerialSink;
import io.brackit.query.block.SerialValve;
import io.brackit.query.block.Sink;
import io.brackit.query.compiler.translator.Reference;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.util.Cfg;
import io.brackit.query.util.Cmp;
import io.brackit.query.util.join.FastList;
import io.brackit.query.util.join.MultiTypeJoinTable;
import java.util.Arrays;
import java.util.concurrent.Semaphore;

public class TableJoin
implements Block {
    final Block l;
    final Block r;
    final Block o;
    final Expr rExpr;
    final Expr lExpr;
    final boolean leftJoin;
    final Cmp cmp;
    final boolean isGCmp;
    final boolean skipSort;
    final int pad;
    int groupVar = -1;
    boolean ordRight = Cfg.asBool("org.brackit.xquery.join.loadordered", true);
    int rPermits = FJControl.PERMITS;

    public TableJoin(Cmp cmp, boolean isGCmsp, boolean leftJoin, boolean skipSort, Block l, Expr lExpr, Block r, Expr rExpr, Block o) {
        this.cmp = cmp;
        this.isGCmp = isGCmsp;
        this.leftJoin = leftJoin;
        this.skipSort = skipSort;
        this.l = l;
        this.r = r;
        this.o = o;
        this.rExpr = rExpr;
        this.lExpr = lExpr;
        this.pad = r.outputWidth(0) + (o != null ? o.outputWidth(0) : 0);
    }

    @Override
    public int outputWidth(int initSize) {
        return this.l.outputWidth(initSize) + this.pad;
    }

    public Reference group() {
        return pos -> {
            this.groupVar = pos;
        };
    }

    @Override
    public Sink create(QueryContext ctx, Sink sink) throws QueryException {
        Join join = new Join();
        PartitionEnd pe = null;
        if (this.o != null) {
            pe = new PartitionEnd(sink);
            sink = this.o.create(ctx, pe);
        }
        Probe probe = new Probe(sink, pe, ctx, join);
        Sink leftIn = this.l.create(ctx, probe);
        return new TableJoinSink(FJControl.PERMITS, ctx, leftIn, join);
    }

    private static class Join {
        volatile MultiTypeJoinTable table;
        volatile Atomic gk;

        private Join() {
        }
    }

    private static class PartitionEnd
    implements Sink {
        private final Sink out;
        private PartitionEnd next;

        PartitionEnd(Sink out) {
            this.out = out;
        }

        @Override
        public Sink fork() {
            this.next = new PartitionEnd(this.out.fork());
            return this.next;
        }

        @Override
        public Sink partition(Sink stopAt) {
            Sink nout = stopAt == this ? this.out.fork() : this.out.partition(stopAt);
            this.next = new PartitionEnd(nout);
            return this.next;
        }

        @Override
        public void output(Tuple[] buf, int len) throws QueryException {
            this.out.output(buf, len);
        }

        @Override
        public void begin() throws QueryException {
        }

        @Override
        public void end() throws QueryException {
        }

        @Override
        public void fail() throws QueryException {
            this.out.fail();
        }

        void doBegin() throws QueryException {
            this.out.begin();
        }

        void doEnd() throws QueryException {
            this.out.end();
        }
    }

    private final class Probe
    implements Sink {
        final QueryContext ctx;
        final Join join;
        final Sequence[] padding;
        Sink sink;
        PartitionEnd pe;

        Probe(Sink sink, PartitionEnd pe, QueryContext ctx, Join join) {
            this.ctx = ctx;
            this.join = join;
            this.padding = new Sequence[TableJoin.this.pad];
            this.sink = sink;
            this.pe = pe;
        }

        @Override
        public Sink fork() {
            if (this.pe == null) {
                return new Probe(this.sink.fork(), null, this.ctx, this.join);
            }
            return this.partition(this.pe);
        }

        @Override
        public Sink partition(Sink stopAt) {
            if (this.pe == null) {
                return new Probe(this.sink.partition(stopAt), null, this.ctx, this.join);
            }
            Sink fork = this.sink.partition(stopAt);
            PartitionEnd fpe = this.pe.next;
            this.pe.next = null;
            return new Probe(fork, fpe, this.ctx, this.join);
        }

        @Override
        public void output(Tuple[] buf, int len) throws QueryException {
            if (this.pe == null) {
                this.outputUnconditional(buf, len);
            } else {
                this.outputConditional(buf, len);
            }
        }

        private void outputUnconditional(Tuple[] buf, int len) throws QueryException {
            Sink s = this.sink;
            this.sink = this.sink.fork();
            s.begin();
            for (int i = 0; i < len; ++i) {
                Tuple t = buf[i];
                this.probe(t, s, s);
            }
            s.end();
        }

        private void outputConditional(Tuple[] buf, int len) throws QueryException {
            for (int i = 0; i < len; ++i) {
                Sink ss = this.sink;
                PartitionEnd spe = this.pe;
                this.sink = this.sink.partition(this.pe);
                this.pe = this.pe.next;
                spe.doBegin();
                ss.begin();
                Tuple t = buf[i];
                this.probe(t, ss, spe);
                ss.end();
                spe.doEnd();
            }
        }

        private void probe(Tuple t, Sink matchSink, Sink ljoinSink) throws QueryException {
            Sequence keys = TableJoin.this.isGCmp ? TableJoin.this.lExpr.evaluate(this.ctx, t) : TableJoin.this.lExpr.evaluateToItem(this.ctx, t);
            FastList<Sequence[]> matches = this.join.table.probe(keys);
            int itSize = matches.getSize();
            if (itSize > 0) {
                Tuple[] buf2 = new Tuple[itSize];
                for (int j = 0; j < itSize; ++j) {
                    buf2[j] = t.concat(matches.get(j));
                }
                matchSink.output(buf2, itSize);
            } else if (TableJoin.this.leftJoin) {
                Tuple[] buf2 = new Tuple[]{t.concat(this.padding)};
                ljoinSink.output(buf2, 1);
            }
        }

        @Override
        public void begin() throws QueryException {
        }

        @Override
        public void end() throws QueryException {
            if (this.pe != null) {
                this.pe.doBegin();
            }
            this.sink.begin();
            this.sink.end();
            if (this.pe != null) {
                this.pe.doEnd();
            }
        }

        @Override
        public void fail() throws QueryException {
            this.sink.fail();
        }
    }

    private final class TableJoinSink
    extends SerialSink {
        final QueryContext ctx;
        final Join join;
        Sink sink;

        public TableJoinSink(int permits, QueryContext ctx, Sink sink, Join join) {
            super(permits);
            this.ctx = ctx;
            this.sink = sink;
            this.join = join;
        }

        public TableJoinSink(Semaphore sem, QueryContext ctx, Sink sink, Join join) {
            super(sem);
            this.ctx = ctx;
            this.sink = sink;
            this.join = join;
        }

        @Override
        protected ChainedSink doFork() {
            return new TableJoinSink(this.sem, this.ctx, this.sink.fork(), this.join);
        }

        @Override
        protected ChainedSink doPartition(Sink stopAt) {
            return new TableJoinSink(this.sem, this.ctx, this.sink.partition(stopAt), this.join);
        }

        @Override
        protected void setPending(Tuple[] buf, int len) throws QueryException {
            this.output(buf, len, false);
        }

        @Override
        protected void doOutput(Tuple[] buf, int len) throws QueryException {
            this.output(buf, len, true);
        }

        private void output(Tuple[] buf, int len, boolean hasToken) throws QueryException {
            int end = 0;
            while (end < len) {
                int start = end;
                if (start >= (end = this.probeSize(buf, len, end))) {
                    if (hasToken) {
                        Tuple t = buf[start];
                        System.out.println("START LOAD");
                        this.load(t);
                        System.out.println("END LOAD");
                        end = start;
                        continue;
                    }
                    Tuple[] remaining = Arrays.copyOfRange(buf, start, len);
                    super.setPending(remaining, len - start);
                    return;
                }
                this.probe(Arrays.copyOfRange(buf, start, end));
            }
        }

        private void probe(Tuple[] buf) throws QueryException {
            Sink ss = this.sink;
            this.sink = this.sink.fork();
            ss.begin();
            ss.output(buf, buf.length);
            ss.end();
        }

        private void load(Tuple t) throws QueryException {
            int offset = t.getSize();
            MultiTypeJoinTable table = new MultiTypeJoinTable(TableJoin.this.cmp, TableJoin.this.isGCmp, TableJoin.this.skipSort);
            Load load = new Load(this.ctx, table, offset);
            load = TableJoin.this.ordRight ? new SerialValve(TableJoin.this.rPermits, (Sink)load) : load;
            Sink rightIn = TableJoin.this.r.create(this.ctx, load);
            rightIn.begin();
            try {
                rightIn.output(new Tuple[]{t}, 1);
                rightIn.end();
            }
            catch (QueryException e) {
                rightIn.fail();
                throw e;
            }
            this.join.gk = TableJoin.this.groupVar >= 0 ? (Atomic)t.get(TableJoin.this.groupVar) : null;
            this.join.table = table;
        }

        private int probeSize(Tuple[] buf, int len, int end) throws QueryException {
            if (this.join.table == null) {
                return 0;
            }
            if (TableJoin.this.groupVar >= 0) {
                Atomic ngk;
                Atomic pgk = this.join.gk;
                Atomic gk = (Atomic)buf[end++].get(TableJoin.this.groupVar);
                if (pgk == null || pgk.atomicCmp(gk) != 0) {
                    return 0;
                }
                while (end < len && (ngk = (Atomic)buf[end].get(TableJoin.this.groupVar)).atomicCmp(gk) == 0) {
                    ++end;
                }
            } else {
                end = len;
            }
            return end;
        }

        @Override
        public void doBegin() throws QueryException {
        }

        @Override
        public void doEnd() throws QueryException {
            this.sink.begin();
            this.sink.end();
        }

        @Override
        public void doFail() throws QueryException {
            this.sink.fail();
        }
    }

    private final class Load
    extends ConcurrentSink {
        final QueryContext ctx;
        final MultiTypeJoinTable table;
        final int offset;
        int pos = 1;

        Load(QueryContext ctx, MultiTypeJoinTable table, int offset) {
            this.ctx = ctx;
            this.table = table;
            this.offset = offset;
        }

        @Override
        public Sink partition(Sink stopAt) {
            return this.fork();
        }

        @Override
        public void output(Tuple[] buf, int len) throws QueryException {
            for (int i = 0; i < len; ++i) {
                Sequence keys;
                Tuple t = buf[i];
                Sequence sequence = keys = TableJoin.this.isGCmp ? TableJoin.this.rExpr.evaluate(this.ctx, t) : TableJoin.this.rExpr.evaluateToItem(this.ctx, t);
                if (keys == null) continue;
                Sequence[] tmp = t.array();
                Sequence[] bindings = Arrays.copyOfRange(tmp, this.offset, tmp.length);
                bindings[0] = null;
                try (Iter iter = bindings[1].iterate();){
                    bindings[1] = ((Node)iter.next()).getFirstChild().getFirstChild().getValue();
                }
                this.table.add(keys, bindings, this.pos++);
            }
        }
    }
}

