/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler;

import io.brackit.query.Query;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AnyURI;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.compiler.AST;
import io.brackit.query.compiler.BaseResolver;
import io.brackit.query.compiler.ModuleResolver;
import io.brackit.query.compiler.Target;
import io.brackit.query.compiler.analyzer.Analyzer;
import io.brackit.query.compiler.optimizer.Optimizer;
import io.brackit.query.compiler.optimizer.TopDownOptimizer;
import io.brackit.query.compiler.parser.JsoniqParser;
import io.brackit.query.compiler.translator.TopDownTranslator;
import io.brackit.query.compiler.translator.Translator;
import io.brackit.query.function.bit.ArrayValues;
import io.brackit.query.function.bit.BitFun;
import io.brackit.query.function.bit.Create;
import io.brackit.query.function.bit.Drop;
import io.brackit.query.function.bit.Eval;
import io.brackit.query.function.bit.Exists;
import io.brackit.query.function.bit.Fields;
import io.brackit.query.function.bit.Len;
import io.brackit.query.function.bit.Load;
import io.brackit.query.function.bit.Mkdir;
import io.brackit.query.function.bit.Now;
import io.brackit.query.function.bit.Parse;
import io.brackit.query.function.bit.Serialize;
import io.brackit.query.function.bit.Silent;
import io.brackit.query.function.bit.Store;
import io.brackit.query.function.bit.Values;
import io.brackit.query.function.io.Ls;
import io.brackit.query.function.io.Read;
import io.brackit.query.function.io.Readline;
import io.brackit.query.function.io.Write;
import io.brackit.query.function.io.Writeline;
import io.brackit.query.function.json.JSONParse;
import io.brackit.query.function.json.Keys;
import io.brackit.query.function.json.Size;
import io.brackit.query.module.Functions;
import io.brackit.query.module.Module;
import io.brackit.query.util.dot.DotUtil;
import java.util.Map;

public class CompileChain {
    final AnyURI baseURI;
    final ModuleResolver resolver;

    public CompileChain() {
        this(new BaseResolver(), null);
    }

    public CompileChain(AnyURI baseURI) {
        this(new BaseResolver(), baseURI);
    }

    public CompileChain(ModuleResolver resolver) {
        this(resolver, null);
    }

    public CompileChain(ModuleResolver resolver, AnyURI baseURI) {
        this.resolver = resolver;
        this.baseURI = baseURI;
    }

    protected Optimizer getOptimizer(Map<QNm, Str> options) {
        return new TopDownOptimizer(options);
    }

    protected Translator getTranslator(Map<QNm, Str> options) {
        return new TopDownTranslator(options);
    }

    protected ModuleResolver getModuleResolver() {
        return this.resolver;
    }

    protected AST parse(String query) throws QueryException {
        return new JsoniqParser(query).parse();
    }

    public Module compile(String query) throws QueryException {
        if (Query.DEBUG) {
            System.out.printf("Compiling:\n%s%n", query);
        }
        ModuleResolver resolver = this.getModuleResolver();
        AST parsed = this.parse(query);
        if (Query.DEBUG) {
            DotUtil.drawDotToFile(parsed.dot(), Query.DEBUG_DIR, "parsed");
        }
        Analyzer analyzer = new Analyzer(resolver, this.baseURI, parsed);
        AST xquery = analyzer.getAST();
        Module module = analyzer.getModules().get(0);
        Map<QNm, Str> options = module.getOptions();
        for (Target t : analyzer.getTargets()) {
            t.optimize(this.getOptimizer(options));
        }
        if (Query.DEBUG) {
            DotUtil.drawDotToFile(xquery.dot(), Query.DEBUG_DIR, "xquery");
        }
        for (Target t : analyzer.getTargets()) {
            t.translate(this.getTranslator(options));
        }
        for (Module m : analyzer.getModules()) {
            if (m.getTargetNS() == null) continue;
            resolver.register(m.getTargetNS(), m);
        }
        return module;
    }

    static {
        Functions.predefine(new Readline());
        Functions.predefine(new Writeline());
        Functions.predefine(new Read());
        Functions.predefine(new Write());
        Functions.predefine(new Ls(true));
        Functions.predefine(new Ls(false));
        Functions.predefine(BitFun.SOME_FUNC);
        Functions.predefine(BitFun.EVERY_FUNC);
        Functions.predefine(new Now());
        Functions.predefine(new Silent());
        Functions.predefine(new Parse());
        Functions.predefine(new Eval());
        Functions.predefine(new Serialize());
        Functions.predefine(new Len());
        Functions.predefine(new Fields());
        Functions.predefine(new Values());
        Functions.predefine(new Store(true));
        Functions.predefine(new Store(false));
        Functions.predefine(new Load(true));
        Functions.predefine(new Load(false));
        Functions.predefine(new Create());
        Functions.predefine(new Drop());
        Functions.predefine(new Mkdir());
        Functions.predefine(new Exists());
        Functions.predefine(new ArrayValues());
        Functions.predefine(new JSONParse());
        Functions.predefine(new Size());
        Functions.predefine(new Keys());
    }
}

