/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler.analyzer;

import io.brackit.query.ErrorCode;
import io.brackit.query.Query;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AnyURI;
import io.brackit.query.atomic.Bool;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.compiler.AST;
import io.brackit.query.compiler.Bits;
import io.brackit.query.compiler.XQ;
import io.brackit.query.compiler.analyzer.AbstractAnalyzer;
import io.brackit.query.compiler.analyzer.NestedContext;
import io.brackit.query.compiler.analyzer.VarScopes;
import io.brackit.query.expr.Variable;
import io.brackit.query.function.UDF;
import io.brackit.query.function.json.JSONFun;
import io.brackit.query.jdm.Function;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.type.AttributeType;
import io.brackit.query.jdm.type.ElementType;
import io.brackit.query.jdm.type.ItemType;
import io.brackit.query.jdm.type.NSNameWildcardTest;
import io.brackit.query.jdm.type.NSWildcardNameTest;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.module.Functions;
import io.brackit.query.module.Module;
import io.brackit.query.module.Namespaces;
import io.brackit.query.module.StaticContext;
import io.brackit.query.util.Whitespace;

public class ExprAnalyzer
extends AbstractAnalyzer {
    protected final VarScopes variables = new VarScopes();
    protected final Module module;

    public ExprAnalyzer(Module module) {
        this.module = module;
        this.sctx = module.getStaticContext();
    }

    public Module getModule() {
        return this.module;
    }

    void functionBody(AST body) throws QueryException {
        this.enclosedExpr(body);
    }

    protected boolean queryBody(AST body) throws QueryException {
        if (body.getType() != 5) {
            return false;
        }
        this.expr(body.getChild(0));
        return true;
    }

    boolean expr(AST expr) throws QueryException {
        if (expr.getType() != 6) {
            this.exprSingle(expr);
        } else {
            for (int i = 0; i < expr.getChildCount(); ++i) {
                this.exprSingle(expr.getChild(i));
            }
        }
        return true;
    }

    boolean exprSingle(AST expr) throws QueryException {
        return this.flowrExpr(expr) || this.quantifiedExpr(expr) || this.switchExpr(expr) || this.typeswitchExpr(expr) || this.ifExpr(expr) || this.tryCatchExpr(expr) || this.insertExpr(expr) || this.deleteExpr(expr) || this.renameExpr(expr) || this.replaceExpr(expr) || this.transformExpr(expr) || this.insertJsonExpr(expr) || this.deleteJsonExpr(expr) || this.renameJsonExpr(expr) || this.replaceJsonExpr(expr) || this.appendJsonExpr(expr) || this.orExpr(expr);
    }

    protected boolean insertExpr(AST expr) throws QueryException {
        if (expr.getType() != 219) {
            return false;
        }
        AST src = expr.getChild(1);
        this.exprSingle(src);
        AST target = expr.getChild(2);
        this.exprSingle(target);
        return true;
    }

    protected boolean deleteExpr(AST expr) throws QueryException {
        if (expr.getType() != 225) {
            return false;
        }
        AST target = expr.getChild(0);
        this.exprSingle(target);
        return true;
    }

    protected boolean renameExpr(AST expr) throws QueryException {
        if (expr.getType() != 228) {
            return false;
        }
        AST target = expr.getChild(0);
        this.exprSingle(target);
        AST newName = expr.getChild(1);
        this.exprSingle(newName);
        return true;
    }

    protected boolean replaceExpr(AST expr) throws QueryException {
        if (expr.getType() == 226) {
            AST target = expr.getChild(0);
            this.exprSingle(target);
            AST replacement = expr.getChild(1);
            this.exprSingle(replacement);
        } else if (expr.getType() == 227) {
            AST target = expr.getChild(0);
            this.exprSingle(target);
            AST replacement = expr.getChild(1);
            this.exprSingle(replacement);
        } else {
            return false;
        }
        return true;
    }

    protected boolean transformExpr(AST expr) throws QueryException {
        if (expr.getType() != 229) {
            return false;
        }
        int scopeCount = this.scopeCount();
        int pos = 0;
        while (pos < expr.getChildCount() - 2) {
            this.openScope();
            AST binding = expr.getChild(pos++);
            QNm name = (QNm)binding.getChild(0).getValue();
            name = this.expand(name, AbstractAnalyzer.DefaultNS.EMPTY);
            name = this.bind(name);
            binding.getChild(0).setValue(name);
            this.exprSingle(binding.getChild(1));
            this.offerScope();
        }
        AST modify = expr.getChild(pos++);
        this.exprSingle(modify);
        AST ret = expr.getChild(pos);
        this.exprSingle(ret);
        for (int i = this.scopeCount(); i > scopeCount; --i) {
            this.closeScope();
        }
        return true;
    }

    private boolean appendJsonExpr(AST expr) {
        if (expr.getType() != 272) {
            return false;
        }
        AST src = expr.getChild(0);
        this.exprSingle(src);
        AST target = expr.getChild(1);
        this.exprSingle(target);
        return true;
    }

    private boolean replaceJsonExpr(AST expr) {
        if (expr.getType() != 271) {
            return false;
        }
        AST target = expr.getChild(0);
        this.postFixExpr(target);
        AST newExpr = expr.getChild(1);
        this.exprSingle(newExpr);
        return true;
    }

    private boolean renameJsonExpr(AST expr) {
        if (expr.getType() != 270) {
            return false;
        }
        AST target = expr.getChild(0);
        this.postFixExpr(target);
        AST newExpr = expr.getChild(1);
        this.exprSingle(newExpr);
        return true;
    }

    private boolean deleteJsonExpr(AST expr) {
        if (expr.getType() != 269) {
            return false;
        }
        AST target = expr.getChild(0);
        this.exprSingle(target);
        return true;
    }

    private boolean insertJsonExpr(AST expr) {
        if (expr.getType() != 268) {
            return false;
        }
        AST src = expr.getChild(0);
        this.exprSingle(src);
        AST target = expr.getChild(1);
        this.exprSingle(target);
        if (expr.getChildCount() == 3) {
            AST position = expr.getChild(2);
            this.exprSingle(position);
        }
        return true;
    }

    protected boolean flowrExpr(AST flwor) throws QueryException {
        int i;
        if (flwor.getType() != 7) {
            return false;
        }
        int scopeCount = this.scopeCount();
        this.initialClause(flwor.getChild(0));
        for (i = 1; i < flwor.getChildCount() - 1; ++i) {
            this.intermediateClause(flwor.getChild(i));
        }
        this.exprSingle(flwor.getChild(flwor.getChildCount() - 1).getChild(0));
        for (i = this.scopeCount(); i > scopeCount; --i) {
            this.closeScope();
        }
        return true;
    }

    protected boolean initialClause(AST clause) throws QueryException {
        return this.forClause(clause) || this.letClause(clause) || this.windowClause(clause);
    }

    protected boolean forClause(AST clause) throws QueryException {
        if (clause.getType() != 8) {
            return false;
        }
        this.forBinding(clause);
        return true;
    }

    protected boolean forBinding(AST clause) throws QueryException {
        this.openScope();
        int pos = 0;
        AST child = clause.getChild(pos++);
        QNm forVar = this.typedVarBinding(child);
        child = clause.getChild(pos++);
        if (child.getType() == 9) {
            child = clause.getChild(pos++);
        }
        if (child.getType() == 10) {
            try {
                this.positionalVar(child);
            }
            catch (QueryException e) {
                if (e.getCode().equals(ErrorCode.ERR_DUPLICATE_VARIABLE_DECL)) {
                    throw new QueryException(ErrorCode.ERR_FOR_VAR_AND_POS_VAR_EQUAL, "Bound variable '%s' and its associated positional variable have the same name", forVar);
                }
                throw e;
            }
            child = clause.getChild(pos);
        }
        this.exprSingle(child);
        this.offerScope();
        return true;
    }

    protected QNm typedVarBinding(AST binding) throws QueryException {
        QNm name = (QNm)binding.getChild(0).getValue();
        QNm expanded = this.expand(name, AbstractAnalyzer.DefaultNS.EMPTY);
        name = this.bind(expanded);
        binding.getChild(0).setValue(name);
        return expanded;
    }

    SequenceType typeDeclaration(AST decl) throws QueryException {
        return this.sequenceType(decl);
    }

    protected QNm positionalVar(AST binding) throws QueryException {
        QNm name = (QNm)binding.getChild(0).getValue();
        QNm expanded = this.expand(name, AbstractAnalyzer.DefaultNS.EMPTY);
        name = this.bind(expanded);
        binding.getChild(0).setValue(name);
        return expanded;
    }

    protected boolean letClause(AST clause) throws QueryException {
        if (clause.getType() != 12) {
            return false;
        }
        this.letBinding(clause);
        return true;
    }

    protected boolean letBinding(AST clause) throws QueryException {
        this.openScope();
        this.typedVarBinding(clause.getChild(0));
        this.exprSingle(clause.getChild(1));
        this.offerScope();
        return true;
    }

    protected boolean windowClause(AST clause) throws QueryException {
        return this.tumblingWindowClause(clause) || this.slidingWindowClause(clause);
    }

    protected boolean tumblingWindowClause(AST clause) throws QueryException {
        if (clause.getType() != 209) {
            return false;
        }
        this.openScope();
        this.typedVarBinding(clause.getChild(0));
        this.exprSingle(clause.getChild(1));
        this.windowStartCondition(clause.getChild(2));
        if (clause.getChildCount() >= 4) {
            this.windowEndCondition(clause.getChild(3));
        }
        this.offerScope();
        return true;
    }

    protected boolean windowStartCondition(AST cond) throws QueryException {
        this.openScope();
        this.windowVars(cond.getChild(0));
        this.offerScope();
        this.exprSingle(cond.getChild(1));
        this.closeScope();
        return true;
    }

    protected boolean windowEndCondition(AST cond) throws QueryException {
        this.openScope();
        this.windowVars(cond.getChild(0));
        this.offerScope();
        this.exprSingle(cond.getChild(1));
        this.closeScope();
        return true;
    }

    protected void windowVars(AST windowVars) throws QueryException {
        for (int i = 0; i < windowVars.getChildCount(); ++i) {
            QNm name = (QNm)windowVars.getChild(i).getChild(0).getValue();
            name = this.expand(name, AbstractAnalyzer.DefaultNS.EMPTY);
            name = this.bind(name);
            windowVars.getChild(i).getChild(0).setValue(name);
        }
    }

    protected boolean slidingWindowClause(AST clause) throws QueryException {
        if (clause.getType() != 208) {
            return false;
        }
        this.openScope();
        this.typedVarBinding(clause.getChild(0));
        this.exprSingle(clause.getChild(1));
        this.windowStartCondition(clause.getChild(2));
        this.windowEndCondition(clause.getChild(3));
        this.offerScope();
        return true;
    }

    protected boolean intermediateClause(AST clause) throws QueryException {
        return this.initialClause(clause) || this.whereClause(clause) || this.groupByClause(clause) || this.orderByClause(clause) || this.countClause(clause);
    }

    protected boolean whereClause(AST clause) throws QueryException {
        if (clause.getType() != 13) {
            return false;
        }
        this.exprSingle(clause.getChild(0));
        return true;
    }

    protected boolean groupByClause(AST clause) throws QueryException {
        if (clause.getType() != 14) {
            return false;
        }
        for (int i = 0; i < clause.getChildCount() - 1; ++i) {
            String col;
            AST groupBySpec = clause.getChild(i);
            QNm name = (QNm)groupBySpec.getChild(0).getValue();
            name = this.expand(name, AbstractAnalyzer.DefaultNS.EMPTY);
            name = this.resolve(name);
            groupBySpec.getChild(0).setValue(name);
            if (groupBySpec.getChildCount() < 2 || (col = groupBySpec.getChild(1).getStringValue()).equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) continue;
            throw new QueryException(ErrorCode.ERR_UNKNOWN_COLLATION_IN_FLWOR_CLAUSE, "Unknown collation in group-by clause: %s", col);
        }
        return true;
    }

    protected boolean orderByClause(AST clause) throws QueryException {
        if (clause.getType() != 28) {
            return false;
        }
        for (int i = 0; i < clause.getChildCount(); ++i) {
            AST orderBySpec = clause.getChild(i);
            this.exprSingle(orderBySpec.getChild(0));
            for (int j = 1; j < orderBySpec.getChildCount(); ++j) {
                String col;
                if (orderBySpec.getChild(j).getType() != 27 || (col = orderBySpec.getChild(j).getStringValue()).equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) continue;
                throw new QueryException(ErrorCode.ERR_UNKNOWN_COLLATION_IN_FLWOR_CLAUSE, "Unknown collation in order-by clause: %s", col);
            }
        }
        return true;
    }

    protected boolean countClause(AST clause) throws QueryException {
        if (clause.getType() != 36) {
            return false;
        }
        QNm name = (QNm)clause.getChild(0).getChild(0).getValue();
        name = this.expand(name, AbstractAnalyzer.DefaultNS.EMPTY);
        name = this.bind(name);
        clause.getChild(0).getChild(0).setValue(name);
        return true;
    }

    protected boolean quantifiedExpr(AST expr) throws QueryException {
        int i;
        if (expr.getType() != 130) {
            return false;
        }
        int scopeCount = this.scopeCount();
        for (i = 1; i < expr.getChildCount() - 1; ++i) {
            this.openScope();
            this.typedVarBinding(expr.getChild(i).getChild(0));
            this.exprSingle(expr.getChild(i).getChild(1));
            this.offerScope();
        }
        this.exprSingle(expr.getChild(expr.getChildCount() - 1));
        for (i = this.scopeCount(); i > scopeCount; --i) {
            this.closeScope();
        }
        return true;
    }

    protected boolean switchExpr(AST expr) throws QueryException {
        if (expr.getType() != 132) {
            return false;
        }
        this.expr(expr.getChild(0));
        for (int i = 1; i < expr.getChildCount() - 1; ++i) {
            this.switchClause(expr.getChild(i));
        }
        this.exprSingle(expr.getChild(expr.getChildCount() - 1));
        return true;
    }

    protected boolean switchClause(AST clause) throws QueryException {
        for (int i = 0; i < clause.getChildCount() - 1; ++i) {
            this.exprSingle(clause.getChild(i));
        }
        this.exprSingle(clause.getChild(clause.getChildCount() - 1));
        return true;
    }

    protected boolean typeswitchExpr(AST expr) throws QueryException {
        if (expr.getType() != 134) {
            return false;
        }
        this.openScope();
        this.expr(expr.getChild(0));
        for (int i = 1; i < expr.getChildCount(); ++i) {
            this.caseClause(expr.getChild(i));
        }
        this.closeScope();
        return true;
    }

    protected boolean caseClause(AST clause) throws QueryException {
        this.openScope();
        int pos = 0;
        AST varOrType = clause.getChild(pos);
        if (varOrType.getType() == 11) {
            QNm name = (QNm)varOrType.getValue();
            name = this.expand(name, AbstractAnalyzer.DefaultNS.EMPTY);
            name = this.bind(name);
            varOrType.setValue(name);
            ++pos;
        }
        while (pos < clause.getChildCount() - 1) {
            this.sequenceType(clause.getChild(pos++));
        }
        this.offerScope();
        this.exprSingle(clause.getChild(clause.getChildCount() - 1));
        this.closeScope();
        return true;
    }

    protected boolean ifExpr(AST expr) throws QueryException {
        if (expr.getType() != 136) {
            return false;
        }
        this.exprSingle(expr.getChild(0));
        this.exprSingle(expr.getChild(1));
        this.exprSingle(expr.getChild(2));
        return true;
    }

    protected boolean tryCatchExpr(AST expr) throws QueryException {
        if (expr.getType() != 137) {
            return false;
        }
        this.expr(expr.getChild(0));
        this.openScope();
        QNm error = this.bind(Namespaces.ERR_CODE);
        AST errorBinding = this.errorInfoBinding(error, "xs:QName", 73);
        expr.insertChild(1, errorBinding);
        QNm desc = this.bind(Namespaces.ERR_DESCRIPTION);
        AST descBinding = this.errorInfoBinding(desc, "xs:string", 74);
        expr.insertChild(2, descBinding);
        QNm value = this.bind(Namespaces.ERR_VALUE);
        AST valueBinding = this.errorInfoBinding(value, "xs:item", 75);
        expr.insertChild(3, valueBinding);
        QNm module = this.bind(Namespaces.ERR_MODULE);
        AST moduleBinding = this.errorInfoBinding(module, "xs:string", 74);
        expr.insertChild(4, moduleBinding);
        QNm lineNo = this.bind(Namespaces.ERR_LINE_NUMBER);
        AST lineNoBinding = this.errorInfoBinding(lineNo, "xs:integer", 74);
        expr.insertChild(5, lineNoBinding);
        QNm colNo = this.bind(Namespaces.ERR_COLUMN_NUMBER);
        AST colNoBinding = this.errorInfoBinding(colNo, "xs:integer", 74);
        expr.insertChild(6, colNoBinding);
        this.offerScope();
        for (int i = 7; i < expr.getChildCount(); ++i) {
            this.tryClause(expr.getChild(i));
        }
        this.closeScope();
        return true;
    }

    private AST errorInfoBinding(QNm error, String type, int card) {
        AST errorBinding = new AST(10);
        errorBinding.addChild(new AST(119, error));
        AST sType = new AST(69);
        AST aType = new AST(72);
        aType.addChild(new AST(119, type));
        sType.addChild(aType);
        sType.addChild(new AST(card));
        errorBinding.addChild(sType);
        return errorBinding;
    }

    protected boolean tryClause(AST clause) throws QueryException {
        this.catchErrorList(clause.getChild(0));
        this.expr(clause.getChild(1));
        return true;
    }

    protected void catchErrorList(AST errorList) throws QueryException {
        for (int i = 0; i < errorList.getChildCount(); ++i) {
            this.nameTest(errorList.getChild(i), false);
        }
    }

    protected void catchVars(AST catchVar) throws QueryException {
        for (int i = 0; i < catchVar.getChildCount(); ++i) {
            QNm name = (QNm)catchVar.getChild(i).getValue();
            name = this.expand(name, AbstractAnalyzer.DefaultNS.EMPTY);
            catchVar.getChild(i).setValue(name);
        }
    }

    protected boolean orExpr(AST expr) throws QueryException {
        if (expr.getType() != 38) {
            return this.andExpr(expr);
        }
        this.orExpr(expr.getChild(0));
        this.andExpr(expr.getChild(1));
        return true;
    }

    protected boolean andExpr(AST expr) throws QueryException {
        if (expr.getType() != 39) {
            return this.comparisonExpr(expr);
        }
        this.andExpr(expr.getChild(0));
        this.comparisonExpr(expr.getChild(1));
        return true;
    }

    protected boolean comparisonExpr(AST expr) throws QueryException {
        if (expr.getType() != 55) {
            return this.stringConcatExpr(expr);
        }
        this.comparisonExpr(expr.getChild(1));
        this.stringConcatExpr(expr.getChild(2));
        return true;
    }

    protected boolean stringConcatExpr(AST expr) throws QueryException {
        if (expr.getType() != 56) {
            return this.rangeExpr(expr);
        }
        for (int i = 0; i < expr.getChildCount(); ++i) {
            this.rangeExpr(expr.getChild(i));
        }
        return true;
    }

    protected boolean rangeExpr(AST expr) throws QueryException {
        if (expr.getType() != 57) {
            return this.additiveExpr(expr);
        }
        this.rangeExpr(expr.getChild(0));
        this.additiveExpr(expr.getChild(1));
        return true;
    }

    protected boolean additiveExpr(AST expr) throws QueryException {
        if (expr.getType() != 60 || expr.getChild(0).getType() != 58 && expr.getChild(0).getType() != 59) {
            return this.multiplicativeExpr(expr);
        }
        this.additiveExpr(expr.getChild(1));
        this.multiplicativeExpr(expr.getChild(2));
        return true;
    }

    protected boolean multiplicativeExpr(AST expr) throws QueryException {
        if (expr.getType() != 60) {
            return this.unionExpr(expr);
        }
        this.multiplicativeExpr(expr.getChild(1));
        this.unionExpr(expr.getChild(2));
        return true;
    }

    protected boolean unionExpr(AST expr) throws QueryException {
        if (expr.getType() != 65) {
            return this.intersectExpr(expr);
        }
        this.unionExpr(expr.getChild(0));
        this.intersectExpr(expr.getChild(1));
        return true;
    }

    protected boolean intersectExpr(AST expr) throws QueryException {
        if (expr.getType() != 66 && expr.getType() != 67) {
            return this.instanceOfExpr(expr);
        }
        this.intersectExpr(expr.getChild(0));
        this.instanceOfExpr(expr.getChild(1));
        return true;
    }

    protected boolean instanceOfExpr(AST expr) throws QueryException {
        if (expr.getType() != 68) {
            return this.treatExpr(expr);
        }
        this.treatExpr(expr.getChild(0));
        this.sequenceType(expr.getChild(1));
        return true;
    }

    protected boolean treatExpr(AST expr) throws QueryException {
        if (expr.getType() != 77) {
            return this.castableExpr(expr);
        }
        this.castableExpr(expr.getChild(0));
        this.sequenceType(expr.getChild(1));
        return true;
    }

    protected boolean castableExpr(AST expr) throws QueryException {
        if (expr.getType() != 78) {
            return this.castExpr(expr);
        }
        this.castExpr(expr.getChild(0));
        this.singleType(expr.getChild(1));
        return true;
    }

    protected boolean castExpr(AST expr) throws QueryException {
        if (expr.getType() != 79) {
            return this.unaryExpr(expr);
        }
        this.unaryExpr(expr.getChild(0));
        this.singleType(expr.getChild(1));
        return true;
    }

    protected boolean unaryExpr(AST expr) throws QueryException {
        return this.valueExpr(expr);
    }

    protected boolean valueExpr(AST expr) throws QueryException {
        return this.validateExpr(expr) || this.pathExpr(expr) || this.extensionExpr(expr);
    }

    protected boolean extensionExpr(AST expr) throws QueryException {
        if (expr.getType() != 140) {
            return false;
        }
        for (int i = 0; i < expr.getChildCount(); ++i) {
            AST pragmaOrExpr = expr.getChild(i);
            if (pragmaOrExpr.getType() == 141) {
                QNm name = (QNm)pragmaOrExpr.getChild(0).getValue();
                name = this.expand(name, AbstractAnalyzer.DefaultNS.PRAGMA);
                pragmaOrExpr.getChild(0).setValue(name);
                continue;
            }
            this.expr(pragmaOrExpr);
        }
        return true;
    }

    protected boolean pathExpr(AST expr) throws QueryException {
        int i;
        if (expr.getType() != 81) {
            return this.stepExpr(expr);
        }
        for (i = 0; i < expr.getChildCount(); ++i) {
            this.stepExpr(expr.getChild(i));
            this.openContextItemScope();
        }
        for (i = 0; i < expr.getChildCount(); ++i) {
            this.closeContextItemScope();
        }
        return true;
    }

    protected boolean stepExpr(AST expr) throws QueryException {
        return this.postFixExpr(expr) || this.axisStep(expr);
    }

    protected boolean axisStep(AST expr) throws QueryException {
        if (expr.getType() != 83) {
            return false;
        }
        this.nodeTest(expr.getChild(1), expr.getChild(0).getChild(0).getType() == 89);
        this.referContextItem();
        this.openContextItemScope();
        for (int i = 2; i < expr.getChildCount(); ++i) {
            this.predicate(expr.getChild(i));
        }
        this.closeContextItemScope();
        return true;
    }

    protected ItemType nodeTest(AST nodeTest, boolean attributeAxis) throws QueryException {
        ItemType test = this.kindTest(nodeTest);
        test = test != null ? test : this.nameTest(nodeTest, !attributeAxis);
        return test;
    }

    protected ItemType nameTest(AST test, boolean element) throws QueryException {
        if (test.getType() != 99) {
            return null;
        }
        ItemType type = this.wildcard(test.getChild(0), element);
        if (type != null) {
            return type;
        }
        if (element) {
            QNm name = (QNm)test.getChild(0).getValue();
            name = this.expand(name, AbstractAnalyzer.DefaultNS.ELEMENT_OR_TYPE);
            test.getChild(0).setValue(name);
            return new ElementType(name);
        }
        QNm name = (QNm)test.getChild(0).getValue();
        name = this.expand(name, AbstractAnalyzer.DefaultNS.EMPTY);
        test.getChild(0).setValue(name);
        return new AttributeType(name);
    }

    protected ItemType wildcard(AST test, boolean element) throws QueryException {
        if (test.getType() == 100) {
            return new ElementType();
        }
        if (test.getType() == 110) {
            Kind kind = element ? Kind.ELEMENT : Kind.ATTRIBUTE;
            return new NSWildcardNameTest(kind, test.getStringValue());
        }
        if (test.getType() == 111) {
            Kind kind = element ? Kind.ELEMENT : Kind.ATTRIBUTE;
            return new NSNameWildcardTest(kind, this.resolvePrefix(test.getStringValue()));
        }
        return null;
    }

    protected void predicate(AST predicate) throws QueryException {
        this.expr(predicate.getChild(0));
    }

    protected boolean validateExpr(AST expr) throws QueryException {
        if (expr.getType() != 143) {
            return false;
        }
        if (expr.getChild(0).getType() == 119) {
            QNm name = (QNm)expr.getChild(0).getValue();
            name = this.expand(name, AbstractAnalyzer.DefaultNS.ELEMENT_OR_TYPE);
            expr.getChild(0).setValue(name);
            this.sctx.getTypes().resolveType(name);
        }
        this.expr(expr.getChild(1));
        return true;
    }

    protected boolean postFixExpr(AST expr) throws QueryException {
        if (expr.getType() == 253) {
            return this.derefExpr(expr);
        }
        if (expr.getType() == 254) {
            return this.derefDescendantExpr(expr);
        }
        if (expr.getType() == 243) {
            this.expr(expr.getChild(0));
            this.exprSingle(expr.getChild(1));
            return true;
        }
        if (expr.getType() == 247) {
            this.expr(expr.getChild(0));
            this.exprSingle(expr.getChild(1));
            if (expr.getChildCount() == 3) {
                this.exprSingle(expr.getChild(2));
            }
            return true;
        }
        if (expr.getType() == 249) {
            this.expr(expr.getChild(0));
            for (int i = 1; i < expr.getChildCount(); ++i) {
                this.exprSingle(expr.getChild(i));
            }
            return true;
        }
        if (expr.getType() == 206) {
            this.expr(expr.getChild(0));
            this.openContextItemScope();
            for (int i = 1; i < expr.getChildCount(); ++i) {
                this.predicate(expr.getChild(i));
            }
            this.closeContextItemScope();
        } else if (expr.getType() == 207) {
            this.expr(expr.getChild(0));
            for (int i = 1; i < expr.getChildCount(); ++i) {
                this.argument(expr.getChild(i));
            }
        } else {
            return this.primaryExpr(expr);
        }
        return true;
    }

    protected boolean primaryExpr(AST expr) throws QueryException {
        return this.literal(expr) || this.varRef(expr) || this.parenthesizedExpr(expr) || this.contextItemExpr(expr) || this.functionCall(expr) || this.orderedExpr(expr) || this.unorderedExpr(expr) || this.constructor(expr) || this.functionItemExpr(expr);
    }

    protected boolean literal(AST expr) throws QueryException {
        return this.numericLiteral(expr) || expr.getType() == 118;
    }

    protected boolean varRef(AST expr) throws QueryException {
        if (expr.getType() != 26) {
            return false;
        }
        QNm name = (QNm)expr.getValue();
        name = this.expand(name, AbstractAnalyzer.DefaultNS.EMPTY);
        name = this.resolve(name);
        expr.setValue(name);
        return true;
    }

    protected boolean parenthesizedExpr(AST expr) throws QueryException {
        if (expr.getType() != 112) {
            return false;
        }
        if (expr.getChildCount() != 0) {
            this.expr(expr.getChild(0));
        }
        return true;
    }

    protected boolean contextItemExpr(AST expr) throws QueryException {
        if (expr.getType() != 113) {
            return false;
        }
        this.referContextItem();
        return true;
    }

    protected boolean functionCall(AST expr) throws QueryException {
        if (expr.getType() != 80) {
            return false;
        }
        QNm name = (QNm)expr.getValue();
        name = this.expand(name, AbstractAnalyzer.DefaultNS.FUNCTION);
        expr.setValue(name);
        if (this.replaceFunctionCall(expr, name)) {
            return true;
        }
        int noOfParams = expr.getChildCount();
        for (int i = 0; i < noOfParams; ++i) {
            this.argument(expr.getChild(i));
        }
        Function fun = this.sctx.getFunctions().resolve(name, noOfParams);
        if (fun == null) {
            this.unknownFunction(name, noOfParams);
        }
        if (noOfParams == 0 && fun.getSignature().defaultCtxItemType() != null) {
            this.referContextItem();
        }
        return true;
    }

    private void unknownFunction(QNm name, int noOfParams) throws QueryException {
        throw new QueryException(ErrorCode.ERR_UNDEFINED_FUNCTION, "Unknown function: %s(%s)", name, (noOfParams > 0 ? "?" : "") + ", ?".repeat(Math.max(0, noOfParams - 1)));
    }

    protected boolean replaceFunctionCall(AST expr, QNm name) throws QueryException {
        if (name.getNamespaceURI().equals("http://jsoniq.org/default-function-namespace")) {
            boolean replaced = this.internalReplaceFunctionCall(expr, name = new QNm("http://www.w3.org/2005/xpath-functions", "fn", name.getLocalName()));
            if (replaced) {
                return true;
            }
            replaced = this.internalReplaceFunctionCall(expr, name = new QNm("http://jsoniq.org/functions", "http://jsoniq.org/functions", name.getLocalName()));
            if (replaced) {
                return true;
            }
            name = new QNm("http://brackit.org/ns/bit", "bit", name.getLocalName());
            return this.internalReplaceFunctionCall(expr, name);
        }
        return this.internalReplaceFunctionCall(expr, name);
    }

    private boolean internalReplaceFunctionCall(AST expr, QNm name) {
        int argc = expr.getChildCount();
        if (name.equals(Functions.FN_POSITION) || name.equals(Functions.FN_LAST)) {
            if (argc != 0) {
                throw new QueryException(ErrorCode.ERR_UNDEFINED_FUNCTION, "Illegal number of parameters for function %s() : %s'", name, argc);
            }
            expr.setType(26);
            QNm newName = name.equals(Functions.FN_POSITION) ? Bits.FS_POSITION : Bits.FS_LAST;
            expr.setValue(newName);
            return true;
        }
        if (name.equals(Functions.FN_TRUE) || name.equals(Functions.FN_FALSE)) {
            if (argc != 0) {
                throw new QueryException(ErrorCode.ERR_UNDEFINED_FUNCTION, "Illegal number of parameters for function %s() : %s'", name, argc);
            }
            expr.setType(123);
            Bool val = name.equals(Functions.FN_TRUE) ? Bool.TRUE : Bool.FALSE;
            expr.setValue(val);
            return true;
        }
        if (name.equals(Functions.FN_DEFAULT_COLLATION)) {
            if (argc != 0) {
                throw new QueryException(ErrorCode.ERR_UNDEFINED_FUNCTION, "Illegal number of parameters for function %s() : %s'", name, argc);
            }
            expr.setType(118);
            expr.setValue(new Str(this.sctx.getDefaultCollation()));
            return true;
        }
        if (name.equals(Functions.FN_STATIC_BASE_URI)) {
            if (argc != 0) {
                throw new QueryException(ErrorCode.ERR_UNDEFINED_FUNCTION, "Illegal number of parameters for function %s() : %s'", name, argc);
            }
            AnyURI baseURI = this.sctx.getBaseURI();
            if (baseURI != null) {
                expr.setType(122);
                expr.setValue(baseURI);
            } else {
                expr.setType(6);
                expr.setValue(XQ.NAMES[6]);
            }
            return true;
        }
        if (name.equals(JSONFun.JSON_NULL)) {
            if (argc != 0) {
                throw new QueryException(ErrorCode.ERR_UNDEFINED_FUNCTION, "Illegal number of parameters for function %s() : %s'", name, argc);
            }
            expr.setType(267);
            return true;
        }
        return false;
    }

    protected void argument(AST argument) throws QueryException {
        if (argument.getType() != 114) {
            this.exprSingle(argument);
        }
    }

    protected boolean orderedExpr(AST expr) throws QueryException {
        if (expr.getType() != 115) {
            return false;
        }
        this.expr(expr.getChild(0));
        return true;
    }

    protected boolean unorderedExpr(AST expr) throws QueryException {
        if (expr.getType() != 116) {
            return false;
        }
        this.expr(expr.getChild(0));
        return true;
    }

    protected boolean constructor(AST expr) throws QueryException {
        if (this.directConstructor(expr) || this.computedConstructor(expr)) {
            return true;
        }
        if (this.arrayConstructor(expr)) {
            return true;
        }
        return this.objectConstructor(expr);
    }

    protected boolean directConstructor(AST expr) throws QueryException {
        return this.dirElemConstructor(expr) || this.dirCommentConstructor(expr) || this.dirPIConstructor(expr);
    }

    protected boolean dirElemConstructor(AST expr) throws QueryException {
        AST att;
        if (expr.getType() != 154) {
            return false;
        }
        StaticContext psctx = this.sctx;
        this.sctx = new NestedContext(psctx);
        expr.setStaticContext(this.sctx);
        QNm name = (QNm)expr.getChild(0).getValue();
        AST cseq = expr.getChild(1);
        for (int i = 0; i < cseq.getChildCount() && (att = cseq.getChild(i)).getType() == 155; ++i) {
            QNm attName = (QNm)att.getChild(0).getValue();
            if ("xmlns".equals(attName.getPrefix())) {
                String prefix = attName.getLocalName();
                String uri = this.extractURIFromDirNSAttContent(att.getChild(1));
                this.checkDirNSAttBinding(prefix, uri);
                this.sctx.getNamespaces().declare(prefix, uri);
                cseq.deleteChild(i--);
                AST nsDecl = new AST(4);
                nsDecl.addChild(new AST(118, prefix));
                nsDecl.addChild(new AST(122, uri));
                expr.insertChild(0, nsDecl);
                continue;
            }
            if (!"xmlns".equals(attName.getLocalName())) continue;
            String uri = this.extractURIFromDirNSAttContent(att.getChild(1));
            this.sctx.getNamespaces().setDefaultElementNamespace(uri);
            cseq.deleteChild(i--);
            AST nsDecl = new AST(4);
            nsDecl.addChild(new AST(122, uri));
            expr.insertChild(0, nsDecl);
        }
        name = this.expand(name, AbstractAnalyzer.DefaultNS.ELEMENT_OR_TYPE);
        expr.getChild(0).setValue(name);
        int merge = 0;
        for (int i = 0; i < cseq.getChildCount(); ++i) {
            AST c = cseq.getChild(i);
            if (c.getType() == 118) {
                if (this.sctx.isBoundarySpaceStrip() && c.checkProperty("boundaryWS")) {
                    cseq.deleteChild(i--);
                    merge = 0;
                    continue;
                }
                ++merge;
                continue;
            }
            if (merge > 1) {
                StringBuilder buf = new StringBuilder();
                int firstStrPos = i - merge;
                AST sc = cseq.getChild(firstStrPos);
                buf.append(sc.getStringValue());
                for (int j = 0; j < merge - 1; ++j) {
                    buf.append(cseq.getChild(firstStrPos + 1).getStringValue());
                    cseq.deleteChild(firstStrPos + 1);
                }
                sc.setValue(buf.toString());
                i -= merge - 1;
            }
            merge = 0;
        }
        AST p = null;
        for (int i = 0; i < cseq.getChildCount(); ++i) {
            AST c = cseq.getChild(i);
            if (c.getType() == 155) {
                this.dirAttribute(c);
            } else {
                this.dirElementContent(c);
            }
            p = c;
        }
        this.sctx = psctx;
        return true;
    }

    protected String extractURIFromDirNSAttContent(AST content) throws QueryException {
        StringBuilder uri = new StringBuilder();
        for (int i = 0; i < content.getChildCount(); ++i) {
            AST c = content.getChild(i);
            if (c.getType() == 153) {
                throw new QueryException(ErrorCode.ERR_ENCLOSED_EXPR_IN_NS_ATTRIBUTE, "Illegal enclosed expression in direct namespace attribute");
            }
            uri.append(c.getStringValue());
        }
        String eolNormalized = Whitespace.normalizeXML11(uri.toString());
        String wsNormalized = Whitespace.collapse(eolNormalized);
        return wsNormalized;
    }

    protected void checkDirNSAttBinding(String prefix, String uri) throws QueryException {
        if ("xml".equals(prefix)) {
            if ("http://www.w3.org/XML/1998/namespace".equals(uri)) {
                throw new QueryException(ErrorCode.ERR_ILLEGAL_NAMESPACE_DECL, "Illegal mapping of the prefix '%s' to the namespace URI '%s'", "xml", uri);
            }
        } else {
            if ("xmlns".equals(prefix)) {
                throw new QueryException(ErrorCode.ERR_ILLEGAL_NAMESPACE_DECL, "Illegal namespace prefix '%s'", "xmlns");
            }
            if ("http://www.w3.org/XML/1998/namespace".equals(uri)) {
                throw new QueryException(ErrorCode.ERR_ILLEGAL_NAMESPACE_DECL, "Illegal namespace URI '%s'", "http://www.w3.org/2000/xmlns");
            }
        }
    }

    protected void dirAttribute(AST dirAtt) throws QueryException {
        QNm name = (QNm)dirAtt.getChild(0).getValue();
        name = this.expand(name, AbstractAnalyzer.DefaultNS.EMPTY);
        dirAtt.getChild(0).setValue(name);
        AST content = dirAtt.getChild(1);
        for (int i = 0; i < content.getChildCount(); ++i) {
            AST c = content.getChild(i);
            if (c.getType() == 118) continue;
            this.enclosedExpr(c);
        }
    }

    protected boolean dirElementContent(AST content) throws QueryException {
        return this.directConstructor(content) || content.getType() == 118 || this.enclosedExpr(content);
    }

    protected boolean dirCommentConstructor(AST expr) throws QueryException {
        return expr.getType() == 156;
    }

    protected boolean dirPIConstructor(AST expr) throws QueryException {
        return expr.getType() == 157;
    }

    protected boolean computedConstructor(AST expr) throws QueryException {
        return this.compDocConstructor(expr) || this.compElemConstructor(expr) || this.compAttrConstructor(expr) || this.compNamespaceConstructor(expr) || this.compTextConstructor(expr) || this.compCommentConstructor(expr) || this.compPIConstructor(expr);
    }

    protected boolean compDocConstructor(AST expr) throws QueryException {
        if (expr.getType() != 158) {
            return false;
        }
        if (expr.getChildCount() > 0) {
            this.expr(expr.getChild(0));
        }
        return true;
    }

    protected boolean compElemConstructor(AST expr) throws QueryException {
        if (expr.getType() != 149) {
            return false;
        }
        AST nameExpr = expr.getChild(0);
        if (nameExpr.getType() == 119) {
            QNm name = (QNm)nameExpr.getValue();
            name = this.expand(name, AbstractAnalyzer.DefaultNS.ELEMENT_OR_TYPE);
            nameExpr.setValue(name);
        } else {
            this.expr(nameExpr);
        }
        AST cseq = expr.getChild(1);
        if (cseq.getChildCount() == 1) {
            this.expr(cseq.getChild(0));
        }
        return true;
    }

    protected boolean compAttrConstructor(AST expr) throws QueryException {
        if (expr.getType() != 150) {
            return false;
        }
        AST nameExpr = expr.getChild(0);
        if (nameExpr.getType() == 119) {
            QNm name = (QNm)nameExpr.getValue();
            name = this.expand(name, AbstractAnalyzer.DefaultNS.ELEMENT_OR_TYPE);
            nameExpr.setValue(name);
        } else {
            this.expr(nameExpr);
        }
        AST cseq = expr.getChild(1);
        if (cseq.getChildCount() == 1) {
            this.expr(cseq.getChild(0));
        }
        return true;
    }

    protected boolean compNamespaceConstructor(AST expr) throws QueryException {
        if (expr.getType() != 203) {
            return false;
        }
        AST prefixExpr = expr.getChild(0);
        if (prefixExpr.getType() != 118) {
            this.expr(prefixExpr);
        }
        if (expr.getChildCount() == 2) {
            this.expr(expr.getChild(1));
        }
        return true;
    }

    protected boolean compTextConstructor(AST expr) throws QueryException {
        if (expr.getType() != 159) {
            return false;
        }
        this.expr(expr.getChild(0));
        return true;
    }

    protected boolean compCommentConstructor(AST expr) throws QueryException {
        if (expr.getType() != 151) {
            return false;
        }
        this.expr(expr.getChild(0));
        return true;
    }

    protected boolean compPIConstructor(AST expr) throws QueryException {
        if (expr.getType() != 204) {
            return false;
        }
        AST prefixExpr = expr.getChild(0);
        if (prefixExpr.getType() != 118) {
            this.expr(prefixExpr);
        }
        if (expr.getChildCount() == 2) {
            this.expr(expr.getChild(1));
        }
        return true;
    }

    protected boolean functionItemExpr(AST expr) throws QueryException {
        return this.literalFunctionItem(expr) || this.inlineFunctionItem(expr);
    }

    protected boolean literalFunctionItem(AST expr) throws QueryException {
        if (expr.getType() != 146) {
            return false;
        }
        QNm name = (QNm)expr.getChild(0).getValue();
        name = this.expand(name, AbstractAnalyzer.DefaultNS.FUNCTION);
        expr.getChild(0).setValue(name);
        return true;
    }

    protected boolean inlineFunctionItem(AST expr) throws QueryException {
        AST child;
        if (expr.getType() != 147) {
            return false;
        }
        int pos = 0;
        int noOfParameters = expr.getChildCount() - 2;
        QNm[] pNames = new QNm[noOfParameters];
        SequenceType[] pTypes = new SequenceType[noOfParameters];
        for (int i = 0; i < noOfParameters; ++i) {
            child = expr.getChild(pos++);
            this.typedVarBinding(child);
            pNames[i] = (QNm)child.getChild(0).getValue();
            for (int j = 0; j < i; ++j) {
                if (pNames[i].atomicCmp(pNames[j]) != 0) continue;
                throw new QueryException(ErrorCode.ERR_DUPLICATE_FUN_PARAMETER, "Duplicate parameter in declared function: %s", pNames[j]);
            }
            pTypes[i] = child.getChildCount() == 2 ? this.sequenceType(child.getChild(1)) : SequenceType.ITEM_SEQUENCE;
        }
        this.offerScope();
        child = expr.getChild(pos++);
        SequenceType resultType = this.sequenceType(child);
        this.functionBody(expr.getChild(pos));
        Signature signature = new Signature(resultType, pTypes);
        UDF udf = new UDF(null, signature, false);
        expr.setProperty("udf", udf);
        expr.setProperty("paramNames", pNames);
        return true;
    }

    boolean enclosedExpr(AST expr) throws QueryException {
        if (expr.getType() != 153) {
            return false;
        }
        this.expr(expr.getChild(0));
        return true;
    }

    protected boolean arrayConstructor(AST expr) throws QueryException {
        if (expr.getType() != 244) {
            return false;
        }
        for (int i = 0; i < expr.getChildCount(); ++i) {
            AST field = expr.getChild(i);
            int fType = field.getType();
            if (fType != 245 && fType != 246) {
                throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "Invalid array field type: %s", fType);
            }
            this.expr(field.getChild(0));
        }
        return true;
    }

    protected boolean objectConstructor(AST expr) throws QueryException {
        if (expr.getType() != 250) {
            return false;
        }
        for (int i = 0; i < expr.getChildCount(); ++i) {
            AST field = expr.getChild(i);
            int fType = field.getType();
            if (fType == 252) {
                this.expr(field.getChild(0));
                this.expr(field.getChild(1));
                continue;
            }
            if (fType == 251) {
                this.expr(field.getChild(0));
                continue;
            }
            throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "Invalid record field type: %s", fType);
        }
        return true;
    }

    protected boolean derefExpr(AST expr) throws QueryException {
        if (expr.getType() != 253) {
            return false;
        }
        this.expr(expr.getChild(0));
        for (int i = 1; i < expr.getChildCount(); ++i) {
            if (this.stepExpr(expr.getChild(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean derefDescendantExpr(AST expr) throws QueryException {
        if (expr.getType() != 254) {
            return false;
        }
        this.expr(expr.getChild(0));
        for (int i = 1; i < expr.getChildCount(); ++i) {
            if (this.stepExpr(expr.getChild(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean numericLiteral(AST literal) throws QueryException {
        return this.integerLiteral(literal) || this.decimalLiteral(literal) || this.doubleLiteral(literal);
    }

    protected boolean doubleLiteral(AST literal) throws QueryException {
        return literal.getType() == 120;
    }

    protected boolean decimalLiteral(AST literal) throws QueryException {
        return literal.getType() == 121;
    }

    protected boolean integerLiteral(AST literal) throws QueryException {
        return literal.getType() == 117;
    }

    QNm bind(QNm name) throws QueryException {
        if (Query.DEBUG && log.isDebugEnabled()) {
            log.debug("Declare variable " + String.valueOf(name));
        }
        if (this.variables.check(name)) {
            throw new QueryException(ErrorCode.ERR_DUPLICATE_VARIABLE_DECL, "Variable $%s has already been declared.", name);
        }
        return this.variables.declare(name);
    }

    protected QNm resolve(QNm name) throws QueryException {
        Variable dVar;
        QNm resolved;
        if (Query.DEBUG && log.isDebugEnabled()) {
            log.debug("Resolve variable " + String.valueOf(name));
        }
        if ((resolved = this.variables.resolve(name)) == null && (dVar = this.module.getVariables().resolve(name)) != null) {
            return name;
        }
        if (resolved == null) {
            throw new QueryException(ErrorCode.ERR_UNDEFINED_REFERENCE, "Variable $%s has not been declared.", name);
        }
        return resolved;
    }

    protected void openScope() throws QueryException {
        if (Query.DEBUG && log.isDebugEnabled()) {
            log.debug("Open scope");
        }
        this.variables.openScope();
    }

    protected void offerScope() throws QueryException {
        if (Query.DEBUG && log.isDebugEnabled()) {
            log.debug("Offer scope");
        }
        this.variables.offerScope();
    }

    protected void closeScope() throws QueryException {
        if (Query.DEBUG && log.isDebugEnabled()) {
            log.debug("Close scope");
        }
        this.variables.closeScope();
    }

    protected int scopeCount() {
        return this.variables.scopeCount();
    }

    protected void openContextItemScope() throws QueryException {
    }

    protected void closeContextItemScope() throws QueryException {
    }

    protected void referContextItem() throws QueryException {
    }
}

