/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler.analyzer;

import io.brackit.query.QueryException;
import io.brackit.query.atomic.QNm;
import io.brackit.query.compiler.AST;
import io.brackit.query.compiler.Target;
import io.brackit.query.compiler.Unit;
import io.brackit.query.compiler.analyzer.AbstractAnalyzer;
import io.brackit.query.compiler.analyzer.ExprAnalyzer;
import io.brackit.query.expr.DeclVariable;
import io.brackit.query.function.UDF;
import io.brackit.query.jdm.Function;
import io.brackit.query.module.Module;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

abstract class ForwardDeclaration
extends ExprAnalyzer {
    protected final Unit unit;
    protected Set<Unit> deps;
    protected int ctxItemLevel;

    public ForwardDeclaration(Module module, Unit unit) {
        super(module);
        this.unit = unit;
    }

    abstract Target process() throws QueryException;

    Unit getUnit() {
        return this.unit;
    }

    Set<Unit> dependsOn() {
        return this.deps != null ? this.deps : Collections.EMPTY_SET;
    }

    @Override
    protected boolean varRef(AST expr) throws QueryException {
        if (expr.getType() != 26) {
            return false;
        }
        QNm name = (QNm)expr.getValue();
        if (!super.varRef(expr)) {
            return false;
        }
        if (!this.variables.check(name = this.expand(name, AbstractAnalyzer.DefaultNS.EMPTY))) {
            DeclVariable dependency = (DeclVariable)this.module.getVariables().resolve(name);
            if (this.deps == null) {
                this.deps = new HashSet<Unit>();
            }
            this.deps.add(dependency);
        }
        return true;
    }

    @Override
    protected boolean functionCall(AST expr) throws QueryException {
        if (!super.functionCall(expr)) {
            return false;
        }
        if (expr.getType() != 80) {
            return true;
        }
        QNm name = (QNm)expr.getValue();
        Function fun = this.sctx.getFunctions().resolve(name, expr.getChildCount());
        if (fun instanceof UDF) {
            if (this.deps == null) {
                this.deps = new HashSet<Unit>();
            }
            this.deps.add((UDF)fun);
        }
        return true;
    }

    @Override
    protected void openContextItemScope() throws QueryException {
        ++this.ctxItemLevel;
    }

    @Override
    protected void closeContextItemScope() throws QueryException {
        --this.ctxItemLevel;
    }

    @Override
    protected void referContextItem() throws QueryException {
        if (this.ctxItemLevel == 0) {
            if (this.deps == null) {
                this.deps = new HashSet<Unit>();
            }
            this.deps.add(this.module.getVariables().getDftCtxItem());
        }
    }
}

