/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler.analyzer;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AnyURI;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.compiler.AST;
import io.brackit.query.compiler.analyzer.AbstractAnalyzer;
import io.brackit.query.compiler.analyzer.CtxItemDecl;
import io.brackit.query.compiler.analyzer.ForwardDeclaration;
import io.brackit.query.compiler.analyzer.FunctionDecl;
import io.brackit.query.compiler.analyzer.VariableDecl;
import io.brackit.query.expr.DeclVariable;
import io.brackit.query.expr.DefaultCtxItem;
import io.brackit.query.function.UDF;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.type.AnyItemType;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.ItemType;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.module.DecimalFormat;
import io.brackit.query.module.Module;
import io.brackit.query.module.Namespaces;
import java.util.ArrayList;
import java.util.List;

public class PrologAnalyzer
extends AbstractAnalyzer {
    protected final List<ForwardDeclaration> decls;
    protected final List<Import> imports;
    protected final Module module;
    boolean declaredBoundarySpace = false;
    boolean declaredBaseURI = false;
    boolean declaredConstructionMode = false;
    boolean declaredOrderingMode = false;
    boolean declaredEmptyOrder = false;
    boolean declaredCopyNamespaces = false;
    boolean declaredDecimalFormatDefault = false;

    public PrologAnalyzer(Module module, AST prolog) throws QueryException {
        this.module = module;
        this.sctx = module.getStaticContext();
        this.decls = new ArrayList<ForwardDeclaration>();
        this.imports = new ArrayList<Import>();
        this.prolog(prolog);
    }

    public List<Import> getImports() {
        return this.imports;
    }

    public List<ForwardDeclaration> getDeclarations() {
        return this.decls;
    }

    protected boolean prolog(AST prolog) throws QueryException {
        if (prolog.getType() != 3) {
            return false;
        }
        for (int i = 0; i < prolog.getChildCount(); ++i) {
            boolean ok;
            AST decl = prolog.getChild(i);
            boolean bl = ok = this.defaultNamespaceDecl(decl) || this.setter(decl) || this.namespaceDecl(decl) || this.importDecl(decl) || this.contextItemDecl(decl) || this.annotatedDecl(decl) || this.optionDecl(decl);
            if (ok) continue;
            throw new QueryException(ErrorCode.BIT_DYN_INT_ERROR, "Illegal prolog declaration: %s", decl.getStringValue());
        }
        return true;
    }

    private boolean defaultNamespaceDecl(AST decl) throws QueryException {
        if (decl.getType() == 160) {
            String uri = decl.getChild(0).getStringValue();
            this.sctx.getNamespaces().setDefaultElementNamespace(uri);
            return true;
        }
        if (decl.getType() == 161) {
            String uri = decl.getChild(0).getStringValue();
            this.sctx.getNamespaces().setDefaultFunctionNamespace(uri);
            return true;
        }
        return false;
    }

    private boolean setter(AST decl) throws QueryException {
        return this.boundarySpaceDecl(decl) || this.defaultCollationDecl(decl) || this.baseURIDecl(decl) || this.constructionDecl(decl) || this.orderingModeDecl(decl) || this.emptyOrderDecl(decl) || this.revalidationDecl(decl) || this.copyNamespacesDecl(decl) || this.decimalFormatDecl(decl);
    }

    private boolean boundarySpaceDecl(AST decl) throws QueryException {
        if (decl.getType() != 170) {
            return false;
        }
        if (this.declaredBoundarySpace) {
            throw new QueryException(ErrorCode.ERR_BOUNDARY_SPACE_ALREADY_DECLARED, "Boundary-space already declared");
        }
        AST mode = decl.getChild(0);
        this.sctx.setBoundarySpaceStrip(mode.getType() != 171);
        this.declaredBoundarySpace = true;
        return true;
    }

    private boolean defaultCollationDecl(AST decl) throws QueryException {
        if (decl.getType() != 173) {
            return false;
        }
        String col = decl.getChild(0).getStringValue();
        if (!col.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            throw new QueryException(ErrorCode.ERR_UNSUPPORTED_COLLATION, "Unsupported collation: %s", col);
        }
        this.sctx.setDefaultCollation(col);
        return true;
    }

    private boolean baseURIDecl(AST decl) throws QueryException {
        if (decl.getType() != 174) {
            return false;
        }
        if (this.declaredBaseURI) {
            throw new QueryException(ErrorCode.ERR_BASE_URI_ALREADY_DECLARED, "Base URI already declared");
        }
        String uri = decl.getChild(0).getStringValue();
        this.sctx.setBaseURI(new AnyURI(uri));
        this.declaredBaseURI = true;
        return true;
    }

    private boolean constructionDecl(AST decl) throws QueryException {
        if (decl.getType() != 175) {
            return false;
        }
        if (this.declaredConstructionMode) {
            throw new QueryException(ErrorCode.ERR_CONSTRUCTION_ALREADY_DECLARED, "Construction mode already declared");
        }
        AST mode = decl.getChild(0);
        this.sctx.setConstructionModeStrip(mode.getType() != 176);
        this.declaredConstructionMode = true;
        return true;
    }

    private boolean orderingModeDecl(AST decl) throws QueryException {
        if (decl.getType() != 178) {
            return false;
        }
        if (this.declaredOrderingMode) {
            throw new QueryException(ErrorCode.ERR_ORDERING_MODE_ALREADY_DECLARED, "Ordering mode already declared");
        }
        AST mode = decl.getChild(0);
        this.sctx.setOrderingModeOrdered(mode.getType() == 179);
        this.declaredOrderingMode = true;
        return true;
    }

    private boolean emptyOrderDecl(AST decl) throws QueryException {
        if (decl.getType() != 181) {
            return false;
        }
        if (this.declaredEmptyOrder) {
            throw new QueryException(ErrorCode.ERR_EMPTY_ORDER_ALREADY_DECLARED, "Empty order mode already declared");
        }
        AST mode = decl.getChild(0);
        if (mode.getType() == 182) {
            this.sctx.setEmptyOrderGreatest(true);
        } else {
            this.sctx.setEmptyOrderGreatest(false);
        }
        this.declaredEmptyOrder = true;
        return true;
    }

    private boolean revalidationDecl(AST decl) throws QueryException {
        if (decl.getType() != 215) {
            return false;
        }
        throw new QueryException(ErrorCode.BIT_DYN_RT_NOT_IMPLEMENTED_YET_ERROR);
    }

    private boolean copyNamespacesDecl(AST decl) throws QueryException {
        if (decl.getType() != 184) {
            return false;
        }
        if (this.declaredCopyNamespaces) {
            throw new QueryException(ErrorCode.ERR_COPY_NAMESPACES_ALREADY_DECLARED, "Copy-namespaces already declared");
        }
        AST mode = decl.getChild(0);
        if (this.preserveMode(mode)) {
            if (decl.getChildCount() == 2) {
                this.inheritMode(mode);
            }
        } else {
            this.inheritMode(mode);
        }
        this.declaredCopyNamespaces = true;
        return true;
    }

    private boolean preserveMode(AST mode) throws QueryException {
        if (mode.getType() == 185) {
            this.sctx.setCopyNSPreserve(true);
        } else if (mode.getType() == 186) {
            this.sctx.setCopyNSPreserve(false);
        } else {
            return false;
        }
        return true;
    }

    private boolean inheritMode(AST mode) throws QueryException {
        if (mode.getType() == 187) {
            this.sctx.setCopyNSInherit(true);
        } else if (mode.getType() == 188) {
            this.sctx.setCopyNSInherit(false);
        } else {
            return false;
        }
        return true;
    }

    private boolean decimalFormatDecl(AST decl) throws QueryException {
        if (decl.getType() != 189) {
            return false;
        }
        AST format = decl.getChild(0);
        if (format.getType() == 190) {
            if (this.declaredDecimalFormatDefault) {
                throw new QueryException(ErrorCode.ERR_DECIMAL_FORMAT_ALREADY_DECLARED, "Default decimal-format already declared");
            }
            this.declaredDecimalFormatDefault = true;
            DecimalFormat df = new DecimalFormat();
            for (int i = 1; i < decl.getChildCount(); ++i) {
                this.dfProperty(df, decl.getChild(i));
            }
            this.sctx.setDefaultDecimalFormat(df);
        } else {
            QNm name = (QNm)format.getValue();
            name = this.expand(name, AbstractAnalyzer.DefaultNS.EMPTY);
            format.setValue(name);
            if (this.sctx.getDecimalFormat(name) != null) {
                throw new QueryException(ErrorCode.ERR_DECIMAL_FORMAT_ALREADY_DECLARED, "Decimal-format already declared: %s", name);
            }
            DecimalFormat df = new DecimalFormat();
            for (int i = 1; i < decl.getChildCount(); ++i) {
                this.dfProperty(df, decl.getChild(i));
            }
            this.sctx.setDecimalFormat(name, df);
        }
        return true;
    }

    private boolean dfProperty(DecimalFormat df, AST dfProperty) {
        int type = dfProperty.getType();
        if (type == 192) {
            df.setDecimalSeparator(dfProperty.getStringValue());
        } else if (type == 193) {
            df.setGroupingSeparator(dfProperty.getStringValue());
        } else if (type == 194) {
            df.setInfinity(dfProperty.getStringValue());
        } else if (type == 195) {
            df.setMinusSign(dfProperty.getStringValue());
        } else if (type == 196) {
            df.setNaN(dfProperty.getStringValue());
        } else if (type == 197) {
            df.setPercent(dfProperty.getStringValue());
        } else if (type == 198) {
            df.setPerMille(dfProperty.getStringValue());
        } else if (type == 199) {
            df.setZeroDigit(dfProperty.getStringValue());
        } else if (type == 200) {
            df.setDigitSign(dfProperty.getStringValue());
        } else if (type == 201) {
            df.setPatternSeparator(dfProperty.getStringValue());
        } else {
            return false;
        }
        return true;
    }

    private boolean namespaceDecl(AST decl) throws QueryException {
        if (decl.getType() != 4) {
            return false;
        }
        String prefix = decl.getChild(0).getStringValue();
        String uri = decl.getChild(1).getStringValue();
        if ("xml".equals(prefix) || "xmlns".equals(prefix)) {
            throw new QueryException(ErrorCode.ERR_ILLEGAL_NAMESPACE_DECL, "The prefix '%s' must not be used in a namespace declaration", prefix);
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(uri) || "http://www.w3.org/2000/xmlns".equals(uri)) {
            throw new QueryException(ErrorCode.ERR_ILLEGAL_NAMESPACE_DECL, "The URI '%s' must not be used in a namespace declaration", uri);
        }
        Namespaces ns = this.sctx.getNamespaces();
        if (ns.resolve(prefix) != null && !ns.isPredefined(prefix)) {
            throw new QueryException(ErrorCode.ERR_MULTIPLE_NS_BINDINGS_FOR_PREFIX, "Namespace prefix '%s' is already bound to '%s", prefix, uri);
        }
        ns.declare(prefix, uri);
        return true;
    }

    private boolean importDecl(AST decl) throws QueryException {
        return this.schemaImport(decl) || this.moduleImport(decl);
    }

    private boolean schemaImport(AST decl) throws QueryException {
        if (decl.getType() != 162) {
            return false;
        }
        throw new QueryException(ErrorCode.ERR_SCHEMA_IMPORT_FEATURE_NOT_SUPPORTED, "Schema import is not supported.");
    }

    private boolean moduleImport(AST decl) throws QueryException {
        String uri;
        if (decl.getType() != 163) {
            return false;
        }
        AST ns = decl.getChild(0);
        if (ns.getType() == 4) {
            String prefix = ns.getChild(0).getStringValue();
            uri = ns.getChild(1).getStringValue();
            if ("xml".equals(prefix) || "xmlns".equals(prefix)) {
                throw new QueryException(ErrorCode.ERR_ILLEGAL_NAMESPACE_DECL, "The prefix '%s' must not be used for a module import", prefix);
            }
            if (this.sctx.getNamespaces().resolve(prefix) != null) {
                throw new QueryException(ErrorCode.ERR_MULTIPLE_NS_BINDINGS_FOR_PREFIX, "Namespace prefix '%s' is already bound to '%s", prefix, uri);
            }
            this.sctx.getNamespaces().declare(prefix, uri);
        } else {
            uri = ns.getStringValue();
        }
        if (uri.isEmpty()) {
            throw new QueryException(ErrorCode.ERR_ILLEGAL_NAMESPACE_DECL, "Module import with empty target namespace");
        }
        for (Import i : this.imports) {
            if (!i.getURI().equals(uri)) continue;
            throw new QueryException(ErrorCode.ERR_MULTIPLE_IMPORTS_IN_SAME_NS, "Multiple imports of module namespace: %s", uri);
        }
        String[] locs = new String[decl.getChildCount() - 1];
        for (int i = 0; i < locs.length; ++i) {
            locs[i] = decl.getChild(i + 1).getStringValue();
        }
        this.imports.add(new Import(uri, locs));
        return true;
    }

    private boolean contextItemDecl(AST decl) throws QueryException {
        if (decl.getType() != 165) {
            return false;
        }
        DefaultCtxItem var = this.module.getVariables().getDftCtxItem();
        ItemType type = this.itemType(decl.getChild(0));
        var.setType(type);
        AST defaultValue = null;
        AST extVarOrDefaultVal = decl.getChild(1);
        if (extVarOrDefaultVal.getType() == 166) {
            if (decl.getChildCount() == 3) {
                defaultValue = decl.getChild(2);
            }
        } else {
            var.setExternal(false);
            defaultValue = extVarOrDefaultVal;
        }
        if (defaultValue != null) {
            if (this.module.getTargetNS() != null) {
                throw new QueryException(ErrorCode.ERR_CONTEXT_ITEM_VALUE_SPEC_IN_LIBRARY, "Illegal definition of context item value in library module");
            }
            this.decls.add(new CtxItemDecl(this.module, var, decl, defaultValue));
        }
        return true;
    }

    private boolean annotatedDecl(AST decl) throws QueryException {
        return this.varDecl(decl) || this.functionDecl(decl);
    }

    private boolean varDecl(AST decl) throws QueryException {
        SequenceType type;
        if (decl.getType() != 148) {
            return false;
        }
        boolean declaredPrivateOrPublic = false;
        int pos = 0;
        AST child = decl.getChild(pos++);
        while (child.getType() == 124) {
            String annotation = child.getStringValue();
            if ("%public".equals(annotation) || "%private".equals(annotation)) {
                if (declaredPrivateOrPublic) {
                    throw new QueryException(ErrorCode.ERR_VAR_PRIVATE_OR_PUBLIC_ALREADY_DECLARED, "Variable has already been declared private or public");
                }
                declaredPrivateOrPublic = true;
            }
            log.warn("Ingoring variable annotation " + annotation);
            child = decl.getChild(pos++);
        }
        QNm name = (QNm)child.getValue();
        name = this.expand(name, AbstractAnalyzer.DefaultNS.EMPTY);
        child.setValue(name);
        if (this.module.getVariables().isDeclared(name)) {
            throw new QueryException(ErrorCode.ERR_DUPLICATE_VARIABLE_DECL, "Variable $%s has already been declared", name);
        }
        String targetNS = this.module.getTargetNS();
        if (targetNS != null && !targetNS.equals(name.getNamespaceURI())) {
            throw new QueryException(ErrorCode.ERR_FUN_OR_VAR_NOT_IN_TARGET_NS, "Declared variable $%s is not in library module namespace: %s", name, targetNS);
        }
        child = decl.getChild(pos++);
        boolean external = false;
        if (child.getType() == 69) {
            type = this.sequenceType(child);
            child = decl.getChild(pos++);
        } else {
            type = new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany);
        }
        AST defaultValue = null;
        if (child.getType() == 166) {
            external = true;
            if (pos < decl.getChildCount()) {
                defaultValue = decl.getChild(pos);
            }
        } else {
            defaultValue = child;
        }
        DeclVariable var = this.module.getVariables().declare(name, type, external);
        if (defaultValue != null) {
            this.decls.add(new VariableDecl(this.module, var, decl, defaultValue));
        }
        return true;
    }

    private boolean functionDecl(AST decl) throws QueryException {
        if (decl.getType() != 168) {
            return false;
        }
        boolean declaredPrivateOrPublic = false;
        boolean updating = false;
        int pos = 0;
        AST child = decl.getChild(pos++);
        while (child.getType() == 124) {
            boolean ignored = true;
            String annotation = child.getStringValue();
            if ("public".equals(annotation) || "private".equals(annotation)) {
                if (declaredPrivateOrPublic) {
                    throw new QueryException(ErrorCode.ERR_FUN_PRIVATE_OR_PUBLIC_ALREADY_DECLARED, "Function has already been declared private or public");
                }
                declaredPrivateOrPublic = true;
            } else if ("updating".equals(annotation)) {
                updating = true;
                ignored = false;
            }
            if (ignored) {
                log.warn("Ignoring function annotation " + annotation);
            }
            child = decl.getChild(pos++);
        }
        QNm name = (QNm)child.getValue();
        name = this.expand(name, AbstractAnalyzer.DefaultNS.FUNCTION);
        child.setValue(name);
        if (name.getNamespaceURI().isEmpty()) {
            throw new QueryException(ErrorCode.ERR_FUNCTION_DECL_NOT_IN_NS, "Function %s is not in a namespace", name);
        }
        String targetNS = this.module.getTargetNS();
        if (targetNS != null && !targetNS.equals(name.getNamespaceURI())) {
            throw new QueryException(ErrorCode.ERR_FUN_OR_VAR_NOT_IN_TARGET_NS, "Declared function %s is not in library module namespace: %s", name, targetNS);
        }
        String uri = name.getNamespaceURI();
        if (uri.equals("http://www.w3.org/XML/1998/namespace") || uri.equals("http://www.w3.org/2001/XMLSchema") || uri.equals("http://www.w3.org/2001/XMLSchema-instance") || uri.equals("http://www.w3.org/2005/xpath-functions") || uri.equals("http://www.w3.org/2005/xpath-functions/math")) {
            throw new QueryException(ErrorCode.ERR_FUNCTION_DECL_IN_ILLEGAL_NAMESPACE, "Declared function %s is in illegal namespace: %s", name, uri);
        }
        int noOfParameters = decl.getChildCount() - pos - 2;
        QNm[] pNames = new QNm[noOfParameters];
        SequenceType[] pTypes = new SequenceType[noOfParameters];
        for (int i = 0; i < noOfParameters; ++i) {
            child = decl.getChild(pos++);
            pNames[i] = (QNm)child.getChild(0).getValue();
            pNames[i] = this.expand(pNames[i], AbstractAnalyzer.DefaultNS.EMPTY);
            child.getChild(0).setValue(pNames[i]);
            for (int j = 0; j < i; ++j) {
                if (pNames[i].atomicCmp(pNames[j]) != 0) continue;
                throw new QueryException(ErrorCode.ERR_DUPLICATE_FUN_PARAMETER, "Duplicate parameter in declared function %s: %s", name, pNames[j]);
            }
            pTypes[i] = child.getChildCount() == 2 ? this.sequenceType(child.getChild(1)) : SequenceType.ITEM_SEQUENCE;
        }
        child = decl.getChild(pos++);
        SequenceType resultType = this.sequenceType(child);
        child = decl.getChild(pos);
        Signature signature = new Signature(resultType, pTypes);
        UDF udf = new UDF(name, signature, updating);
        this.sctx.getFunctions().declare(udf);
        AST body = child;
        this.decls.add(new FunctionDecl(this.module, udf, pNames, body));
        return true;
    }

    private boolean optionDecl(AST option) throws QueryException {
        if (option.getType() != 202) {
            return false;
        }
        QNm name = (QNm)option.getChild(0).getValue();
        name = this.expand(name, AbstractAnalyzer.DefaultNS.EMPTY);
        option.getChild(0).setValue(name);
        Str value = (Str)option.getChild(1).getValue();
        this.module.addOption(name, value);
        return true;
    }

    public static class Import {
        final String uri;
        final String[] locs;

        public Import(String uri, String[] locs) {
            this.uri = uri;
            this.locs = locs;
        }

        public String getURI() {
            return this.uri;
        }

        public String[] getLocations() {
            return this.locs;
        }
    }
}

