/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler.analyzer;

import io.brackit.query.atomic.QNm;
import java.util.HashMap;

public class VarScopes {
    private int idSequence;
    private final Scope root;
    private Scope current;
    private Scope resolveIn;
    private int level;

    public VarScopes() {
        this.current = this.root = new Scope(null);
        this.resolveIn = this.root;
    }

    public int scopeCount() {
        return this.level;
    }

    public void openScope() {
        ++this.level;
        this.current = new Scope(this.current);
    }

    public void offerScope() {
        this.resolveIn = this.current;
    }

    public void closeScope() {
        if (this.level == 0) {
            throw new RuntimeException();
        }
        --this.level;
        this.resolveIn = this.current = this.current.parent;
    }

    public boolean check(QNm name) {
        return this.current.mapping.containsKey(name);
    }

    public QNm declare(QNm name) {
        Variable variable;
        if (this.level > 0) {
            int n = this.idSequence++;
            variable = new Variable(new QNm(name.getNamespaceURI(), name.getPrefix(), name.getLocalName() + ";" + n));
        } else {
            variable = new Variable(name);
        }
        Variable var = variable;
        this.current.mapping.put(name, var);
        return var.name;
    }

    public QNm resolve(QNm name) {
        Variable var;
        Scope scope = this.resolveIn;
        while ((var = scope.mapping.get(name)) == null && (scope = scope.parent) != null) {
        }
        if (var == null) {
            return null;
        }
        return var.name;
    }

    private static class Scope {
        Scope parent;
        HashMap<QNm, Variable> mapping = new HashMap();

        Scope(Scope parent) {
            this.parent = parent;
        }

        public String toString() {
            return this.mapping.toString();
        }
    }

    public static class Variable {
        QNm name;

        public Variable(QNm name) {
            this.name = name;
        }

        public String toString() {
            return this.name.toString();
        }
    }
}

