/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler.optimizer.walker;

import io.brackit.query.Query;
import io.brackit.query.compiler.AST;
import io.brackit.query.module.StaticContext;
import io.brackit.query.util.dot.DotUtil;

public class Walker {
    protected final StaticContext sctx;
    private AST root;
    private int snapshot;
    private boolean restart;

    public Walker() {
        this.sctx = null;
    }

    public Walker(StaticContext sctx) {
        this.sctx = sctx;
    }

    public final AST walk(AST node) {
        this.snapshot = 0;
        this.root = node;
        this.root = this.prepare(this.root);
        AST result = this.walkInternal(this.root);
        while (result != this.root) {
            this.root = result;
            result = this.walkInternal(this.root);
        }
        this.root = result;
        this.root = this.finish(this.root);
        return this.root;
    }

    protected AST walkInternal(AST node) {
        AST replacement = this.visit(node);
        if (replacement == null) {
            return node;
        }
        if (replacement != node) {
            this.restart = true;
            return replacement;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            AST child = node.getChild(i);
            AST result = this.walkInternal(child);
            while (result != child) {
                if (result.getParent() == node) {
                    child = result;
                    result = this.walkInternal(child);
                    continue;
                }
                return result;
            }
            if (!this.restart) continue;
            --i;
            this.restart = false;
            this.snapshot();
        }
        return node;
    }

    protected AST prepare(AST root) {
        return root;
    }

    protected AST finish(AST root) {
        return root;
    }

    protected AST visit(AST node) {
        System.out.println("Visiting Node " + String.valueOf(node.getValue()));
        return node;
    }

    protected void snapshot() {
        if (Query.DEBUG) {
            DotUtil.drawDotToFile(this.root.dot(), Query.DEBUG_DIR, this.getClass().getSimpleName() + "_" + this.snapshot++);
        }
    }
}

